/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.policy;

import hiro.yoshioka.gef.command.ConditionMoveCommand;
import hiro.yoshioka.gef.command.CreateConditionCommand;
import hiro.yoshioka.gef.command.TableMoveCommand;
import hiro.yoshioka.gef.figures.ConditionFigure;
import hiro.yoshioka.gef.figures.TableFigure;
import hiro.yoshioka.gef.model.CommonConditionModel;
import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.gef.part.CommonConditionPart;
import hiro.yoshioka.gef.part.TablePart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class SchemaXYLayoutPolicy
extends XYLayoutEditPolicy {
    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        TablePart tp = null;
        CommonConditionPart cp = null;
        if (child instanceof TablePart) {
            tp = (TablePart)child;
        } else if (child instanceof CommonConditionPart) {
            cp = (CommonConditionPart)child;
        } else {
            return null;
        }
        if (!(constraint instanceof Rectangle)) {
            return null;
        }
        if (tp != null) {
            Table table = tp.getTable();
            TableFigure figure = (TableFigure)tp.getFigure();
            Rectangle oldBounds = figure.getBounds();
            Rectangle newBounds = (Rectangle)constraint;
            if (oldBounds.width != newBounds.width && newBounds.width != -1) {
                return null;
            }
            if (oldBounds.height != newBounds.height && newBounds.height != -1) {
                return null;
            }
            TableMoveCommand command = new TableMoveCommand(table, oldBounds.getCopy(), newBounds.getCopy());
            return command;
        }
        CommonConditionModel cm = cp.getCmnCondModel();
        ConditionFigure figure = (ConditionFigure)cp.getFigure();
        Rectangle oldBounds = figure.getBounds();
        Rectangle newBounds = (Rectangle)constraint;
        if (oldBounds.width != newBounds.width && newBounds.width != -1) {
            return null;
        }
        if (oldBounds.height != newBounds.height && newBounds.height != -1) {
            return null;
        }
        ConditionMoveCommand command = new ConditionMoveCommand(cm, oldBounds.getCopy(), newBounds.getCopy());
        return command;
    }

    public Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        Rectangle rectangle = (Rectangle)fig.getParent().getLayoutManager().getConstraint(fig);
        if (rectangle == null) {
            rectangle = fig.getBounds();
        }
        return rectangle;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newObj = request.getNewObject();
        if (!(newObj instanceof CommonConditionModel)) {
            return null;
        }
        CreateConditionCommand command = new CreateConditionCommand();
        Rectangle constraint = (Rectangle)this.getConstraintFor(request);
        CommonConditionModel model = (CommonConditionModel)newObj;
        model.setConstraint(constraint);
        command.setSchemaModel(this.getHost().getModel());
        command.setCommonConditionModel(model);
        return command;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }
}

