/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator;

import hiro.yoshioka.generator.MyFormatter;
import hiro.yoshioka.generator.XXXMode;
import hiro.yoshioka.generator.bean.GeneratorBean;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.util.SQLDataType;
import java.util.Date;

public class XxxFormatter
extends MyFormatter {
    private XXXMode mode;
    private static final String NUMBER_9 = "9";
    private static final String CHAR_X = "X";
    private static final String CHAR_X_BAR = "X--------X";
    private static final String CHAR_OTOHU_BAR = "\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d\ufffd\uff7f\uff7d";
    private static final String CHAR_NUMBERS = "1234567890";

    public XxxFormatter() {
    }

    public XxxFormatter(GeneratorBean generator) {
        super(generator, null);
        this.resetMode(XXXMode.BAR_X);
    }

    public XXXMode getMode() {
        return this.mode;
    }

    public void setMode(XXXMode mode) {
        this.mode = mode;
    }

    public void resetMode(XXXMode mode) {
        DBColumnValue column = this.generator.getParent().getColumn();
        SQLDataType dataType = column.getType();
        this.mode = mode;
        this.format = dataType.isDate() ? "%tF" : (dataType.isTimeStamp() ? "%tF %1$tT" : (dataType.isTime() ? "%tT" : ""));
    }

    @Override
    public String getExtraFormat() {
        return this.mode.getExample();
    }

    public String getSubStrString(int len, String str) {
        StringBuilder buf;
        block2: {
            if (len <= 0) {
                len = 1;
            }
            buf = new StringBuilder();
            do {
                buf.append(str);
                if (buf.length() == len) break block2;
            } while (buf.length() <= len);
            return buf.substring(0, len);
        }
        return buf.toString();
    }

    public String getAllString(int len, String str) {
        if (len <= 0) {
            len = 1;
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < len) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    @Override
    public String formatedString(int sumGeneratedGroupCount, int numOfGroupInCounter, int totalCounter, Date today) {
        DBColumnValue column;
        String message;
        block20: {
            SQLDataType dataType;
            block21: {
                message = "";
                column = this.generator.getParent().getColumn();
                dataType = column.getType();
                if (dataType.isBinary() || dataType.isBlob()) {
                    return "NULL";
                }
                if (dataType.isDateOrDateTimeOrTime()) {
                    message = String.format(this.format, new Date());
                    break block20;
                }
                if (!SQLDataType.BIT.equals((Object)dataType)) break block21;
                return "1";
            }
            try {
                int n = column.getSize();
                if (n > 1000) {
                    n = 1000;
                }
                if (n > 1) {
                    switch (dataType) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: {
                            --n;
                            break;
                        }
                        case NUMERIC: 
                        case DECIMAL: {
                            --n;
                            if (column.getDecimalDigits() <= 0) break;
                            n -= column.getDecimalDigits();
                        }
                    }
                }
                switch (this.mode) {
                    case ALL_X: {
                        if (dataType.isNumerics()) {
                            message = this.getAllString(n, NUMBER_9);
                            break;
                        }
                        message = this.getAllString(n, CHAR_X);
                        break;
                    }
                    case BAR_X: {
                        if (dataType.isNumerics()) {
                            message = this.getAllString(n, NUMBER_9);
                            break;
                        }
                        message = this.getSubStrString(n, CHAR_X_BAR);
                        break;
                    }
                    case OTOHU: {
                        if (dataType.isNumerics()) {
                            message = this.getAllString(n, NUMBER_9);
                            break;
                        }
                        message = this.getSubStrString(n / 2, CHAR_OTOHU_BAR);
                        break;
                    }
                    case COUNT: {
                        message = this.getSubStrString(n, CHAR_NUMBERS);
                        break;
                    }
                    default: {
                        message = "";
                        break;
                    }
                }
            }
            catch (Throwable e) {
                this.fLogger.warn((Object)e);
                e.printStackTrace();
            }
        }
        return this.formatedString(message, column);
    }
}

