/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.job.AbsBasicPoiWriter;
import hiro.yoshioka.sql.AbsBasicSQL;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;

public class ERWriter
extends AbsBasicPoiWriter {
    File saveFile;

    public ERWriter(File file) {
        this.saveFile = file;
    }

    public static void main(String[] args) {
        DBRoot root = AbsBasicSQL.loadDBRoot((File)new File("D:/eclipse_rcp/serialized/-463472880"));
        new ERWriter(new File("C:/ER_Diagram.xls")).doWork(root);
    }

    public static HSSFChildAnchor createChildAnchor(int starty, int startx, int wCol, int hRow) {
        return new HSSFChildAnchor((int)((short)startx), starty, (int)((short)(wCol += startx)), hRow += starty);
    }

    public static HSSFClientAnchor createAnchor(int starty, int startx, int wCol, int hRow) {
        return new HSSFClientAnchor((int)((short)startx), starty, (int)((short)(wCol += startx)), hRow += starty, (short)wCol, hRow, (short)startx, starty);
    }

    public void doWork(DBRoot root) {
        try {
            HSSFWorkbook hwb = new HSSFWorkbook();
            HSSFFont font = hwb.createFont();
            font.setUnderline((byte)1);
            font.setColor((short)10);
            HSSFFont fontb = hwb.createFont();
            fontb.setColor((short)12);
            HSSFSheet sheet = hwb.createSheet("new sheet");
            sheet.getPrintSetup().setPaperSize((short)9);
            int i = 0;
            while (i < 50) {
                sheet.setColumnWidth((short)i, (short)980);
                ++i;
            }
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            IDBSchema schema = root.getCurrentSchema();
            IDBTable[] tables = schema.getTableOrViews();
            int i2 = 0;
            int topY = 0;
            int topX = 0;
            while (i2 < tables.length) {
                if (i2 % 6 == 0) {
                    topY += 10;
                }
                topX = i2 % 10 * 6;
                HSSFTextbox textbox1 = patriarch.createTextbox(ERWriter.createAnchor(topY, topX, 5, 1));
                textbox1.setString((RichTextString)new HSSFRichTextString(tables[i2].getUName()));
                textbox1.setLineStyle(-1);
                textbox1.setNoFill(true);
                IDBColumn[] columns = tables[i2].getColumns();
                HSSFShapeGroup group = patriarch.createGroup(new HSSFClientAnchor(0, 0, 900, 200, (short)topX, topY + 1, (short)(topX + 5), topY + columns.length + 1));
                group.setLineStyle(-1);
                int k = 0;
                while (k < columns.length) {
                    HSSFTextbox textbox2 = group.createTextbox(new HSSFChildAnchor(1, k * 50, 800, (k + 1) * 50));
                    textbox2.setLineStyle(-1);
                    textbox2.setNoFill(true);
                    HSSFRichTextString str = new HSSFRichTextString(columns[k].getUName());
                    if (columns[k].isPkey()) {
                        str.applyFont((Font)font);
                    } else if (columns[k].isNotNull()) {
                        str.applyFont((Font)fontb);
                    }
                    textbox2.setString((RichTextString)str);
                    ++k;
                }
                ++i2;
            }
            FileOutputStream fileOut = new FileOutputStream("c:/createBox.xls");
            hwb.write((OutputStream)fileOut);
            fileOut.close();
            System.out.println("Your excel file has been generated");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doWork(Table[] tableModels) {
        try {
            HSSFFont font = this.fHSSFWorkbook.createFont();
            font.setUnderline((byte)1);
            font.setColor((short)10);
            HSSFFont fontb = this.fHSSFWorkbook.createFont();
            fontb.setColor((short)12);
            HSSFSheet sheet = this.fHSSFWorkbook.createSheet("new sheet");
            int i = 0;
            while (i < 50) {
                sheet.setColumnWidth((short)i, (short)980);
                ++i;
            }
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            int maxHeight = 10;
            int i2 = 0;
            int topY = 0;
            int topX = 0;
            while (i2 < tableModels.length) {
                DBTableValue table = tableModels[i2].getDBTable();
                if (i2 % 6 == 0) {
                    topY += maxHeight;
                    maxHeight = 10;
                }
                topX = i2 % 6 * 6;
                HSSFTextbox textbox1 = patriarch.createTextbox(ERWriter.createAnchor(topY, topX, 5, 1));
                textbox1.setString((RichTextString)new HSSFRichTextString(table.getUName()));
                textbox1.setLineStyle(-1);
                textbox1.setNoFill(true);
                DBColumnValue[] columns = table.getColumns();
                HSSFSimpleShape sh = patriarch.createSimpleShape(ERWriter.createAnchor(topY + 1, topX, 5, columns.length));
                sh.setShapeType(2);
                if (columns.length + 3 > maxHeight) {
                    maxHeight = columns.length + 3;
                }
                int totalK = 0;
                int k = 0;
                while (k < columns.length) {
                    if (columns[k].isPkey()) {
                        HSSFTextbox textbox2 = patriarch.createTextbox(ERWriter.createAnchor(topY + totalK + 1, topX, 4, 1));
                        textbox2.setLineStyle(-1);
                        textbox2.setNoFill(true);
                        HSSFRichTextString str = new HSSFRichTextString(columns[k].getUName());
                        str.applyFont((Font)font);
                        textbox2.setString((RichTextString)str);
                        ++totalK;
                    }
                    ++k;
                }
                HSSFSimpleShape lineShape = patriarch.createSimpleShape(ERWriter.createAnchor(topY + totalK + 1, topX, 5, 0));
                lineShape.setShapeType(1);
                int k2 = 0;
                while (k2 < columns.length) {
                    if (!columns[k2].isPkey()) {
                        HSSFTextbox textbox2 = patriarch.createTextbox(ERWriter.createAnchor(topY + totalK + 1, topX, 4, 1));
                        textbox2.setLineStyle(-1);
                        textbox2.setNoFill(true);
                        HSSFRichTextString str = new HSSFRichTextString(columns[k2].getUName());
                        if (columns[k2].isNotnull()) {
                            str.applyFont((Font)fontb);
                        }
                        textbox2.setString((RichTextString)str);
                        ++totalK;
                    }
                    ++k2;
                }
                ++i2;
            }
            this.save(this.saveFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

