/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.job.AbsBasicPoiWriter;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.sql.resource.xml.DBCrossRefferenceValue;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.sql.resource.xml.STC;
import java.io.File;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.util.Region;

public class ExERDWriter
extends AbsBasicPoiWriter {
    File saveFile;
    int[] bai = new int[]{3, 6, 5, 1, 7, 7, 3, 2, 1, 1, 1, 7};
    String[] HEADER = new String[]{"Table/View", "LOG. NAME", "PHY. NAME", "COL. No.", "LOG. COL.", "PHY. COL.", "DATA TYPE", "SCALE", "NOT NULL", "PRI.", "FOR.", "RFFER", "DEPEND", "DEFAULT"};

    public ExERDWriter(File saveFile) {
        this.saveFile = saveFile;
    }

    protected HSSFCellStyle getLightGrayBoxStyle() {
        return this.getHSSFCellStyle(true, (short)1, this.fd.getName(), (short)this.fd.getHeight(), false, (short)-1, (short)22, (short)1);
    }

    public void doWork(Table[] tableModels) {
        try {
            HSSFSheet sheet = this.fHSSFWorkbook.createSheet("new sheet");
            sheet.getPrintSetup().setPaperSize((short)9);
            int i = 0;
            while (i < this.bai.length) {
                sheet.setColumnWidth((short)i, (short)(980 * this.bai[i]));
                HSSFCell header = this.createHSSFCell(sheet, (short)i, 2);
                header.setCellValue(this.HEADER[i]);
                header.setCellStyle(this.getLightGrayBoxStyle());
                ++i;
            }
            HashMap<String, HashMap<String, String>> allMap = new HashMap<String, HashMap<String, String>>();
            int i2 = 0;
            while (i2 < tableModels.length) {
                DBTableValue table = tableModels[i2].getDBTable();
                DBCrossRefferenceValue[] cross = table.getCrossRefferenceValue();
                int ic = 0;
                while (ic < cross.length) {
                    STC stc = (STC)cross[ic].getPkList().first();
                    STC stc2 = (STC)cross[ic].getFkList().first();
                    HashMap<String, String> myMap = (HashMap<String, String>)allMap.get(stc2.getTable());
                    if (myMap == null) {
                        myMap = new HashMap<String, String>();
                        allMap.put(stc2.getTable(), myMap);
                    }
                    myMap.put(stc2.getColumn(), String.valueOf(stc.getTable()) + "." + stc2.getColumn());
                    ++ic;
                }
                ++i2;
            }
            i2 = 0;
            int rownum = 3;
            while (i2 < tableModels.length) {
                DBTableValue table = tableModels[i2].getDBTable();
                DBColumnValue[] columns = table.getColumns();
                HSSFCell cell = this.createHSSFCell(sheet, (short)0, rownum);
                if (table.isType_table()) {
                    cell.setCellValue("TABLE");
                } else if (table.isType_view()) {
                    cell.setCellValue("VIEW");
                } else {
                    cell.setCellValue("UNKNOWN");
                }
                sheet.addMergedRegion((Region)new org.apache.poi.hssf.util.Region(rownum - 1, 0, rownum - 2 + columns.length, 0));
                cell = this.createHSSFCell(sheet, (short)1, rownum);
                cell.setCellValue(table.getComment());
                sheet.addMergedRegion((Region)new org.apache.poi.hssf.util.Region(rownum - 1, 1, rownum - 2 + columns.length, 1));
                cell = this.createHSSFCell(sheet, (short)2, rownum);
                cell.setCellValue(table.getName());
                sheet.addMergedRegion((Region)new org.apache.poi.hssf.util.Region(rownum - 1, 2, rownum - 2 + columns.length, 2));
                HashMap myMap = (HashMap)allMap.get(table.getName());
                int k = 0;
                while (k < columns.length) {
                    String fk;
                    cell = this.createHSSFCell(sheet, (short)3, rownum);
                    cell.setCellValue((double)(k + 1));
                    cell = this.createHSSFCell(sheet, (short)4, rownum);
                    cell.setCellValue(columns[k].getComment());
                    cell = this.createHSSFCell(sheet, (short)5, rownum);
                    cell.setCellValue(columns[k].getName());
                    cell = this.createHSSFCell(sheet, (short)6, rownum);
                    cell.setCellValue(columns[k].getDataTypeString());
                    cell = this.createHSSFCell(sheet, (short)7, rownum);
                    cell.setCellValue((double)columns[k].getSize());
                    cell = this.createHSSFCell(sheet, (short)8, rownum);
                    if (columns[k].isNotnull()) {
                        cell.setCellValue("yes");
                    }
                    cell = this.createHSSFCell(sheet, (short)9, rownum);
                    if (columns[k].isPkey()) {
                        cell.setCellValue("1");
                    }
                    if (myMap != null && (fk = (String)myMap.get(columns[k].getName())) != null) {
                        cell = this.createHSSFCell(sheet, (short)10, rownum);
                        cell.setCellValue("yes");
                        cell = this.createHSSFCell(sheet, (short)11, rownum);
                        cell.setCellValue(fk);
                    }
                    ++k;
                    ++rownum;
                }
                ++i2;
            }
            this.save(this.saveFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

