/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh2.ReflectionPreparedStatement;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ImportTableFromCSVJob
extends Job {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    File[] fImportFiles;
    boolean doTruncate;
    boolean firstName;
    String encoding;
    private ConnectionProperties connectionProperties;

    public ImportTableFromCSVJob(File[] input, String encoding, boolean truncFlg, boolean firstName) {
        super("CSV Import");
        this.encoding = encoding;
        this.fImportFiles = input;
        this.doTruncate = truncFlg;
        this.firstName = firstName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.OK_STATUS;
        try {
            int i = 0;
            while (i < this.fImportFiles.length) {
                this.doWork(i, this.fImportFiles[i], monitor);
                monitor.worked(1);
                ++i;
            }
        }
        catch (Throwable e) {
            this.fLogger.error((Object)e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    private void doWork(int idx, File inputFile, IProgressMonitor monitor) throws SQLException, IOException {
        String tableName = inputFile.getName().replaceAll(".csv.*", "");
        monitor.beginTask("CSV Import[" + inputFile.getName() + "]", this.fImportFiles.length);
        this.fLogger.trace((Object)("DO TRUNCATE[" + this.doTruncate + "] TABLE[" + tableName + "]"));
        ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(this.connectionProperties);
        if (this.doTruncate) {
            if (sql.canDoOperation(SQLOperationType.TRUNCATE)) {
                sql.executePrepare("TRUNCATE TABLE " + tableName, (Object[])new String[0]);
            } else {
                sql.executePrepare("DELETE FROM " + tableName, (Object[])StringUtil.EMPTY_STRING_ARRAY);
            }
        }
        String[][] datum = CSVUtil.splitByTAB_quoteDouble((File)inputFile, (String)this.encoding);
        ResultSetMetaCopy meta = null;
        meta = this.firstName ? sql.getTableMetaCopy(tableName, datum[0]) : sql.getTableMetaCopy(tableName);
        int row = 1;
        if (!this.firstName) {
            row = 0;
        }
        while (row < datum.length) {
            ReflectionPreparedStatement ref = new ReflectionPreparedStatement(this.connectionProperties.getDatabaseType(), meta, datum[row], tableName, null);
            boolean ret = sql.execute(ref);
            monitor.subTask(String.valueOf(row) + " line number , worked [" + ret + "]");
            ++row;
        }
    }

    public void setConnectionProperties(ConnectionProperties selectedConnectionProperties) {
        this.connectionProperties = selectedConnectionProperties;
    }
}

