/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.job.AbsBasicPoiWriter;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh.diff.DiffElementType;
import hiro.yoshioka.sdh.pair.DifferenceStringData;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.util.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResultSetExcelWriter
extends AbsBasicPoiWriter {
    ResultSetDataHolder2[] fResultSetDataHolder;
    ResultSetDataHolder2[] fCompareResultSetDataHolder;
    String[] remarks;
    File fSaveFile;
    static boolean DO_COLUMN_BREAK = true;
    static boolean DO_SHEET_BREAK = true;
    static int COLUMN_BREAK = 14;
    static int CELL_WIDTH = 2304;
    private HashMap<String, Integer> nameMap = new HashMap();
    protected boolean supportDiff;

    public ResultSetExcelWriter(ResultSetDataHolder2[] rdh, File savefile) {
        this.fResultSetDataHolder = rdh;
        this.fSaveFile = savefile;
    }

    public static void configure(boolean colBreak, int breakNum, int width, boolean sheetBreak) {
        DO_COLUMN_BREAK = colBreak;
        COLUMN_BREAK = breakNum;
        CELL_WIDTH = width;
        DO_SHEET_BREAK = sheetBreak;
    }

    public ResultSetExcelWriter(ResultSetDataHolder2[] rdh, ResultSetDataHolder2[] rdh2, File savefile, boolean supportDiff) {
        this.fResultSetDataHolder = rdh;
        this.fCompareResultSetDataHolder = rdh2;
        this.fSaveFile = savefile;
        this.supportDiff = supportDiff;
    }

    public void setRemarks(String[] remarks) {
        this.remarks = remarks;
    }

    public IStatus write(IProgressMonitor monitor) {
        this.fLogger.trace((Object)"start");
        try {
            int sum = 0;
            this.fLogger.trace((Object)("fResultSetDataHolder == null ? " + (this.fResultSetDataHolder == null)));
            int i = 0;
            while (i < this.fResultSetDataHolder.length) {
                sum += this.fResultSetDataHolder[i].getKey().length;
                ++i;
            }
            this.fLogger.trace((Object)("fCompareResultSetDataHolder == null ? " + (this.fCompareResultSetDataHolder == null)));
            i = 0;
            while (this.fCompareResultSetDataHolder != null && i < this.fCompareResultSetDataHolder.length) {
                sum += this.fCompareResultSetDataHolder[i].getKey().length;
                ++i;
            }
            this.fLogger.trace((Object)"EXCEL-FileOutput");
            monitor.beginTask("Generate EXCEL", sum);
            if (this.write_sub(this.fResultSetDataHolder, monitor) == Status.CANCEL_STATUS) {
                this.fLogger.trace((Object)"cancelllllllllllllllllllllllll");
                return Status.CANCEL_STATUS;
            }
            if (this.fCompareResultSetDataHolder != null && this.write_sub(this.fCompareResultSetDataHolder, monitor) == Status.CANCEL_STATUS) {
                return Status.CANCEL_STATUS;
            }
            this.save(this.fSaveFile);
        }
        catch (Exception e) {
            this.fLogger.error((Object)"", (Throwable)e);
        }
        this.fLogger.trace((Object)"end");
        return Status.OK_STATUS;
    }

    private String get32767(String str) {
        if (str.getBytes().length > Short.MAX_VALUE) {
            return str.substring(0, 16000);
        }
        return str;
    }

    protected IStatus write_sub(ResultSetDataHolder2[] rdh, IProgressMonitor monitor) {
        HSSFSheet sheet = null;
        String sheetName = null;
        HSSFSheet pictureSheet = null;
        HSSFPatriarch partriarch = null;
        int iPictureRow = 3;
        if (!DO_SHEET_BREAK) {
            sheetName = "sheet" + this.fHSSFWorkbook.getNumberOfSheets();
            sheet = this.fHSSFWorkbook.createSheet(sheetName);
            sheet.getPrintSetup().setPaperSize((short)9);
        }
        int irow = 3;
        if (rdh.length > 0) {
            HSSFCell cell_title = this.createHSSFCell(sheet, "A", 1);
            String display = rdh[0].getConnectionDisplayString();
            StringUtil.isEmpty((Object)display);
            cell_title.setCellValue(String.format("DisplayName:%s", display));
        }
        boolean sima = PreferenceUtil.getBoolean("EXCEL_DO_SIMASIMA");
        boolean blob = PreferenceUtil.getBoolean("SQL_BLOB_BOOLEAN");
        int rdh_num = 0;
        while (rdh_num < rdh.length) {
            sheetName = rdh[rdh_num].getTableNameE();
            this.fLogger.trace((Object)("   rdh_num=" + rdh_num));
            Integer integer = this.nameMap.get(sheetName);
            if (integer == null) {
                integer = new Integer(0);
                this.nameMap.put(sheetName, integer);
            } else {
                integer = new Integer(integer + 1);
                this.nameMap.put(sheetName, integer);
            }
            if (integer > 0) {
                sheetName = String.valueOf(sheetName) + "_" + integer;
            }
            if (DO_SHEET_BREAK) {
                sheet = this.fHSSFWorkbook.createSheet(sheetName);
                irow = 3;
            }
            HSSFCell cell = this.createHSSFCell(sheet, "A", irow);
            try {
                if (this.remarks != null && this.remarks.length > rdh_num) {
                    cell.setCellValue("\u25a0" + sheetName + " " + this.remarks[rdh_num]);
                } else {
                    cell.setCellValue("\u25a0" + sheetName);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            ++irow;
            int i = 0;
            while (i < COLUMN_BREAK) {
                sheet.setColumnWidth((short)i, (short)(CELL_WIDTH * 256));
                ++i;
            }
            boolean rowFlg = PreferenceUtil.getBoolean("WRITE_ROW");
            String[] keys = null;
            keys = rowFlg ? rdh[rdh_num].getKey() : rdh[rdh_num].getNoRowKeys();
            this.fLogger.trace((Object)("      keys.length=" + keys.length));
            int i2 = 0;
            while (i2 < keys.length) {
                monitor.subTask("Now Writing column[" + (i2 + 1) + "]");
                cell = this.createHSSFCell(sheet, (short)(i2 % COLUMN_BREAK), irow);
                cell.setCellValue(this.get32767(keys[i2]));
                cell.setCellStyle(this.styleHeader);
                int j = 0;
                while (j < rdh[rdh_num].getRowCount()) {
                    short cell_color = -1;
                    short fill_pattern = -1;
                    short border = 1;
                    short iValColIdx = (short)(i2 % COLUMN_BREAK);
                    int iValRowIdx = irow + j + 1;
                    cell = this.createHSSFCell(sheet, iValColIdx, iValRowIdx);
                    StringRecordData sr = null;
                    boolean doPicture = false;
                    int rowLesColIdx = i2;
                    if (!rowFlg) {
                        ++rowLesColIdx;
                    }
                    sr = rdh[rdh_num].getStringRecordRow(j)[rowLesColIdx];
                    boolean bb = rdh[rdh_num].isBinaly(rowLesColIdx) || rdh[rdh_num].isBlob(rowLesColIdx);
                    doPicture = !this.supportDiff && blob && bb;
                    cell.setCellValue(sr.getString());
                    if (doPicture) {
                        File picture = new File(rdh[rdh_num].getStringData()[j][rowLesColIdx]);
                        int picture_type = -9;
                        if (picture.getName().endsWith("jpg")) {
                            picture_type = 5;
                        } else if (picture.getName().endsWith("png")) {
                            picture_type = 6;
                        }
                        if (picture.exists() && picture.length() > 0L) {
                            byte[] bytes;
                            block51: {
                                bytes = null;
                                if (picture.getName().endsWith("gif")) {
                                    try {
                                        picture_type = 5;
                                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                                        BufferedImage image = ImageIO.read(picture);
                                        ImageIO.write((RenderedImage)image, "jpg", output);
                                        output.flush();
                                        bytes = output.toByteArray();
                                        output.close();
                                    }
                                    catch (IOException iOException) {}
                                } else {
                                    bytes = new byte[(int)picture.length()];
                                    FileInputStream is = null;
                                    try {
                                        try {
                                            is = new FileInputStream(picture);
                                            is.read(bytes);
                                        }
                                        catch (Exception e) {
                                            this.fLogger.warn((Object)e);
                                            if (is != null) {
                                                try {
                                                    is.close();
                                                }
                                                catch (IOException iOException) {}
                                            }
                                            break block51;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (is != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        throw throwable;
                                    }
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                            if (picture_type >= 0) {
                                if (pictureSheet == null) {
                                    pictureSheet = this.fHSSFWorkbook.createSheet("pictures");
                                }
                                HSSFCell pcell = this.createHSSFCell(pictureSheet, (short)0, iPictureRow++);
                                System.out.println("pcell=" + iPictureRow);
                                pcell.setCellValue((RichTextString)new HSSFRichTextString(picture.getAbsolutePath()));
                                int height = 0;
                                partriarch = this.addPicture(partriarch, pictureSheet, iPictureRow++, 1, bytes, picture_type, height);
                                HSSFHyperlink link = new HSSFHyperlink(2);
                                String hayperLinkString = String.format("'pictures'!A%d", ++iPictureRow - 3);
                                link.setAddress(hayperLinkString);
                                cell.setHyperlink((Hyperlink)link);
                            }
                        }
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (sr.getPair() != null && this.supportDiff) {
                        DiffElementType type = ((DifferenceStringData)sr.getPair()).fDifferenceKind;
                        switch (type) {
                            case ADDITION: {
                                border = (short)PreferenceUtil.getInt("EXCEL_ADD_BORDER");
                                cell_color = (short)PreferenceUtil.getInt("EXCEL_ADD_COLOR");
                                fill_pattern = (short)PreferenceUtil.getInt("EXCEL_ADD_PATTERN");
                                break;
                            }
                            case CHANGE: {
                                border = (short)PreferenceUtil.getInt("EXCEL_UPD_BORDER");
                                cell_color = (short)PreferenceUtil.getInt("EXCEL_UPD_COLOR");
                                fill_pattern = (short)PreferenceUtil.getInt("EXCEL_UPD_PATTERN");
                                break;
                            }
                            case DELETION: {
                                border = (short)PreferenceUtil.getInt("EXCEL_DEL_BORDER");
                                cell_color = (short)PreferenceUtil.getInt("EXCEL_DEL_COLOR");
                                fill_pattern = (short)PreferenceUtil.getInt("EXCEL_DEL_PATTERN");
                                break;
                            }
                            default: {
                                if (j % 2 != 0 && sima) {
                                    cell_color = (short)PreferenceUtil.getInt("EXCEL_SIMA_COLOR");
                                    fill_pattern = 1;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        this.fLogger.trace((Object)" 316LINE");
                        if (j % 2 != 0 && sima) {
                            cell_color = (short)PreferenceUtil.getInt("EXCEL_SIMA_COLOR");
                            fill_pattern = 1;
                        }
                    }
                    short font_color = -1;
                    boolean font_italic = false;
                    cell.setCellStyle(this.getHSSFCellStyle(true, border, this.fd.getName(), (short)this.fd.getHeight(), font_italic, font_color, cell_color, fill_pattern));
                    ++j;
                }
                if ((i2 + 1) % COLUMN_BREAK == 0) {
                    irow += rdh[rdh_num].getRowCount() + 1;
                }
                monitor.worked(1);
                ++i2;
            }
            irow = keys.length % COLUMN_BREAK > 0 ? (irow += 3 + rdh[rdh_num].getRowCount()) : (irow += 2);
            ++rdh_num;
        }
        monitor.subTask("Now Saving [" + this.fSaveFile.getAbsolutePath() + "]");
        this.save(this.fSaveFile);
        return Status.OK_STATUS;
    }
}

