/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComboEditor
extends FieldEditor {
    private CCombo combo;
    String[] elements;
    private SelectionListener selectionListener;

    protected ComboEditor() {
    }

    protected ComboEditor(String name, String labelText, String[] elements, Composite parent) {
        this.elements = elements;
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.combo.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected String createList(String[] items) {
        if (items == null || items.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            buf.append(items[i]).append(", ");
            ++i;
        }
        buf.setLength(buf.length() - 2);
        return buf.toString();
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboEditor.this.selectionChanged();
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.combo = this.getComboControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.combo != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            int i = 0;
            while (i < this.combo.getItemCount()) {
                if (this.combo.getItem(i).equals(s)) {
                    this.combo.select(i);
                    return;
                }
                ++i;
            }
            this.doLoadDefault();
        }
    }

    protected void doLoadDefault() {
        if (this.combo != null) {
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            int i = 0;
            while (i < this.combo.getItemCount()) {
                if (this.combo.getItem(i).equals(s)) {
                    this.combo.select(i);
                    return;
                }
                ++i;
            }
            this.combo.setText(s);
        }
    }

    protected void doStore() {
        String s = this.combo.getText();
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public CCombo getComboControl(Composite parent) {
        if (this.combo == null) {
            this.combo = new CCombo(parent, 0x800808);
            this.combo.setFont(parent.getFont());
            this.combo.addSelectionListener(this.getSelectionListener());
            this.combo.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ComboEditor.this.combo = null;
                }
            });
            int i = 0;
            while (i < this.elements.length) {
                this.combo.add(this.elements[i]);
                ++i;
            }
        } else {
            this.checkParent((Control)this.combo, parent);
        }
        return this.combo;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    private void selectionChanged() {
    }

    public void setFocus() {
        if (this.combo != null) {
            this.combo.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getComboControl(parent).setEnabled(enabled);
    }
}

