/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class DefaultTitleAreaDialog
extends TitleAreaDialog
implements VerifyListener {
    ScrolledForm root;
    FormToolkit toolkit;
    private Display display;
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public DefaultTitleAreaDialog(Shell shell) {
        super(shell);
    }

    protected Point getInitialSize() {
        int width = 600;
        if (this.getParentShell().getBounds().width >= 700) {
            width = 700;
        } else if (this.getParentShell().getBounds().width >= 800) {
            width = 800;
        } else if (this.getParentShell().getBounds().width >= 900) {
            width = 900;
        }
        return new Point(width, this.getInitialHeight());
    }

    protected int getInitialHeight() {
        return 400;
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
    }

    protected GridData createGridHSpanData(int hSpan) {
        GridData gd = new GridData(770);
        gd.horizontalSpan = hSpan;
        return gd;
    }

    abstract String getDialogTitle();

    abstract void createDialogAreaSub(Composite var1);

    Text createInputText(Composite parent, String label, String initialText) {
        this.toolkit.createLabel(parent, label);
        Text ret = this.toolkit.createText(parent, initialText);
        ret.setLayoutData((Object)new GridData(768));
        ret.addVerifyListener((VerifyListener)this);
        return ret;
    }

    CCombo createInputCombo(Composite parent, String label, String[] items, String default_value) {
        this.toolkit.createLabel(parent, label);
        CCombo ret = new CCombo(parent, 2048);
        if (items != null && items.length > 0) {
            ret.setItems(items);
            if (default_value != null) {
                int i = 0;
                while (i < items.length) {
                    String item = items[i];
                    if (item.equals(default_value)) {
                        ret.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        ret.setLayoutData((Object)new GridData(768));
        return ret;
    }

    Spinner createInputNumericSpiner(Composite parent, String label, Integer min, Integer max, Integer default_value) {
        this.toolkit.createLabel(parent, label);
        Spinner ret = new Spinner(parent, 2048);
        if (min != null) {
            ret.setMinimum(min.intValue());
        }
        if (max != null) {
            ret.setMaximum(max.intValue());
        }
        if (default_value != null) {
            ret.setSelection(default_value.intValue());
        }
        ret.setLayoutData((Object)new GridData(768));
        return ret;
    }

    Button createInputCheckButton(Composite parent, String label, Boolean default_value) {
        this.toolkit.createLabel(parent, label);
        Button ret = this.toolkit.createButton(parent, "", 32);
        ret.setLayoutData((Object)new GridData(768));
        if (default_value != null && default_value.booleanValue()) {
            ret.setSelection(true);
        }
        return ret;
    }

    public void verifyText(VerifyEvent e) {
        this.validate();
    }

    protected void validate() {
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.getDialogTitle());
        try {
            this.display = parent.getDisplay();
            this.toolkit = new FormToolkit(parent.getDisplay());
            this.root = this.toolkit.createScrolledForm(parent);
            this.root.setLayoutData((Object)new GridData(1808));
            this.root.getBody().setLayout((Layout)new GridLayout(2, false));
            this.root.getBody().setLayoutData((Object)new GridData(1808));
            try {
                this.createDialogAreaSub(this.root.getBody());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.root;
        }
        catch (Exception e) {
            this.fLogger.debug((Object)"", (Throwable)e);
            return this.root;
        }
    }
}

