/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class FilePathEditor
extends ListEditor {
    String[] EXTENSIONS = new String[]{"*.jar", "*.zip"};
    static String JAR_OR_ZIP = "*.jar;*.zip";
    private Composite fParent;
    private String lastPath;
    private String dirChooserLabelText;

    protected FilePathEditor() {
    }

    public FilePathEditor(String name, String labelText, String dirChooserLabelText, Composite parent) {
        this.fParent = parent;
        this.init(name, labelText);
        this.dirChooserLabelText = dirChooserLabelText;
        this.createControl(parent);
    }

    protected String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            path.append(File.pathSeparator);
            ++i;
        }
        return path.toString();
    }

    protected String getNewInputObject() {
        String dir;
        FileDialog dialog = new FileDialog(this.getShell());
        if (this.dirChooserLabelText != null) {
            dialog.setFilterExtensions(this.EXTENSIONS);
        }
        dialog.setText(this.dirChooserLabelText);
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        if ((dir = dialog.open()) != null) {
            if ((dir = dir.trim()).length() == 0) {
                return null;
            }
            this.lastPath = dir;
        }
        return dir;
    }

    protected String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<Object> v = new ArrayList<Object>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement());
        }
        return v.toArray(new String[v.size()]);
    }

    protected String[] listFiles() {
        String s = this.createList(this.getListControl(this.fParent).getItems());
        if (s != null) {
            return this.parseString(s);
        }
        return new String[0];
    }
}

