/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.preferences.Messages;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.wolfdbmanager.ApplicationWorkbenchWindowAdvisor;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String EMPTY = "";
    static final String CORON = ":";
    Button fDoSwing;
    Button fDoFitColumn;
    Button fDoFitDatum;
    Combo dateList = null;
    Combo timeList = null;
    Table statusLineImageList;
    static String[] LIST = new String[]{"%tF", "%tF %<tT", "%tF %<tT.%<tL"};

    protected Control createContents(Composite parent) {
        try {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            ScrolledForm root = toolkit.createScrolledForm(parent);
            root.setText(Messages.ViewPreferencePage_ROOT_TITLE);
            root.getBody().setLayout((Layout)new GridLayout());
            Section section = toolkit.createSection(root.getBody(), 448);
            section.setText(Messages.ViewPreferencePage_RSV);
            section.setDescription(Messages.ViewPreferencePage_RSV_DESC);
            Composite inner = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            inner.setLayout((Layout)layout);
            layout.numColumns = 3;
            toolkit.createLabel(inner, Messages.ViewPreferencePage_PURE_COMPOSITE);
            toolkit.createLabel(inner, CORON);
            toolkit.createLabel(inner, Messages.ViewPreferencePage_des1);
            toolkit.createLabel(inner, Messages.ViewPreferencePage_Swing);
            toolkit.createLabel(inner, CORON);
            toolkit.createLabel(inner, Messages.ViewPreferencePage_SwingDesc);
            toolkit.createLabel(inner, Messages.ViewPreferencePage_SwingJ);
            toolkit.createLabel(inner, CORON);
            this.fDoSwing = toolkit.createButton(inner, Messages.ViewPreferencePage_doCheck, 32);
            this.fDoSwing.setLayoutData((Object)new GridData(768));
            this.fDoSwing.setSelection(PreferenceUtil.getBoolean("BOOLEAN_VIEWER_SWING"));
            toolkit.createLabel(inner, EMPTY);
            toolkit.createLabel(inner, EMPTY);
            toolkit.createLabel(inner, EMPTY);
            toolkit.createLabel(inner, Messages.ViewPreferencePage_AdjustColumn);
            toolkit.createLabel(inner, CORON);
            Composite c = toolkit.createComposite(inner);
            c.setLayout((Layout)new FillLayout());
            this.fDoFitColumn = toolkit.createButton(c, Messages.ViewPreferencePage_AdjustColumnBtn, 16);
            this.fDoFitDatum = toolkit.createButton(c, Messages.ViewPreferencePage_AdjustDatum, 16);
            c.setLayoutData((Object)new GridData(768));
            if (PreferenceUtil.getBoolean("BOOLEAN_DEFAULT_COLUMN_ADJUST_COLUMN")) {
                this.fDoFitColumn.setSelection(true);
            } else {
                this.fDoFitDatum.setSelection(true);
            }
            section.setClient((Control)inner);
            section.setLayoutData((Object)new GridData(768));
            Section section2 = toolkit.createSection(root.getBody(), 448);
            section2.setDescription("%tF=YYYY-MM-DD  %tT=HH24:MI:SS  %tL=ffffff");
            section2.setText(Messages.ViewPreferencePage_DATE_FORMAT);
            Composite inner2 = toolkit.createComposite((Composite)section2);
            GridLayout layout2 = new GridLayout();
            inner2.setLayout((Layout)layout2);
            layout2.numColumns = 3;
            toolkit.createLabel(inner2, Messages.ViewPreferencePage_DF_LBL);
            toolkit.createLabel(inner2, CORON);
            this.dateList = new Combo(inner2, 8);
            this.dateList.setItems(LIST);
            int i = 0;
            while (i < LIST.length) {
                if (LIST[i].equals(PreferenceUtil.getString("FORMAT_DATE"))) {
                    this.dateList.select(i);
                    break;
                }
                ++i;
            }
            toolkit.createLabel(inner2, Messages.ViewPreferencePage_TIMESTAMP);
            toolkit.createLabel(inner2, CORON);
            this.timeList = new Combo(inner2, 8);
            this.timeList.setItems(LIST);
            i = 0;
            while (i < LIST.length) {
                if (LIST[i].equals(PreferenceUtil.getString("FORMAT_TIMESTAMP"))) {
                    this.timeList.select(i);
                    break;
                }
                ++i;
            }
            section2.setClient((Control)inner2);
            section2.setLayoutData((Object)new GridData(768));
            File ff = new File("thema/images");
            String[] images = new String[]{};
            if (ff.exists()) {
                Section section3 = toolkit.createSection(root.getBody(), 448);
                section3.setText(Messages.ViewPreferencePage_THEMA);
                Composite inner3 = toolkit.createComposite((Composite)section3);
                GridLayout layout3 = new GridLayout();
                inner3.setLayout((Layout)layout3);
                layout3.numColumns = 3;
                toolkit.createLabel(inner3, Messages.ViewPreferencePage_STATUSBAR);
                toolkit.createLabel(inner3, CORON);
                this.statusLineImageList = new Table(inner3, 2564);
                this.statusLineImageList.setLinesVisible(true);
                images = ff.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("gif") || name.endsWith("jpg") || name.endsWith("bmp");
                    }
                });
                int i2 = 0;
                while (i2 < images.length) {
                    TableItem item = new TableItem(this.statusLineImageList, 0);
                    item.setText(images[i2]);
                    item.setImage(ImageManager.getStatusImage(images[i2]));
                    ++i2;
                }
                TableItem item = new TableItem(this.statusLineImageList, 0);
                item.setText("-- nothing --");
                int i3 = 0;
                while (i3 < images.length) {
                    if (PreferenceUtil.getString("STATUS_IMAGE").equals(images[i3])) {
                        this.statusLineImageList.select(i3);
                        break;
                    }
                    ++i3;
                }
                GridData gd = new GridData(768);
                gd.minimumHeight = 150;
                gd.heightHint = 150;
                this.statusLineImageList.setLayoutData((Object)gd);
                section3.setClient((Control)inner3);
                section3.setLayoutData((Object)new GridData(768));
            }
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void performApply() {
        try {
            PreferenceUtil.setBoolean("BOOLEAN_VIEWER_SWING", this.fDoSwing.getSelection());
            PreferenceUtil.setString("FORMAT_DATE", this.dateList.getText());
            PreferenceUtil.setString("FORMAT_TIMESTAMP", this.timeList.getText());
            PreferenceUtil.setString("STATUS_IMAGE", this.statusLineImageList.getSelection()[0].getText());
            ApplicationWorkbenchWindowAdvisor.setStatusImage(ImageManager.getStatusImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

