/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.selenium;

import com.google.common.base.Function;
import com.thoughtworks.selenium.webdriven.WebDriverBackedSelenium;
import hiro.yoshioka.selenium.Action;
import hiro.yoshioka.selenium.IScenarioRunnerListener;
import hiro.yoshioka.selenium.Messages;
import hiro.yoshioka.selenium.NeverAskMimeType;
import hiro.yoshioka.selenium.TestBrowserType;
import hiro.yoshioka.selenium.WindowSize;
import hiro.yoshioka.selenium.inspect.BrowserAction;
import hiro.yoshioka.selenium.inspect.ExpectionType;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ScenarioRunner {
    IScenarioRunnerListener listerner;
    Counter counter = new Counter();
    private boolean doWork;
    private int pause_time;
    private List<TestCaseResult> result_list = new ArrayList<TestCaseResult>();
    private HSSFWorkbook book;
    private Setting setting;

    public void main(String[] args) {
        File senario_file = new File("C:/tmp/scenario_to_\u8b5b\u7259\u67d1\u8b5b\u6ec4\u525e\u7e5d\u69ed\u305b\u7e67\uff7f\u87c7\uff7e\u8822\ufffd.xls");
        ScenarioRunner runner = new ScenarioRunner();
        runner.init(senario_file);
        runner.run();
    }

    public Setting getSetting() {
        return this.setting;
    }

    public void setListerner(IScenarioRunnerListener listerner) {
        this.listerner = listerner;
    }

    public List<TestCaseResult> getResult_list() {
        return this.result_list;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public void init(File scenario_file) {
        block15: {
            FileInputStream in = null;
            try {
                try {
                    File f;
                    String output_path;
                    in = new FileInputStream(scenario_file);
                    this.book = new HSSFWorkbook((InputStream)in);
                    HSSFSheet sheet = this.book.getSheet("#setting");
                    this.setting = new Setting();
                    this.setting.num_of_test_case = this.countTestCase(this.setting);
                    this.setting.scenario_file = scenario_file;
                    this.setting.base_url = this.getPropertyValueOf(sheet, "base url");
                    if (StringUtil.isEmpty((Object)this.setting.base_url)) {
                        this.setting.base_url = "http://yahoo.co.jp";
                    }
                    if (!StringUtil.isEmpty((Object)(output_path = this.getPropertyValueOf(sheet, "output path")))) {
                        f = new File(output_path);
                        if (f.exists()) {
                            this.setting.evidence_output_folder = f;
                        } else if (f.mkdirs() && f.exists()) {
                            this.setting.evidence_output_folder = f;
                        }
                    }
                    this.setting.auto_take_pictures = "auto".equalsIgnoreCase(this.getPropertyValueOf(sheet, "take pictures"));
                    this.setting.take_on_changed_screen = this.isPropertyValueOf(sheet, "take_on_changed_screen");
                    this.setting.take_on_clicked = this.isPropertyValueOf(sheet, "take_on_clicked");
                    this.setting.take_on_sended_keys = this.isPropertyValueOf(sheet, "take_on_sended_keys");
                    this.setting.exit_on_failure = this.isPropertyValueOf(sheet, "exit on failure");
                    if (this.isPropertyValueOf(sheet, "Tested Firefox")) {
                        this.setting.test_browser_set.add(TestBrowserType.Firefox);
                    }
                    if (this.isPropertyValueOf(sheet, "Tested Chrome")) {
                        this.setting.test_browser_set.add(TestBrowserType.Chrome);
                        f = this.getPropertyFileValueOf(sheet, "webdriver.chrome.driver", true);
                        if (f != null) {
                            this.setting.webdriver_chrome_driver = f;
                        }
                    }
                    if (this.isPropertyValueOf(sheet, "Tested I.E.")) {
                        this.setting.test_browser_set.add(TestBrowserType.Ie);
                        f = this.getPropertyFileValueOf(sheet, "webdriver.ie.driver", true);
                        if (f != null) {
                            this.setting.webdriver_ie_driver = f;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtils.closeQuietly((InputStream)in);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private File getPropertyFileValueOf(HSSFSheet sheet, String property_key, boolean must_be_exists) {
        File f;
        String s = this.getPropertyValueOf(sheet, property_key);
        if (!StringUtil.isEmpty((Object)s) && (f = new File(s)).exists()) {
            return f;
        }
        return null;
    }

    private String getPropertyValueOf(HSSFSheet sheet, String property_key) {
        HSSFRow row = this.getPropertyOf(sheet, property_key);
        if (row != null) {
            return this.getStringCellValue(row, 6);
        }
        return null;
    }

    private boolean isPropertyValueOf(HSSFSheet sheet, String property_key) {
        HSSFRow row = this.getPropertyOf(sheet, property_key);
        if (row != null) {
            return this.getBooleanCellValue(row, 6);
        }
        return false;
    }

    private HSSFRow getPropertyOf(HSSFSheet sheet, String property_key) {
        int i = sheet.getFirstRowNum();
        while (i <= sheet.getLastRowNum()) {
            String s;
            HSSFRow row = sheet.getRow(i);
            if (row != null && property_key.equalsIgnoreCase(s = this.getStringCellValue(row, 5))) {
                return row;
            }
            ++i;
        }
        return null;
    }

    public void run() {
        this.doWork = true;
        this.result_list = new ArrayList<TestCaseResult>();
        this.counter = new Counter();
        System.currentTimeMillis();
        Date d = new Date();
        for (TestBrowserType browser_type : this.setting.test_browser_set) {
            if (!this.doWork) break;
            try {
                File now_evidence_folder = null;
                if (this.setting.evidence_output_folder != null && this.setting.evidence_output_folder.exists()) {
                    String fn;
                    File scenario_folder;
                    String n = this.setting.scenario_file.getName();
                    if (n.endsWith(".xls")) {
                        n = n.substring(0, n.length() - 4);
                    }
                    if (n.endsWith(".xlsx")) {
                        n = n.substring(0, n.length() - 5);
                    }
                    if (!(scenario_folder = new File(this.setting.evidence_output_folder, n)).exists()) {
                        scenario_folder.mkdirs();
                    }
                    if (!(now_evidence_folder = new File(scenario_folder, fn = String.format("%tY%tm%td_%tH%tM_%s", new Object[]{d, d, d, d, d, browser_type}))).exists()) {
                        now_evidence_folder.mkdirs();
                    }
                    if (!now_evidence_folder.exists()) {
                        System.err.println("Nothing now_evidence_folder=" + now_evidence_folder.getAbsolutePath());
                        now_evidence_folder = null;
                    }
                }
                WebDriverBackedSelenium selenium = null;
                InternetExplorerDriver driver = null;
                switch (browser_type) {
                    case Firefox: {
                        FirefoxProfile profile = new FirefoxProfile();
                        profile.setPreference("browser.download.folderList", 2);
                        profile.setPreference("browser.download.useDownloadDir", true);
                        profile.setPreference("browser.download.dir", now_evidence_folder.getAbsolutePath());
                        profile.setPreference("browser.helperApps.neverAsk.saveToDisk", StringUtil.join(NeverAskMimeType.getMimeList(), (String)","));
                        profile.setPreference("browser.download.manager.showWhenStarting", false);
                        profile.setAcceptUntrustedCertificates(true);
                        driver = new FirefoxDriver(profile);
                        break;
                    }
                    case Chrome: {
                        if (this.setting.webdriver_chrome_driver != null) {
                            System.setProperty("webdriver.chrome.driver", this.setting.webdriver_chrome_driver.getAbsolutePath());
                        }
                        ChromeOptions options = new ChromeOptions();
                        options.addArguments(new String[]{"--ignore-certificate-errors"});
                        driver = new ChromeDriver(options);
                        break;
                    }
                    case Ie: {
                        DesiredCapabilities caps = DesiredCapabilities.internetExplorer();
                        caps.setCapability("ignoreZoomSetting", true);
                        caps.setCapability("ignoreProtectedModeSettings", true);
                        if (this.setting.webdriver_chrome_driver != null) {
                            System.setProperty("webdriver.ie.driver", this.setting.webdriver_ie_driver.getAbsolutePath());
                        }
                        driver = new InternetExplorerDriver((Capabilities)caps);
                    }
                }
                selenium = new WebDriverBackedSelenium(driver, this.setting.base_url);
                driver.manage().timeouts().implicitlyWait(4L, TimeUnit.SECONDS);
                this.runBySetting(selenium, (WebDriver)driver, this.setting, now_evidence_folder);
            }
            catch (Exception e) {
                Application.openErrorDialog(null, "Error", e);
            }
        }
        if (this.listerner != null) {
            this.listerner.done(this.setting.evidence_output_folder);
        }
    }

    public int countTestCase(Setting setting) {
        int sum = 0;
        int i = 0;
        while (i < this.book.getNumberOfSheets()) {
            HSSFSheet sheet;
            if (!this.book.getSheetName(i).startsWith("#") && !this.isSkipAll(sheet = this.book.getSheetAt(i))) {
                int iRow = 3;
                while (iRow <= sheet.getLastRowNum()) {
                    HSSFRow row = null;
                    try {
                        Action action;
                        row = sheet.getRow(iRow);
                        String desc = this.getStringCellValue(row, 2);
                        if (!StringUtil.isEmpty((Object)desc) && (action = Action.parse(this.getStringCellValue(row, 3))) != null) {
                            ++sum;
                        }
                    }
                    catch (Exception exception) {}
                    ++iRow;
                }
            }
            ++i;
        }
        return sum;
    }

    public void runBySetting(WebDriverBackedSelenium selenium, WebDriver driver, Setting setting, File scenario_evidence_folder) {
        int i = 0;
        while (i < this.book.getNumberOfSheets()) {
            if (!this.doWork) break;
            if (!this.book.getSheetName(i).startsWith("#")) {
                File evidence_top_folder = null;
                if (scenario_evidence_folder != null) {
                    String folder_name = String.format("%02d.%s", i, FileUtil.renameForWindows((String)this.book.getSheetName(i), (String)"_"));
                    evidence_top_folder = new File(scenario_evidence_folder, folder_name);
                    evidence_top_folder.mkdirs();
                    if (!evidence_top_folder.exists()) {
                        evidence_top_folder = null;
                    }
                }
                this.exec_scenario(this.book.getSheetAt(i), driver, selenium, setting, evidence_top_folder);
            }
            ++i;
        }
        if (this.doWork) {
            this.sleep(3000);
        }
        try {
            selenium.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            driver.quit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getStringCellValue(HSSFRow row, int col_index) {
        HSSFCell cell;
        if (row != null && (cell = row.getCell(col_index)) != null) {
            return cell.getStringCellValue();
        }
        return null;
    }

    private boolean getBooleanCellValue(HSSFRow row, int col_index) {
        HSSFCell cell;
        if (row != null && (cell = row.getCell(col_index)) != null) {
            return cell.getBooleanCellValue();
        }
        return false;
    }

    private int getIntCellValue(HSSFRow row, int col_index) {
        try {
            HSSFCell cell;
            if (row != null && (cell = row.getCell(col_index)) != null) {
                return new BigDecimal(cell.getNumericCellValue()).intValue();
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public void stop() {
        this.doWork = false;
    }

    private void createSkipExprResultFile(File evidence_top_folder, String desc_for_browser_inspection_result_file, boolean result, String skip_result_detail) {
        desc_for_browser_inspection_result_file = result ? String.valueOf(desc_for_browser_inspection_result_file) + "__SKIP_TRUE.txt" : String.valueOf(desc_for_browser_inspection_result_file) + "__SKIP_FALSE.txt";
        if (evidence_top_folder != null) {
            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
            FileUtil.writeFile((File)f, (String)skip_result_detail, (String)"UTF8");
        }
    }

    private void createSkippingInfoFile(File evidence_top_folder, String desc_for_browser_inspection_result_file, String skip_reason) {
        desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "__SKIP.txt";
        if (evidence_top_folder != null) {
            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
            FileUtil.writeFile((File)f, (String)skip_reason, (String)"UTF8");
        }
    }

    private void exec_scenario(HSSFSheet sheet, WebDriver driver, WebDriverBackedSelenium selenium, Setting setting, File evidence_top_folder) {
        if (this.isSkipAll(sheet)) {
            return;
        }
        if (setting.has_failure) {
            return;
        }
        int skip_this_no = -1;
        String skip_reason = null;
        String dialog_message = null;
        int iRow = 3;
        while (iRow <= sheet.getLastRowNum()) {
            block74: {
                int current_no = iRow - 2;
                if (setting.has_failure) break;
                HSSFRow row = null;
                String desc_for_browser_inspection_result_file = null;
                TestCaseResult case_result = new TestCaseResult();
                try {
                    Action action;
                    if (!this.doWork) break;
                    row = sheet.getRow(iRow);
                    String desc = this.getStringCellValue(row, 2);
                    if (StringUtil.isEmpty((Object)desc)) break block74;
                    String desc_for_file = String.format("%03d_%s.png", iRow - 2, FileUtil.renameForWindows((String)desc, (String)"_"));
                    desc_for_browser_inspection_result_file = String.format("%03d_%s", iRow - 2, FileUtil.renameForWindows((String)desc, (String)"_"));
                    if (skip_this_no > 0) {
                        if (skip_this_no != current_no) {
                            this.createSkippingInfoFile(evidence_top_folder, desc_for_browser_inspection_result_file, skip_reason);
                            break block74;
                        }
                        skip_this_no = -1;
                        skip_reason = null;
                    }
                    if ((action = Action.parse(this.getStringCellValue(row, 3))) == null) break block74;
                    if (this.pause_time > 0) {
                        try {
                            Thread.sleep(this.pause_time * 1000);
                        }
                        catch (Exception exception) {}
                        this.pause_time = 0;
                    }
                    ++this.counter.rans;
                    String parameter = this.getStringCellValue(row, 4);
                    this.getStringCellValue(row, 5);
                    this.getStringCellValue(row, 6);
                    case_result.sheet_name = sheet.getSheetName();
                    case_result.description = desc;
                    case_result.command = action.getTitle();
                    case_result.parameter = parameter;
                    this.result_list.add(0, case_result);
                    int sleep = this.getIntCellValue(row, 9);
                    System.out.println("desc=" + desc);
                    this.changed(case_result, "running");
                    WebElement web_element = null;
                    switch (action) {
                        case deleteAllCookies: {
                            if (StringUtil.isEmpty((Object)parameter)) {
                                case_result.result = "error";
                                case_result.inspection_result_of_browser = "Set Cookies clear site url at parameter cell";
                                ++this.counter.failures;
                                break;
                            }
                            driver.navigate().to(parameter);
                            driver.manage().deleteAllCookies();
                            case_result.result = "ok";
                            break;
                        }
                        case openUrl: {
                            driver.get(parameter);
                            this.changed(case_result, "waitForPageToLoad");
                            selenium.waitForPageToLoad("30000");
                            case_result.result = "ok";
                            if (!setting.auto_take_pictures || evidence_top_folder == null) break;
                            this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                            break;
                        }
                        case back: {
                            driver.navigate().back();
                            if (StringUtil.isEmpty((Object)parameter)) {
                                parameter = new File(evidence_top_folder, desc_for_file).getAbsolutePath();
                            }
                            this.takeScreenShot(action, driver, parameter, false);
                            break;
                        }
                        case forward: {
                            driver.navigate().forward();
                            if (StringUtil.isEmpty((Object)parameter)) {
                                parameter = new File(evidence_top_folder, desc_for_file).getAbsolutePath();
                            }
                            this.takeScreenShot(action, driver, parameter, false);
                            break;
                        }
                        case refresh: {
                            driver.navigate().refresh();
                            if (StringUtil.isEmpty((Object)parameter)) {
                                parameter = new File(evidence_top_folder, desc_for_file).getAbsolutePath();
                            }
                            this.takeScreenShot(action, driver, parameter, false);
                            break;
                        }
                        case execute_script: {
                            if (!(driver instanceof JavascriptExecutor)) break;
                            ((JavascriptExecutor)driver).executeScript(parameter, new Object[0]);
                            break;
                        }
                        case execute_async_script: {
                            if (!(driver instanceof JavascriptExecutor)) break;
                            ((JavascriptExecutor)driver).executeAsyncScript(parameter, new Object[0]);
                            break;
                        }
                        case setFile: {
                            web_element = this.getWebElement(driver, row);
                            web_element.sendKeys(new CharSequence[]{parameter});
                            case_result.result = "ok";
                            if (!setting.auto_take_pictures || evidence_top_folder == null) break;
                            this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                            break;
                        }
                        case sendKeys: {
                            if (this.isMultipleSelector(row)) {
                                for (WebElement elm : this.getWebElements(driver, row)) {
                                    elm.clear();
                                    elm.sendKeys(new CharSequence[]{parameter});
                                    case_result.result = "ok";
                                    if (setting.auto_take_pictures && evidence_top_folder != null) {
                                        this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                                    }
                                    this.sleep(100);
                                }
                                break;
                            }
                            System.out.println("param=" + parameter);
                            web_element = this.getWebElement(driver, row);
                            web_element.clear();
                            web_element.sendKeys(new CharSequence[]{parameter});
                            case_result.result = "ok";
                            if (!setting.auto_take_pictures || evidence_top_folder == null) break;
                            this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                            break;
                        }
                        case click: {
                            if (this.isMultipleSelector(row)) {
                                for (WebElement elm : this.getWebElements(driver, row)) {
                                    this.click(driver, elm);
                                    case_result.result = "ok";
                                    if (setting.auto_take_pictures && evidence_top_folder != null) {
                                        this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                                    }
                                    this.sleep(100);
                                }
                                break;
                            }
                            web_element = this.getWebElement(driver, row);
                            this.click(driver, web_element);
                            case_result.result = "ok";
                            if (!setting.auto_take_pictures || evidence_top_folder == null) break;
                            this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                            break;
                        }
                        case selectByIndex: {
                            web_element = this.getWebElement(driver, row);
                            new Select(web_element).selectByIndex(StringUtil.parseIntNoneException((String)parameter, (int)0));
                            case_result.result = "ok";
                            break;
                        }
                        case selectByVisibleText: {
                            web_element = this.getWebElement(driver, row);
                            new Select(web_element).selectByVisibleText(parameter);
                            case_result.result = "ok";
                            break;
                        }
                        case selectByValue: {
                            web_element = this.getWebElement(driver, row);
                            new Select(web_element).selectByValue(parameter);
                            case_result.result = "ok";
                            break;
                        }
                        case takesScreenshot: {
                            if (StringUtil.isEmpty((Object)parameter)) {
                                parameter = new File(evidence_top_folder, desc_for_file).getAbsolutePath();
                            }
                            if (evidence_top_folder == null) {
                                case_result.result = "error";
                                case_result.inspection_result_of_browser = "Check your [#setting] sheet. 2.1.1 output path";
                                break;
                            }
                            this.takeScreenShot(action, driver, parameter, false);
                            case_result.result = "ok";
                            break;
                        }
                        case takesAllScreenshot: {
                            if (StringUtil.isEmpty((Object)parameter)) {
                                parameter = new File(evidence_top_folder, desc_for_file).getAbsolutePath();
                            }
                            if (evidence_top_folder == null) {
                                case_result.result = "error";
                                case_result.inspection_result_of_browser = "Check your [#setting] sheet. 2.1.1 output path";
                                break;
                            }
                            this.takeScreenShot(action, driver, parameter, true);
                            case_result.result = "ok";
                            break;
                        }
                        case waitForInvisible: {
                            if (setting.auto_take_pictures && evidence_top_folder != null) {
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                            }
                            int wait_second = 60;
                            if (!StringUtil.isEmpty((Object)parameter)) {
                                wait_second = StringUtil.parseIntNoneException((String)parameter, (int)60);
                            }
                            if (wait_second < 1) {
                                wait_second = 1;
                            }
                            new WebDriverWait(driver, (long)wait_second).until((Function)ExpectedConditions.invisibilityOfElementLocated((By)this.getBy(row)));
                            case_result.result = "ok";
                            sleep = 0;
                            break;
                        }
                        case switchTo: {
                            driver.switchTo().frame(this.getWebElement(driver, row));
                            case_result.result = "ok";
                            break;
                        }
                        case switchToDefaultContent: {
                            driver.switchTo().defaultContent();
                            case_result.result = "ok";
                            break;
                        }
                        case switchToConfirmAndAccept: {
                            if (setting.auto_take_pictures && evidence_top_folder != null) {
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), true);
                            }
                            Alert alert00 = driver.switchTo().alert();
                            dialog_message = alert00.getText();
                            alert00.accept();
                            break;
                        }
                        case switchToConfirmAndDismiss: {
                            if (setting.auto_take_pictures && evidence_top_folder != null) {
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), true);
                            }
                            Alert alert01 = driver.switchTo().alert();
                            dialog_message = alert01.getText();
                            alert01.dismiss();
                            break;
                        }
                        case switchToErrorAndAccept: {
                            if (setting.auto_take_pictures && evidence_top_folder != null) {
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), true);
                            }
                            Alert alert02 = driver.switchTo().alert();
                            dialog_message = alert02.getText();
                            alert02.accept();
                            break;
                        }
                        case setWindowSize: {
                            WindowSize windowSizeType = new WindowSize(parameter);
                            if (windowSizeType.getDisplay_resolution() == null) {
                                driver.manage().window().setSize(windowSizeType.getDimension());
                            } else if (windowSizeType.isMaximize()) {
                                driver.manage().window().maximize();
                            } else {
                                driver.manage().window().setSize(windowSizeType.getDimension());
                            }
                            if (setting.auto_take_pictures && evidence_top_folder != null) {
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file).getAbsolutePath(), false);
                            }
                            case_result.result = "ok";
                            break;
                        }
                        case inspectBrowser: {
                            this.inspectBrowser(driver, row, case_result, desc_for_browser_inspection_result_file, evidence_top_folder, dialog_message);
                            break;
                        }
                        case gotoNoWhenExistsSelector: {
                            Object elm;
                            try {
                                elm = this.getWebElement(driver, row);
                                skip_reason = "Exists " + elm + " ==>> GOTO:" + parameter;
                                skip_this_no = StringUtil.parseIntNoneException((String)parameter, (int)-1);
                                this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format("[%s] exists selector[%s] Then [%s]...[%b]", new Object[]{action, elm, parameter, true}));
                            }
                            catch (RuntimeException runtimeException) {
                                this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format("[%s] exists selector Then [%s]...[%b]", new Object[]{action, parameter, false}));
                            }
                            break;
                        }
                        case gotoNoWhenExistsMultipleSelectors: {
                            Object elm;
                            try {
                                elm = this.getWebElements(driver, row);
                                if (elm != null && elm.size() > 1) {
                                    skip_reason = "Exists " + elm + " ==>> GOTO:" + parameter;
                                    skip_this_no = StringUtil.parseIntNoneException((String)parameter, (int)-1);
                                    this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format("[%s] exists selectors Then [%s]...[%b]", new Object[]{action, parameter, true}));
                                    break;
                                }
                                this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format("[%s] exists multiple selectors Then [%s]...[%b]", new Object[]{action, parameter, false}));
                            }
                            catch (RuntimeException runtimeException) {
                                this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format("[%s] exists multiple selectors Then [%s]...[%b]", new Object[]{action, parameter, false}));
                            }
                            break;
                        }
                        case gotoNoWhenNotExistsSelector: {
                            try {
                                this.getWebElement(driver, row);
                                this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format("[%s] Not exists selector Then [%s]...[%b]", new Object[]{action, parameter, false}));
                            }
                            catch (RuntimeException runtimeException) {
                                skip_reason = "Not Exists selectors ==>> GOTO:" + parameter;
                                skip_this_no = StringUtil.parseIntNoneException((String)parameter, (int)-1);
                                this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format("[%s] Not exists selector Then [%s]...[%b]", new Object[]{action, parameter, true}));
                            }
                            break;
                        }
                        default: {
                            case_result.result = "error";
                            System.err.println("what is action?" + (Object)((Object)action));
                            break block74;
                        }
                    }
                    if (!action.isInspection() && this.hasBrowserInspection(row)) {
                        this.changed(case_result, "Inspect browser");
                        this.inspectBrowser(driver, row, case_result, desc_for_browser_inspection_result_file, evidence_top_folder, dialog_message);
                    }
                    if (sleep > 0) {
                        this.changed(case_result, "sleep[" + sleep + "ms]");
                        this.sleep(sleep);
                    }
                    this.changed(case_result, "done");
                }
                catch (Exception e) {
                    case_result.result = "failure";
                    this.changed(case_result, "failures.");
                    ++this.counter.failures;
                    e.printStackTrace();
                    if (evidence_top_folder != null) {
                        if (desc_for_browser_inspection_result_file == null) {
                            desc_for_browser_inspection_result_file = String.format("%03d_Exception", iRow - 2);
                        }
                        desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_NG.txt";
                        File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
                        FileUtil.writeFile((File)f, (String)StringUtil.getStackTraceString((Throwable)e), (String)"UTF8");
                    }
                    if (!setting.exit_on_failure) break block74;
                    setting.has_failure = true;
                    return;
                }
            }
            ++iRow;
        }
    }

    private void inspectBrowser(WebDriver driver, HSSFRow row, TestCaseResult case_result, String desc_for_browser_inspection_result_file, File evidence_top_folder, String dialog_message) {
        BrowserAction browser_action = BrowserAction.parse(this.getStringCellValue(row, 62));
        ExpectionType expection_type = ExpectionType.parse(this.getStringCellValue(row, 64));
        String expected_val = this.getStringCellValue(row, 65);
        StringBuilder message = new StringBuilder();
        message.append(String.format("Browser Action [%s]", browser_action.getTitle()));
        String error_message = this.inspectBrowser(driver, row, browser_action, expection_type, expected_val, message, dialog_message);
        if (error_message != null) {
            case_result.result = "error";
            ++this.counter.errors;
            message.append(error_message);
            desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_NG.txt";
            System.err.println("Error! " + error_message);
            case_result.inspection_result_of_browser = error_message;
        } else {
            case_result.inspection_result_of_browser = expected_val;
            case_result.result = "ok";
            desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_OK.txt";
        }
        if (evidence_top_folder != null) {
            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
            FileUtil.writeFile((File)f, (String)message.toString(), (String)"UTF8");
        }
    }

    private boolean hasBrowserInspection(HSSFRow row) {
        BrowserAction browser_action = BrowserAction.parse(this.getStringCellValue(row, 62));
        return browser_action != null;
    }

    private void changed(TestCaseResult case_result, String new_status) {
        if (this.listerner != null) {
            if (case_result != null && new_status != null) {
                case_result.status = new_status;
            }
            this.listerner.statusChanged();
        }
    }

    public String inspectBrowser(WebDriver driver, HSSFRow row, BrowserAction action, ExpectionType expect, String parameter, StringBuilder message, String dialog_message) {
        WebElement element = null;
        String error_message = null;
        String s1 = null;
        String s2 = parameter;
        String selector = null;
        switch (action) {
            case window_name: {
                s1 = driver.getTitle();
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
                break;
            }
            case dialog_text: {
                s1 = dialog_message;
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
                break;
            }
            case element_text: {
                element = this.getWebElement(driver, row);
                selector = element.toString();
                s1 = element.getText();
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
                break;
            }
            case element_value: {
                element = this.getWebElement(driver, row);
                selector = element.toString();
                s1 = element.getAttribute("value");
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
            }
        }
        if (!StringUtil.isEmpty(selector)) {
            message.append(String.format("Selector:%s %n", selector));
        }
        message.append(String.format(Messages.ScenarioRunner_expected_value_is, s2));
        return error_message;
    }

    private boolean matcheAt(ExpectionType expect, String s1, String s2) {
        s1 = StringUtil.nvl((Object)s1);
        s2 = StringUtil.nvl((Object)s2);
        switch (expect) {
            case equals: {
                return s1.equals(s2);
            }
            case match: {
                return s1.matches(s2);
            }
            case contain: {
                return s1.indexOf(s2) >= 0;
            }
        }
        return false;
    }

    public void click(WebDriver driver, WebElement element) {
        Actions actions = new Actions(driver);
        actions.moveToElement(element);
        actions.perform();
        if (driver instanceof InternetExplorerDriver) {
            element.sendKeys(new CharSequence[]{Keys.CONTROL});
            this.sleep(100);
            element.sendKeys(new CharSequence[]{Keys.ENTER});
            this.sleep(100);
        } else {
            element.click();
        }
    }

    private boolean isAlertPresent(WebDriver driver) {
        try {
            return driver.switchTo().alert() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void takeScreenShot(Action action, WebDriver driver, String fn, boolean is_all) {
        File save_file = new File(fn);
        boolean force_full_screen = false;
        if (action.isClick()) {
            force_full_screen = this.isAlertPresent(driver);
        }
        if (is_all || force_full_screen) {
            try {
                Robot robot = new Robot();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                BufferedImage image = robot.createScreenCapture(new Rectangle(0, 0, screenSize.width, screenSize.height));
                ImageIO.write((RenderedImage)image, "PNG", save_file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (driver instanceof TakesScreenshot) {
            this.sleep(200);
            TakesScreenshot ts = (TakesScreenshot)driver;
            try {
                FileUtils.copyFile((File)((File)ts.getScreenshotAs(OutputType.FILE)), (File)save_file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isSkipAll(HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(0);
        if (row == null) {
            return false;
        }
        return "all".equalsIgnoreCase(this.getStringCellValue(row, 2)) || "true".equalsIgnoreCase(this.getStringCellValue(row, 2));
    }

    private boolean isMultipleSelector(HSSFRow row) {
        String val = this.getStringCellValue(row, 30);
        return "true".equalsIgnoreCase(val) || "1".equals(val);
    }

    private WebElement getWebElement(WebDriver driver, HSSFRow row) {
        By by = this.getBy(row);
        if (by == null) {
            System.err.println("nothing selector...");
        }
        return driver.findElement(by);
    }

    private List<WebElement> getWebElements(WebDriver driver, HSSFRow row) {
        By by = this.getBy(row);
        if (by == null) {
            System.err.println("nothing selector...");
        }
        return driver.findElements(by);
    }

    private By getBy(HSSFRow row) {
        int i = 31;
        while (i <= 38) {
            String val = this.getStringCellValue(row, i);
            if (!StringUtil.isEmpty((Object)val)) {
                System.out.println("val=" + val);
                switch (i) {
                    case 31: {
                        return By.cssSelector((String)val);
                    }
                    case 32: {
                        return By.className((String)val);
                    }
                    case 33: {
                        return By.id((String)val);
                    }
                    case 34: {
                        return By.name((String)val);
                    }
                    case 35: {
                        return By.tagName((String)val);
                    }
                    case 36: {
                        return By.linkText((String)val);
                    }
                    case 37: {
                        return By.partialLinkText((String)val);
                    }
                    case 38: {
                        return By.xpath((String)val);
                    }
                }
            }
            ++i;
        }
        System.out.println("Error null....");
        return null;
    }

    private void sleep(int microtime) {
        try {
            Thread.sleep(microtime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void pause(int pause_time) {
        this.pause_time = pause_time;
    }

    public static class Counter {
        public int rans;
        public int failures;
        public int errors;
        public int total_cases;
    }

    public class Setting {
        public String base_url;
        public File evidence_output_folder;
        public File scenario_file;
        public boolean auto_take_pictures;
        public boolean take_on_changed_screen;
        public boolean take_on_clicked;
        public boolean take_on_sended_keys;
        public boolean exit_on_failure;
        public Set<TestBrowserType> test_browser_set = new LinkedHashSet<TestBrowserType>();
        public File webdriver_chrome_driver;
        public File webdriver_ie_driver;
        public int num_of_test_case;
        public boolean has_failure;
    }

    public class TestCaseResult {
        public String sheet_name;
        public String description;
        public String command;
        public String parameter;
        public String status;
        public String inspection_result_of_db;
        public String inspection_result_of_browser;
        public String result;
    }
}

