/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor;

import hiro.yoshioka.ast.sql.util.IProposalableParserUtil;
import hiro.yoshioka.ast.sql.util.ProposalParserFactory;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.ui.editor.Messages;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.sql.util.GeneralTableShowRequest;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.ICommandIds;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import org.eclipse.jface.action.Action;

public class ExecuteSelectedSQLAction
extends Action
implements ICommandIds {
    ConnectionProperties cp;
    String sqlStatement;
    SQLEditor editor;

    public ExecuteSelectedSQLAction(SQLEditor editor, ConnectionProperties cp, String sqlStatement) {
        this.setId("Wolf.sel.execute");
        this.setActionDefinitionId("Wolf.sel.execute");
        this.setText(Messages.getString("ExecuteSelectedSQLAction.ExecuteSelectedSql"));
        this.editor = editor;
        this.cp = cp;
        this.sqlStatement = sqlStatement;
    }

    public void run() {
        if (this.cp == null) {
            return;
        }
        ProposalParserFactory factory = ProposalParserFactory.createFactory((String)this.cp.getDriverName());
        IProposalableParserUtil util = factory.createParserUtil(this.sqlStatement, this.cp.getDBRootResource());
        if (!util.parse()) {
            Application.openDialog(Messages.getString("ExecuteSelectedSQLAction.SQL_validation_Error"), Messages.getString("ExecuteSelectedSQLAction.SQL_validation_Error"), 1);
            return;
        }
        TransactionRequest req = util.createTransactionRequest(this.cp);
        req.setMaxRownum(this.editor.getMaxRowNum());
        req.setScription(PreferenceUtil.getExternalJars(), ResourceMarker.getScriptFolder());
        req.setPartName(Application.getActiveSQLEditor().getTitle());
        GeneralTableShowRequest tr = new GeneralTableShowRequest(req, this.editor.isCanUpdatableMode());
        try {
            tr.fIDBTable = util.getFirstTable();
        }
        catch (Exception exception) {}
        req.addListener((IRequestListener)tr);
        req.setTimeOut(PreferenceUtil.getInt("SQL_TIMEOUT_NUM"));
        SQLServerThread.putRequest((Request)req);
    }
}

