/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor;

import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.ui.editor.SQLColorProvider;
import hiro.yoshioka.sql.ui.editor.SQLKeyWordRule;
import hiro.yoshioka.sql.ui.editor.SQLWhitespaceDetector;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class SQLCodeScanner
extends RuleBasedScanner
implements IPartitionTokenScanner {
    public static final String SQL_STRING_FUNCTION = "__sql_stringfunction";
    public static final String SQL_SYSTEM_FUNCTION = "__sql_systemfunction";
    public static final String SQL_TIME_DATE_FUNCTION = "__sql_timedatefunction";
    public static final String SQL_NUMBER_FUNCTION = "__sql_numberfunction";
    public static final String SQL_STRING = "__sql_string";
    public static final String SQL_DEFAULT = "__sql_default";
    public static final String SQL_NUMBER = "__sql_number";
    public static final String SQL_SINGLELINE_COMMENT = "__sql_singleline_comment";
    public static final String SQL_MULTILINE_COMMENT = "__sql_multiline_comment";

    public SQLCodeScanner(SQLColorProvider provider) {
        this.reset(provider, null);
    }

    private void reset(SQLColorProvider provider, Properties prop) {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new SQLWhitespaceDetector()));
        Token token = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_STRING)));
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        Token token2 = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_NUMBER)));
        rules.add(new NumberRule((IToken)token2));
        Token token3 = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_MULTILINE_COMMENT)));
        rules.add(new MultiLineRule("/*", "*/", (IToken)token3));
        Token token4 = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_SINGLELINE_COMMENT)));
        rules.add(new SingleLineRule("--", "", (IToken)token4));
        Token tokenDefault = new Token((Object)new TextAttribute(null));
        Token tokenPunct = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.PUNCT)));
        if (prop != null) {
            try {
                SQLKeyWordRule keyRule = new SQLKeyWordRule((IToken)tokenDefault, (IToken)tokenPunct);
                String target = prop.getProperty("StringFunctions");
                Token t = null;
                if (target != null) {
                    t = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_STRING_FUNCTION), null, 2));
                    keyRule.addKeyWords(target.split(","), t);
                }
                if ((target = prop.getProperty("SystemFunctions")) != null) {
                    t = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_SYSTEM_FUNCTION), null, 2));
                    keyRule.addKeyWords(target.split(","), t);
                }
                if ((target = prop.getProperty("TimeDateFunctions")) != null) {
                    t = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_TIME_DATE_FUNCTION), null, 2));
                    keyRule.addKeyWords(target.split(","), t);
                }
                if ((target = prop.getProperty("NumericFunctions")) != null) {
                    t = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_NUMBER_FUNCTION), null, 2));
                    keyRule.addKeyWords(target.split(","), t);
                }
                if ((target = prop.getProperty("SQLKeywords")) != null) {
                    t = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_KEYWORD), null, 1));
                    keyRule.addKeyWords(target.split(","), t);
                }
                if ((target = prop.getProperty("supportTokens")) != null) {
                    t = new Token((Object)new TextAttribute(provider.getColor(SQLColorProvider.SQL_KEYWORD), null, 1));
                    keyRule.addKeyWords(target.split(","), t);
                }
                rules.add(keyRule);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
    }

    public void setConnectionProperties(SQLColorProvider provider, ConnectionProperties myConnectionPropeteis) {
        Properties p = null;
        if (myConnectionPropeteis != null && myConnectionPropeteis.getDBRootResource() != null) {
            p = myConnectionPropeteis.getDBRootResource().getProperties();
        }
        if (p == null) {
            p = new Properties();
            p.setProperty("supportTokens", "SELECT,FROM,WHERE,ORDER,GROUP,SYSDATE,AS,BY,LIKE,ESCAPE,DISTINCT,NOT,NULL,INNER,OUTER,LEFT,RIGHT,JOIN,ON,FULL,USING,IN,IS,OR,AND,CASE,WHEN,THEN,ELSE,END,UNION,ALL,ASC,DESC,HAVING,BETWEEN,EXISTS");
        }
        this.reset(provider, p);
    }
}

