/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.chart.ChartInfo;
import hiro.yoshioka.chart.PieChartInfo;
import hiro.yoshioka.chart.TimeChartInfo;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.RDHTableViewer;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh.StringRecordPairData;
import hiro.yoshioka.sdh.pair.MarkStringData;
import hiro.yoshioka.sdh.pair.MarkType;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBResource;
import hiro.yoshioka.sql.resource.DBResourceTransfer;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.util.CommentInfo;
import hiro.yoshioka.ui.view.Messages;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.ui.view.internal.AbstractChartBuilder;
import hiro.yoshioka.ui.view.internal.ChartCanvas;
import hiro.yoshioka.ui.view.internal.DateTimeChartBuilder;
import hiro.yoshioka.ui.view.internal.PieChartBuilder;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.util.Util;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionBars;

public class CountReportView
extends SingleResultSetView {
    protected RDHTableViewer fViewer;
    public static final String ID = "CountReportViewID";
    ListViewer listViewer;
    Set<IDBTable> targetTableSet;
    String[] description = new String[]{Messages.getString("CountReportView.Description")};
    Action runAction;
    SashForm mainSash;
    SashForm graphSash;
    private Spinner intervalSpinner;
    private Combo timeCmb;
    private String[] TIME_KIND = new String[]{Messages.getString("CountReportView.SEC"), Messages.getString("CountReportView.MIN"), Messages.getString("CountReportView.HOUR")};
    private MyRunnerAction runnerAction;
    private boolean doRunning;
    ChartCanvas canvas;
    ResultSetDataHolder2 displayRdh;
    private Button fChangeOnlyBtn;
    DropTarget target;
    private DropTargetListener dnd;
    private ConnectionProperties connectionProperties;
    private Composite fChartComposite;
    int remain = 500;
    Timer timer;

    public CountReportView() {
        Comparator<IDBTable> comp = new Comparator<IDBTable>(){

            @Override
            public int compare(IDBTable arg0, IDBTable arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        };
        this.targetTableSet = new TreeSet<IDBTable>(comp);
    }

    @Override
    public int[] getSelectionIndices() {
        return this.fViewer.getTable().getSelectionIndices();
    }

    public void dispose() {
        this.resetResultSetLists();
        super.dispose();
    }

    private Control createDragableListComposite(Composite parent) {
        this.listViewer = new ListViewer(parent, 2818);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (CountReportView.this.targetTableSet.size() == 0) {
                    return CountReportView.this.description;
                }
                return CountReportView.this.targetTableSet.toArray(new IDBTable[CountReportView.this.targetTableSet.size()]);
            }
        });
        this.listViewer.setInput(this.targetTableSet);
        List list = this.listViewer.getList();
        this.target = new DropTarget((Control)list, 3);
        this.target.setTransfer(new Transfer[]{DBResourceTransfer.getInstance()});
        this.listViewer.getList().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    IStructuredSelection sel = (IStructuredSelection)CountReportView.this.listViewer.getSelection();
                    Iterator ite = sel.iterator();
                    while (ite.hasNext()) {
                        CountReportView.this.targetTableSet.remove(ite.next());
                    }
                    CountReportView.this.listViewer.refresh();
                }
            }
        });
        return this.listViewer.getControl();
    }

    public void createPartControl(Composite parent) {
        this.mainSash = new SashForm(parent, 256);
        Composite tableComposite = new Composite((Composite)this.mainSash, 0);
        this.graphSash = new SashForm((Composite)this.mainSash, 512);
        tableComposite.setLayout((Layout)new GridLayout());
        Group g = new Group(tableComposite, 0);
        g.setLayoutData((Object)new GridData(768));
        g.setText(Messages.getString("CountReportView.Config"));
        g.setLayout((Layout)new GridLayout(6, false));
        this.fChangeOnlyBtn = new Button((Composite)g, 32);
        this.fChangeOnlyBtn.setText(Messages.getString("CountReportView.ChangesOnly"));
        new Label((Composite)g, 0).setText(Messages.getString("CountReportView.Unit"));
        this.timeCmb = new Combo((Composite)g, 12);
        this.timeCmb.setItems(this.TIME_KIND);
        this.timeCmb.select(0);
        new Label((Composite)g, 0).setText("");
        Label lb = new Label((Composite)g, 0);
        lb.setText(Messages.getString("CountReportView.Interval"));
        lb.setLayoutData((Object)new GridData(768));
        this.intervalSpinner = new Spinner((Composite)g, 0);
        this.intervalSpinner.setMinimum(1);
        this.intervalSpinner.setSelection(30);
        g = new Group(tableComposite, 0);
        g.setLayoutData((Object)new GridData(1808));
        g.setText(Messages.getString("CountReportView.TargetTables"));
        g.setLayout((Layout)new FillLayout());
        this.createDragableListComposite((Composite)g);
        g = new Group((Composite)this.graphSash, 0);
        g.setText(Messages.getString("CountReportView.Chart"));
        g.setLayout((Layout)new FillLayout());
        this.fChartComposite = new Composite((Composite)g, 2048);
        this.fChartComposite.setLayout((Layout)new FillLayout());
        this.canvas = new ChartCanvas(this.fChartComposite, 0);
        g = new Group((Composite)this.graphSash, 0);
        g.setText(Messages.getString("CountReportView.CountResult"));
        g.setLayout((Layout)new FillLayout());
        this.fViewer = new RDHTableViewer((Composite)g);
        this.mainSash.setWeights(new int[]{4, 6});
        this.graphSash.setWeights(new int[]{6, 4});
        this.contributeToActionBars();
        this.setRunning(false);
    }

    private void setRunning(boolean runnning) {
        this.doRunning = runnning;
        if (this.doRunning) {
            if (this.dnd != null) {
                this.target.removeDropListener(this.dnd);
            }
            this.dnd = null;
        } else if (this.dnd == null) {
            this.dnd = new MyDnd();
            this.target.addDropListener(this.dnd);
        }
    }

    private void resetCommentInfo() {
        if (this.displayRdh == null) {
            return;
        }
        this.comInfo = new CommentInfo(false);
        StringBuilder buf = new StringBuilder();
        int i = 2;
        while (i < this.displayRdh.getKey().length) {
            buf.append(i).append(",");
            ++i;
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        String[] cfr_ignored_0 = new String[0];
        this.comInfo.add("TIME", "Table Row Count Report.:1:" + buf.toString());
    }

    private Chart createChart(ChartInfo chartInfo) {
        AbstractChartBuilder builder = chartInfo instanceof PieChartInfo ? new PieChartBuilder((PieChartInfo)chartInfo) : new DateTimeChartBuilder((TimeChartInfo)chartInfo);
        builder.build();
        return builder.getChart();
    }

    private ResultSetDataHolder2 trimSameData() {
        if (this.fResultSetDataHolder.getRowCount() < 2) {
            return this.fResultSetDataHolder;
        }
        ResultSetDataHolder2 ret = (ResultSetDataHolder2)PreferenceUtil.copyObject(this.fResultSetDataHolder);
        try {
            int len = ret.getKey().length;
            int i = 2;
            while (i < len) {
                String bef = ret.getStringRecordRow(0)[i].getString();
                boolean del = true;
                int j = 1;
                while (j < ret.getRowCount()) {
                    if (!Util.matchCanNull((String)bef, (String)ret.getStringRecordRow(j)[i].getString())) {
                        del = false;
                        break;
                    }
                    ++j;
                }
                if (del) {
                    ret.deleteColumn(i);
                    --i;
                    --len;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = bars.getToolBarManager();
        toolBar.add((IAction)new GenerateHtmlAction());
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)new ClearAction());
        toolBar.add((IAction)new StopAction());
        this.runnerAction = new MyRunnerAction();
        toolBar.add((IAction)this.runnerAction);
    }

    public void setFocus() {
        this.fChartComposite.setFocus();
        this.fViewer.getTable().setFocus();
    }

    @Override
    public void selectAll() {
        this.fViewer.doOperation(6);
    }

    @Override
    public void adjustDatum() {
        this.fViewer.setInputAdjustDatum((ResultSetDataHolder)this.displayRdh);
    }

    @Override
    public void adjustHeader() {
        this.fViewer.setInputAdjustHeader((ResultSetDataHolder)this.displayRdh);
    }

    @Override
    public void adjustArea() {
        this.fViewer.setInputAdjustArea((CSVRecordDataHolder)this.displayRdh);
    }

    @Override
    void lostFocus() {
    }

    public void setConnectionProperties(ConnectionProperties p) {
        this.connectionProperties = p;
    }

    public void setTables(IDBTable[] tables) {
        this.targetTableSet.addAll(Arrays.asList(tables));
        this.listViewer.refresh();
    }

    class ClearAction
    extends Action {
        public ClearAction() {
            super(Messages.getString("CountReportView.Clear"), 8);
            this.setImageDescriptor(ImageManager.getImageDescriptor("action/clear_co.gif"));
        }

        public void run() {
            try {
                CountReportView.this.setRunning(false);
                CountReportView.this.targetTableSet.clear();
                CountReportView.this.listViewer.refresh();
                CountReportView.this.runnerAction.clear();
                CountReportView.this.fResultSetDataHolder = null;
                CountReportView.this.displayRdh = null;
                CountReportView.this.mainSash.setWeights(new int[]{3, 7});
            }
            catch (Exception e) {
                CountReportView.this.log.error((Object)"", (Throwable)e);
            }
            this.setEnabled(true);
            this.setChecked(false);
        }
    }

    class GenerateHtmlAction
    extends Action {
        public GenerateHtmlAction() {
            super("OutputHtml", 8);
            this.setImageDescriptor(ImageUtil.getImageDescriptor((String)"action/html_add.png"));
        }

        public void runWithEvent(Event event) {
            if (CountReportView.this.displayRdh == null) {
                return;
            }
            IFolder htmlFolder = ResourceMarker.getFolder(null, ResourceMarker.htmlFolder);
            IFile html = ResourceMarker.createRandomFile(htmlFolder, ResourceMarker.htmlFolder);
            File f = ResourceMarker.cnvFile(html);
            try {
                if (CountReportView.this.displayRdh.writeGoogleHtml((Writer)new FileWriter(f), 480, "Table", CountReportView.this.getCommentInfo())) {
                    Program.launch((String)f.getAbsolutePath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setChecked(false);
        }
    }

    class MyCounterJob
    extends Job {
        public MyCounterJob() {
            super(Messages.getString("CountReportView.JobTitle"));
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus ret = JobStatus.OK_STATUS;
            String[] sql_statements = new String[CountReportView.this.targetTableSet.size()];
            IDBTable[] arrays = CountReportView.this.targetTableSet.toArray(new IDBTable[CountReportView.this.targetTableSet.size()]);
            monitor.beginTask(Messages.getString("CountReportView.taskName"), 1);
            int i = 0;
            while (i < arrays.length) {
                IDBSchema parent = (IDBSchema)arrays[i].getParent();
                CountReportView.this.log.debug((Object)("arrays[" + i + "]=" + arrays[i]));
                CountReportView.this.log.debug((Object)("arrays[" + i + "].getParent=" + parent));
                sql_statements[i] = !StringUtil.isEmpty((Object)parent.getName()) ? String.format("SELECT COUNT(*) AS CNT FROM %s.%s", parent.getName(), arrays[i].getName()) : String.format("SELECT COUNT(*) AS CNT FROM %s", arrays[i].getName());
                ++i;
            }
            new MyTransactionRequest();
            monitor.worked(1);
            return ret;
        }
    }

    class MyDnd
    implements DropTargetListener {
        MyDnd() {
        }

        public void dragEnter(DropTargetEvent event) {
            CountReportView.this.listViewer.getList().setBackground(ColorConstants.gray);
            if (event.detail == 16) {
                event.detail = 1;
            }
        }

        public void dragLeave(DropTargetEvent event) {
            CountReportView.this.listViewer.getList().setBackground(ColorConstants.white);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 1;
            }
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (event == null) {
                return;
            }
            if (event.data instanceof DBResource[]) {
                DBResource[] sels;
                DBResource[] dBResourceArray = sels = (DBResource[])event.data;
                int n = sels.length;
                int n2 = 0;
                while (n2 < n) {
                    DBResource sel = dBResourceArray[n2];
                    if (sel instanceof IDBSchema) {
                        IDBTable[] tables;
                        IDBTable[] iDBTableArray = tables = ((IDBSchema)sel).getTableOrViews();
                        int n3 = tables.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IDBTable table = iDBTableArray[n4];
                            CountReportView.this.targetTableSet.add(table);
                            ++n4;
                        }
                    } else if (sel instanceof IDBTable) {
                        CountReportView.this.targetTableSet.add((IDBTable)sel);
                    }
                    ++n2;
                }
            }
            CountReportView.this.listViewer.refresh();
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }

    class MyRunnerAction
    extends Action {
        Job job;

        public MyRunnerAction() {
            super(Messages.getString("CountReportView.Run"), 8);
            this.setImageDescriptor(ImageManager.getImageDescriptor("action/62started.gif"));
        }

        public void clear() {
            if (CountReportView.this.timer != null) {
                CountReportView.this.timer.cancel();
            }
            this.setEnabled(true);
        }

        public void run() {
            try {
                if (!CountReportView.this.connectionProperties.isConnected()) {
                    Application.openDialog("", Messages.getString("CountReportView.DisconectedMessage"), 1);
                    this.setChecked(false);
                    return;
                }
                if (CountReportView.this.targetTableSet.isEmpty()) {
                    Application.openDialog("", Messages.getString("CountReportView.NothingTableMessage"), 1);
                    this.setChecked(false);
                    return;
                }
                CountReportView.this.setRunning(true);
                CountReportView.this.remain = 500;
                this.setEnabled(false);
                String[] header = new String[CountReportView.this.targetTableSet.size() + 1];
                header[0] = Messages.getString("CountReportView.TimeChartYTitle");
                int i = 1;
                Iterator<IDBTable> ite = CountReportView.this.targetTableSet.iterator();
                while (ite.hasNext()) {
                    header[i++] = ite.next().getName();
                }
                ArrayList<ResultSetMetaCopy.MetaInfo> metaList = new ArrayList<ResultSetMetaCopy.MetaInfo>();
                int j = 0;
                while (j < header.length) {
                    ResultSetMetaCopy.MetaInfo metaInfo = new ResultSetMetaCopy.MetaInfo();
                    metaInfo.columnName = header[j];
                    metaInfo.columnType = j == 0 ? SQLDataType.TIME.getType() : SQLDataType.NUMERIC.getType();
                    metaList.add(metaInfo);
                    ++j;
                }
                ResultSetMetaCopy meta = new ResultSetMetaCopy(metaList);
                CountReportView.this.fResultSetDataHolder = new ResultSetDataHolder2(header, (ResultSetMetaData)meta, CountReportView.this.connectionProperties.getDatabaseType());
                CountReportView.this.displayRdh = new ResultSetDataHolder2(header, (ResultSetMetaData)meta, CountReportView.this.connectionProperties.getDatabaseType());
                CountReportView.this.fViewer.setInputAdjustDatum((ResultSetDataHolder)CountReportView.this.displayRdh);
                MyTimerTask task = new MyTimerTask();
                CountReportView.this.timer = new Timer(Messages.getString("CountReportView.timerConstructor"));
                switch (CountReportView.this.timeCmb.getSelectionIndex()) {
                    case 0: {
                        CountReportView.this.timer.scheduleAtFixedRate((TimerTask)task, 0L, TimeUnit.SECONDS.toMillis(CountReportView.this.intervalSpinner.getSelection()));
                        break;
                    }
                    case 1: {
                        CountReportView.this.timer.scheduleAtFixedRate((TimerTask)task, 0L, TimeUnit.MINUTES.toMillis(CountReportView.this.intervalSpinner.getSelection()));
                        break;
                    }
                    case 2: {
                        CountReportView.this.timer.scheduleAtFixedRate((TimerTask)task, 0L, TimeUnit.HOURS.toMillis(CountReportView.this.intervalSpinner.getSelection()));
                    }
                }
            }
            catch (Exception e) {
                CountReportView.this.log.error((Object)"", (Throwable)e);
            }
        }
    }

    class MyTimerTask
    extends TimerTask {
        MyTimerTask() {
        }

        @Override
        public void run() {
            MyCounterJob counterJob = new MyCounterJob();
            counterJob.setUser(false);
            counterJob.schedule();
        }
    }

    class MyTransactionRequest
    extends TransactionRequest {
        public MyTransactionRequest() {
            super(SQLOperationType.COUNTS, CountReportView.this.connectionProperties, CountReportView.this.targetTableSet.toArray(new IDBTable[CountReportView.this.targetTableSet.size()]));
            SQLServerThread.putRequest((Request)this);
        }

        public void done() {
            super.done();
            final String[] columnDatum = new String[CountReportView.this.targetTableSet.size() + 1];
            Application.exec(new Runnable(){

                @Override
                public void run() {
                    try {
                        int i;
                        if (!CountReportView.this.doRunning && ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.fResultSetDataHolder != null) {
                            return;
                        }
                        if (columnDatum.length <= 1) {
                            return;
                        }
                        Date d = new Date();
                        columnDatum[0] = String.format("%tT", d);
                        int i2 = 0;
                        while (i2 < MyTransactionRequest.this.getRdh().getRowCount()) {
                            columnDatum[i2 + 1] = MyTransactionRequest.this.getRdh().getStringData(i2, "CNT");
                            ++i2;
                        }
                        ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.fResultSetDataHolder.addRow(columnDatum);
                        int rowCount = ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.fResultSetDataHolder.getRowCount();
                        StringRecordData[] row = null;
                        if (rowCount > 1) {
                            row = ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.fResultSetDataHolder.getStringRecordRow(rowCount - 1);
                            StringRecordData[] row_prev = ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.fResultSetDataHolder.getStringRecordRow(rowCount - 2);
                            i = 1;
                            while (i < row.length) {
                                int div = 0;
                                try {
                                    div = row[i].getInt() - row_prev[i].getInt();
                                }
                                catch (Exception exception) {}
                                if (div < 0) {
                                    row[i].setPair((StringRecordPairData)new MarkStringData(String.valueOf(div), MarkType.DOWN));
                                } else if (div > 0) {
                                    row[i].setPair((StringRecordPairData)new MarkStringData(String.valueOf(div), MarkType.UP));
                                }
                                ++i;
                            }
                        }
                        ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.displayRdh = CountReportView.this.fChangeOnlyBtn.getSelection() ? CountReportView.this.trimSameData() : ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.fResultSetDataHolder;
                        CountReportView.this.resetCommentInfo();
                        CountReportView.this.adjustDatum();
                        if (row != null) {
                            ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.fViewer.reveal((Object)row);
                        }
                        if (((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.displayRdh.getKey().length > 2) {
                            TimeChartInfo ti = new TimeChartInfo("", (ResultSetDataHolder)((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.displayRdh);
                            ti.dateIndex = 1;
                            ti.valueIndexes = new int[((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.displayRdh.getKey().length - 2];
                            i = 0;
                            while (i < ti.valueIndexes.length) {
                                ti.valueIndexes[i] = i + 2;
                                ++i;
                            }
                            ti.mode = -1;
                            ti.simple = true;
                            Chart chart = CountReportView.this.createChart((ChartInfo)ti);
                            ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.canvas.setChart(chart);
                        }
                        --((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.remain;
                        if (((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.remain < 0) {
                            ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.timer.cancel();
                        }
                        int[] weight = ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.graphSash.getWeights();
                        weight[0] = weight[0] + 5;
                        weight[1] = weight[1] - 5;
                        ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.graphSash.setWeights(weight);
                        ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.graphSash.update();
                        weight[0] = weight[0] - 5;
                        weight[1] = weight[1] + 5;
                        ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.graphSash.setWeights(weight);
                        ((MyTransactionRequest)MyTransactionRequest.this).CountReportView.this.graphSash.update();
                    }
                    catch (Exception e) {
                        MyTransactionRequest.this.log.error((Object)"", (Throwable)e);
                    }
                }
            });
        }
    }

    class StopAction
    extends Action {
        public StopAction() {
            super(Messages.getString("CountReportView.Stop"), 8);
            this.setImageDescriptor(ImageManager.getImageDescriptor("action/39cancel.gif"));
        }

        public void run() {
            try {
                CountReportView.this.setRunning(false);
                CountReportView.this.runnerAction.clear();
            }
            catch (Exception e) {
                CountReportView.this.log.error((Object)"", (Throwable)e);
            }
            this.setEnabled(true);
            this.setChecked(false);
        }
    }
}

