/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.ui.view.ResultSetView;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.part.ViewPart;

public class ResultListsView
extends ViewPart {
    public static final String ID = "ResultListsViewID";
    TreeViewer fResultViewer;

    public void createPartControl(Composite parent) {
        this.createResultSetTree(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fResultViewer);
    }

    private void createResultSetTree(Composite top) {
        this.fResultViewer = new TreeViewer(top, 65538);
        this.fResultViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof SingleResultSetView[]) {
                    return (SingleResultSetView[])parentElement;
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fResultViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ResultSetView) {
                    ResultSetView rv = (ResultSetView)element;
                    return String.format("%s-%s", rv.getTitle(), rv.gettR());
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                if (element instanceof ResultSetView) {
                    return ((SingleResultSetView)element).getTitleImage();
                }
                return null;
            }
        });
        this.resetResultSet();
    }

    public void setFocus() {
    }

    public void resetResultSet() {
        IViewReference[] ref = Application.findActiveViews("ResultSetViewID");
        if (ref == null) {
            return;
        }
        SingleResultSetView[] input = new SingleResultSetView[ref.length];
        int i = 0;
        while (i < ref.length) {
            input[i] = (SingleResultSetView)ref[i].getView(true);
            ++i;
        }
        this.fResultViewer.setInput((Object)input);
    }

    public SingleResultSetView[] getSelectedResultSetView() {
        List list = ((IStructuredSelection)this.fResultViewer.getSelection()).toList();
        SingleResultSetView v0 = (SingleResultSetView)list.get(0);
        SingleResultSetView v1 = (SingleResultSetView)list.get(1);
        return new SingleResultSetView[]{v0, v1};
    }
}

