/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view.internal;

import hiro.yoshioka.chart.ChartInfo;
import hiro.yoshioka.chart.PieChartInfo;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.ui.view.internal.AbstractChartBuilder;
import java.util.HashSet;
import java.util.TreeMap;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;

public class PieChartBuilder
extends AbstractChartBuilder {
    SeriesDefinition sdX = null;
    double[] values;
    String[] XTitles;

    public PieChartBuilder(PieChartInfo info) {
        super((ChartInfo)info);
        ResultSetDataHolder rdh = info.rdh;
        if (info.topCout > 0) {
            TreeMap<Double, HashSet<String>> topMap = new TreeMap<Double, HashSet<String>>();
            double total = 0.0;
            int i = 0;
            while (i < rdh.getRowCount()) {
                String[] row = rdh.getRow(i);
                try {
                    Double d = new Double(row[info.valueIndex]);
                    HashSet<String> set = (HashSet<String>)topMap.get(d);
                    if (set == null) {
                        set = new HashSet<String>();
                        topMap.put(d, set);
                    }
                    set.add(row[info.titleIndex]);
                    total += d.doubleValue();
                }
                catch (Exception exception) {}
                ++i;
            }
            int cnt = 0;
            this.values = new double[topMap.size()];
            this.XTitles = new String[topMap.size()];
            if (this.values.length > info.topCout + 1) {
                this.values = new double[info.topCout + 1];
                this.XTitles = new String[info.topCout + 1];
            }
            for (Double d : topMap.keySet()) {
                if (cnt >= info.topCout) break;
                StringBuffer buf = new StringBuffer();
                String[] setArray = ((HashSet)topMap.get(d)).toArray(new String[0]);
                int j = 0;
                while (j < setArray.length) {
                    if (j < 3) {
                        if (j > 0) {
                            buf.append(",");
                        }
                        buf.append(setArray[j]);
                    } else if (j == 3) {
                        buf.append("..");
                    }
                    total -= d.doubleValue();
                    ++j;
                }
                this.values[cnt] = d;
                this.XTitles[cnt] = buf.toString();
                ++cnt;
            }
            if (info.topCout < topMap.size()) {
                this.values[cnt] = total;
                this.XTitles[cnt] = "others..";
            }
        } else {
            this.values = new double[rdh.getRowCount()];
            this.XTitles = new String[rdh.getRowCount()];
            int i = 0;
            while (i < rdh.getRowCount()) {
                String[] row = rdh.getRow(i);
                double d = 0.0;
                try {
                    d = Double.parseDouble(row[info.valueIndex]);
                }
                catch (Exception exception) {}
                this.values[i] = d;
                this.XTitles[i] = row[info.titleIndex];
                ++i;
            }
        }
    }

    @Override
    protected void createChart() {
        this.chart = ChartWithoutAxesImpl.create();
    }

    @Override
    protected void buildPlot() {
        this.chart.setSeriesThickness(25.0);
        this.chart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        this.chart.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        Plot p = this.chart.getPlot();
        p.getClientArea().setBackground(null);
        p.getClientArea().getOutline().setVisible(true);
        p.getOutline().setVisible(true);
    }

    @Override
    protected void buildLegend() {
        Legend lg = this.chart.getLegend();
        lg.getText().getFont().setSize(16.0f);
        lg.getOutline().setVisible(true);
    }

    @Override
    protected void buildXSeries() {
        TextDataSet categoryValues = TextDataSetImpl.create((Object)this.XTitles);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        seCategory.setTranslucent(true);
        this.sdX = SeriesDefinitionImpl.create();
        this.sdX.getSeriesPalette().update(1);
        ((ChartWithoutAxes)this.chart).getSeriesDefinitions().add((Object)this.sdX);
        this.sdX.getSeries().add((Object)seCategory);
    }

    @Override
    protected void buildYSeries() {
        NumberDataSet orthoValuesDataSet = NumberDataSetImpl.create((Object)this.values);
        PieSeries sePie = (PieSeries)PieSeriesImpl.create();
        sePie.setTranslucent(true);
        sePie.setDataSet((DataSet)orthoValuesDataSet);
        sePie.setSeriesIdentifier((Object)this.chartInfo.rdh.getKey()[((PieChartInfo)this.chartInfo).valueIndex]);
        sePie.setExplosion(5);
        SeriesDefinition sdCity = SeriesDefinitionImpl.create();
        this.sdX.getSeriesDefinitions().add((Object)sdCity);
        sdCity.getSeries().add((Object)sePie);
    }
}

