/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.wolfdbmanager;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.ui.editor.SQLColorProvider;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.ApplicationActionBarAdvisor;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Dictionary;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorHistoryItem;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public static String VER = "ver 1.0";
    public static String NAME = "Wolf";
    public static String TITLE = "Wolf DB Manager2 " + VER;
    private static StatusLineManager sm;
    private static final String RECENTLY_OPEND_FILE = "recentlyOpend.xml";
    Rectangle latestShellRectangle;
    static CLabel label;
    protected static Log fLogger;

    static {
        fLogger = LogFactory.getLog(ApplicationWorkbenchWindowAdvisor.class.getClass());
        IProduct product = Platform.getProduct();
        Dictionary dic = product.getDefiningBundle().getHeaders();
        VER = "ver" + dic.get("Bundle-Version");
        NAME = "" + dic.get("Bundle-Name");
        TITLE = String.valueOf(NAME) + " " + VER + " [Alpha Release]";
    }

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        sm = (StatusLineManager)configurer.getStatusLineManager();
        return new ApplicationActionBarAdvisor(configurer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        int width = PreferenceUtil.getInt("WINDOW_WIDTH");
        int height = PreferenceUtil.getInt("WINDOW_HEIGHT");
        configurer.setInitialSize(new Point(width, height));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setTitle(TITLE);
        configurer.setShowProgressIndicator(true);
        IPreferenceStore apiStore = PlatformUI.getPreferenceStore();
        apiStore.setValue("DOCK_PERSPECTIVE_BAR", "TOP_LEFT");
        IPerspectiveRegistry reg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        reg.getPerspectives();
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(RECENTLY_OPEND_FILE);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                EditorHistory history = ((Workbench)this.getWindowConfigurer().getWindow().getWorkbench()).getEditorHistory();
                history.restoreState((IMemento)memento);
                return;
            }
            catch (FileNotFoundException e) {
                fLogger.warn((Object)e.getMessage());
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    fLogger.warn((Object)"", (Throwable)e2);
                }
                return;
            }
            catch (Exception e) {
                fLogger.warn((Object)"", (Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e3) {
                    fLogger.warn((Object)"", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    fLogger.warn((Object)"", (Throwable)e);
                }
            }
        }
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        IWorkbenchPage page = Application.getWorkbenchPage();
        page.setPerspective(PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("TableListPerspectiveID"));
        page.setPerspective(PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("wolfdbmanager.perspective"));
    }

    public boolean preWindowShellClose() {
        System.out.println("close allllllllllllllll");
        Application.closeAllEditors();
        Application.closeAllViews();
        System.out.println("closedddddddddddddddddddddd allllllllllllllll");
        return super.preWindowShellClose();
    }

    public void postWindowClose() {
        block11: {
            SQLColorProvider.getInstance().dispose();
            if (this.latestShellRectangle != null) {
                PreferenceUtil.setInt("WINDOW_WIDTH", this.latestShellRectangle.width);
                PreferenceUtil.setInt("WINDOW_HEIGHT", this.latestShellRectangle.height);
            }
            ResourceMarker.deleteZeroFiles();
            XMLMemento memento = XMLMemento.createWriteRoot((String)"hogeeee");
            EditorHistory history = ((Workbench)this.getWindowConfigurer().getWindow().getWorkbench()).getEditorHistory();
            EditorHistoryItem[] items = history.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getName().startsWith("s__")) {
                    history.remove(items[i]);
                }
                ++i;
            }
            history.saveState((IMemento)memento);
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new FileWriter(RECENTLY_OPEND_FILE));
                    memento.save((Writer)out);
                }
                catch (IOException e) {
                    fLogger.warn((Object)"", (Throwable)e);
                    if (out != null) {
                        out.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            if (out != null) {
                out.close();
            }
        }
        super.postWindowClose();
    }

    public static void setStatusImage(Color[] colors, int[] percents) {
        try {
            if (label != null) {
                label.setBackground(colors, percents);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setStatusBackground(Color color) {
        try {
            if (label != null) {
                label.setBackground(color);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setStatusImage(Image image) {
        try {
            if (label != null) {
                label.setBackground(image);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void postWindowOpen() {
        System.out.println("locale=" + Locale.getDefault());
        Control con = sm.getControl();
        try {
            Field field = con.getClass().getDeclaredField("fMessageLabel");
            field.setAccessible(true);
            label = (CLabel)field.get(con);
            Application.resetLogColor();
        }
        catch (Throwable e) {
            fLogger.warn((Object)"", e);
        }
        ApplicationWorkbenchWindowAdvisor.setStatusImage(ImageManager.getStatusImage());
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        ImageManager.setShellImages(this.getWindowConfigurer().getWindow().getShell());
        Shell shell = configurer.getWindow().getShell();
        shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Shell me = e.display.getActiveShell();
                if (!me.getMaximized() && !me.getMinimized()) {
                    ApplicationWorkbenchWindowAdvisor.this.latestShellRectangle = me.getBounds();
                }
            }
        });
        IWorkbenchPage page = Application.getWorkbenchPage();
        page.hideActionSet("org.eclipse.ui.edit.text.actionSet.annotationNavigation");
        page.hideActionSet("org.eclipse.ui.edit.text.actionSet.navigation");
        page.hideActionSet("org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo");
        page.hideActionSet("org.eclipse.ui.actionSet.openFiles");
        page.showActionSet("org.eclipse.ui.edit.text.actionSet.presentation");
        Application.timer_exec(800, new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = Application.getWorkbenchPage();
                    page.showView("org.eclipse.ui.views.PropertySheet");
                    page.showView("org.eclipse.ui.views.ProblemView");
                    ResourceMarker.createResource();
                    ResourceNavigator navi = (ResourceNavigator)Application.findActiveView("org.eclipse.ui.views.ResourceNavigator");
                    if (navi == null) {
                        navi = (ResourceNavigator)page.showView("org.eclipse.ui.views.ResourceNavigator");
                    }
                    navi.getViewer().setExpandedElements(new Object[]{ResourceMarker.getMyProject()});
                    navi.getViewer().setSelection((ISelection)new StructuredSelection());
                }
                catch (Throwable e) {
                    fLogger.warn((Object)"", e);
                }
            }
        });
    }
}

