/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.wolfdbmanager.resource;

import hiro.yoshioka.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class ResourceMarker {
    protected static Log fLogger = LogFactory.getLog(ResourceMarker.class.getClass());
    static final String MY_PROJECT = "MyProject";
    static final String[] imgFiles = new String[0];
    static final String[] sqlFiles = new String[]{"oracle_table_capacity.sql", "hsql_Biorhythm.sql", "oracle_Biorhythm.sql", "postgre_Biorhythm.sql", "oracle_CPUutilization.sql", "postgre_cachehitratio.sql", "postgre_stat_user_tables.sql", "postgre_findLock.sql", "postgre_memory_settings.sql", "postgre_stat_transaction.sql"};
    static final String[] htmlFiles = new String[0];
    static final String[] cssFiles = new String[0];
    static final String[] jsFiles = new String[0];
    public static final String[] imageFiles = new String[]{"sit.gif", "run.gif", "sakura_w01.gif", "sakura_w04.jpg", "sakura3.gif", "rose_w07.gif", "rose_w10.jpg", "onpu.gif"};
    public static final String[] scriptFiles = new String[]{"sampleAddColumn.js", "shortenDateValues.js", "replaceThousandsSeparator.js"};
    public static String lstFolder = "lst";
    public static String genFolder = "gen";
    public static String rstFolder = "rst";
    public static String sqtFolder = "sqt";
    public static String sqlFolder = "sql";
    public static String yamlFolder = "yaml";
    public static String scriptFolder = "script";
    public static String xlsFolder = "xls";
    public static String htmlFolder = "html";
    public static String csvFolder = "csv";
    private static final String[] makeFolders = new String[]{lstFolder, genFolder, rstFolder, sqtFolder, sqlFolder, yamlFolder, xlsFolder, htmlFolder, csvFolder, scriptFolder};
    public static File themaFolder;

    private static void deleteMembers(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            IFile file;
            IFileStore testLocationStore;
            File storeAsFile;
            if (members[i].isAccessible() && members[i] instanceof IFile && ((storeAsFile = (testLocationStore = EFS.getStore((URI)(file = (IFile)members[i]).getLocationURI())).toLocalFile(0, null)).length() == 0L || members[i].getName().startsWith("s__"))) {
                members[i].delete(true, monitor);
            }
            ++i;
        }
    }

    public static void deleteZeroFiles() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            String[] folders;
            String[] stringArray = folders = new String[]{lstFolder, sqlFolder, yamlFolder};
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                String folderName = stringArray[n2];
                IFolder folder = ResourceMarker.getFolder(null, folderName);
                ResourceMarker.deleteMembers(folder, (IProgressMonitor)monitor);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static String[] getCsss() {
        ArrayList<String> retList = new ArrayList<String>();
        IFolder folder = ResourceMarker.getFolder(null, "html");
        IFolder folder2 = folder.getFolder("css");
        try {
            IResource[] members = folder2.members();
            int i = 0;
            while (i < members.length) {
                if (members[i].isAccessible() && members[i] instanceof IFile) {
                    IFile cfr_ignored_0 = (IFile)members[i];
                    if (members[i].getName().endsWith(".css")) {
                        retList.add(members[i].getName());
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return retList.toArray(new String[retList.size()]);
    }

    public static void createThema() {
        themaFolder = new File("thema/images");
        if (!themaFolder.exists()) {
            themaFolder.mkdirs();
        }
        try {
            ResourceMarker.mkBinalyFile("thema/images/", imageFiles);
        }
        catch (IOException e) {
            fLogger.error((Object)e);
        }
    }

    private static void createFiles(IFolder folder, String[] fileNames, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < fileNames.length) {
            IFile file = folder.getFile(fileNames[i]);
            if (!file.isAccessible()) {
                FileUtil util = new FileUtil(ResourceMarker.class, fileNames[i]);
                BufferedInputStream input = util.getStream();
                file.create((InputStream)input, true, monitor);
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static final File getScriptFolder() {
        IFolder folder = ResourceMarker.getFolder(ResourceMarker.getMyProject(), scriptFolder);
        return ResourceMarker.cnvFile(folder);
    }

    public static final IFolder getFolder(IProject project, String folderName) {
        return ResourceMarker.getFolder(project, folderName, false);
    }

    public static final IFolder getFolder(IProject project, String folderName, boolean force) {
        IFolder folder;
        if (project == null) {
            project = ResourceMarker.getMyProject();
        }
        if (!(folder = project.getFolder(folderName)).isAccessible() && force) {
            try {
                folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return folder;
    }

    public static final IFolder getFolder(IFolder ifolder, String folderName, boolean force) {
        IFolder folder = ifolder.getFolder(folderName);
        if (!folder.isAccessible() && force) {
            try {
                folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return folder;
    }

    public static File cnvFile(IFolder folder) {
        File storeAsFile = null;
        try {
            IFileStore testLocationStore = EFS.getStore((URI)folder.getLocationURI());
            storeAsFile = testLocationStore.toLocalFile(0, null);
        }
        catch (CoreException coreException) {}
        return storeAsFile;
    }

    public static final File cnvFile(IFile file) {
        File storeAsFile = null;
        try {
            IFileStore testLocationStore = EFS.getStore((URI)file.getLocationURI());
            storeAsFile = testLocationStore.toLocalFile(0, null);
        }
        catch (CoreException coreException) {}
        return storeAsFile;
    }

    public static IFile createRandomFile(IFolder folder, String postfix) {
        return ResourceMarker.createRandomFile(folder, postfix, "s__");
    }

    public static IFile createRandomFile(IFolder folder, String postfix, String prefix) {
        Random random = new Random(System.currentTimeMillis());
        String numbers = String.format("%s_%04d.%s", prefix, random.nextInt(10000), postfix);
        return ResourceMarker.createFile(folder, numbers);
    }

    public static final IFile createFile(IFolder folder, String name) {
        IFile file = folder.getFile(name);
        try {
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static final IFile createFile(IFolder folder, String name, boolean retry) {
        IFile file = folder.getFile(name = FileUtil.renameForWindows((String)name, (String)"_"));
        if (!file.exists()) {
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ResourceException e) {
                if (retry) {
                    String newName = name.substring(0, name.lastIndexOf(46));
                    file = folder.getFile(String.valueOf(newName) + "_1." + file.getFileExtension());
                    try {
                        file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        fLogger.error((Object)e);
                    }
                }
            }
            catch (CoreException e) {
                fLogger.error((Object)e);
            }
        }
        return file;
    }

    public static final IProject getMyProject() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(MY_PROJECT);
        if (!project.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            try {
                project.create((IProgressMonitor)monitor);
                project.open((IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return project;
    }

    public static void createResource() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        fLogger.info((Object)"START");
                        root.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        IProject project = root.getProject(ResourceMarker.MY_PROJECT);
                        if (project.exists()) {
                            project.open(monitor);
                        } else {
                            project.create(monitor);
                            project.open(monitor);
                        }
                        int i = 0;
                        while (i < makeFolders.length) {
                            IFolder folder = project.getFolder(makeFolders[i]);
                            if (!folder.isAccessible()) {
                                folder.create(false, true, monitor);
                                fLogger.info((Object)("create[" + folder + "]"));
                            }
                            ++i;
                        }
                        IFolder folder = project.getFolder(sqlFolder);
                        ResourceMarker.createFiles(folder, sqlFiles, monitor);
                        project.getFolder(yamlFolder);
                        folder = project.getFolder("html");
                        IFolder folder2 = folder.getFolder("js");
                        if (!folder2.isAccessible()) {
                            folder2.create(false, true, monitor);
                        }
                        ResourceMarker.createFiles(folder2, jsFiles, monitor);
                        folder2 = folder.getFolder("css");
                        if (!folder2.isAccessible()) {
                            folder2.create(false, true, monitor);
                        }
                        ResourceMarker.createFiles(folder2, cssFiles, monitor);
                        folder2 = folder.getFolder("images");
                        if (!folder2.isAccessible()) {
                            folder2.create(false, true, monitor);
                        }
                        ResourceMarker.createFiles(folder2, imgFiles, monitor);
                        folder2 = project.getFolder("script");
                        if (!folder2.isAccessible()) {
                            folder2.create(false, true, monitor);
                        }
                        ResourceMarker.createFiles(folder2, scriptFiles, monitor);
                        fLogger.info((Object)"END");
                    }
                    catch (CoreException e) {
                        fLogger.warn((Object)"", (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(new Shell()).run(true, false, op);
        }
        catch (Exception e) {
            fLogger.warn((Object)"", (Throwable)e);
        }
    }

    private static void mkBinalyFile(String path, String[] files) throws IOException {
        int i = 0;
        while (i < files.length) {
            FileUtil util = new FileUtil(ResourceMarker.class, files[i]);
            File imgTmp = new File(path, files[i]);
            if (!imgTmp.exists()) {
                fLogger.warn((Object)("[" + imgTmp.getAbsolutePath() + "] Created"));
                FileOutputStream out = new FileOutputStream(imgTmp);
                BufferedInputStream input = util.getStream();
                byte[] buff = new byte[256];
                int len = 0;
                while ((len = input.read(buff, 0, 256)) > 0) {
                    out.write(buff, 0, len);
                }
                out.flush();
                out.close();
                input.close();
            }
            ++i;
        }
    }
}

