/*
 * Decompiled with CFR 0.152.
 */
package sample;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Snippet230 {
    public static void main(String[] args) {
        Display display = new Display();
        Image image = display.getSystemImage(2);
        Shell shell = new Shell(display);
        shell.setText("Images on the right side of the TableItem");
        shell.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)shell, 65538);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int columnCount = 3;
        int i = 0;
        while (i < columnCount) {
            TableColumn column = new TableColumn(table, 0);
            column.setText("Column " + i);
            ++i;
        }
        int itemCount = 8;
        int i2 = 0;
        while (i2 < itemCount) {
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{"item " + i2 + " a", "item " + i2 + " b", "item " + i2 + " c"});
            ++i2;
        }
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        Rectangle rect = image.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x + event.width;
                        Rectangle rect = image.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(image, x, event.y + offset);
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        int i3 = 0;
        while (i3 < columnCount) {
            table.getColumn(i3).pack();
            ++i3;
        }
        shell.setSize(500, 200);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (image != null) {
            image.dispose();
        }
        display.dispose();
    }
}

