/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.romdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.doc.romdoc.DocComparator;
import org.eclipse.birt.doc.romdoc.DocComposite;
import org.eclipse.birt.doc.romdoc.DocInheritedProperty;
import org.eclipse.birt.doc.romdoc.DocMethod;
import org.eclipse.birt.doc.romdoc.DocProperty;
import org.eclipse.birt.doc.romdoc.DocSlot;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class DocElement
extends DocComposite {
    protected ArrayList methods = new ArrayList();
    protected ArrayList slots = new ArrayList();
    private ArrayList inheritedPropertyNote = new ArrayList();

    /*
     * WARNING - void declaration
     */
    public DocElement(ElementDefn d) {
        super(d);
        void var4_6;
        ElementDefn elementDefn = d;
        for (ElementPropertyDefn elementPropertyDefn : elementDefn.getLocalProperties()) {
            if (elementPropertyDefn.definedBy() != elementDefn) continue;
            if (elementPropertyDefn.getTypeCode() == 18) {
                this.methods.add(new DocMethod(elementPropertyDefn));
                continue;
            }
            this.properties.add(new DocProperty(elementPropertyDefn));
        }
        Collections.sort(this.properties, new DocComparator());
        Collections.sort(this.methods, new DocComparator());
        boolean bl = false;
        while (var4_6 < elementDefn.getSlotCount()) {
            this.slots.add(new DocSlot(elementDefn.getSlot((int)var4_6)));
            ++var4_6;
        }
    }

    public ElementDefn getElementDefn() {
        return (ElementDefn)this.defn;
    }

    public boolean hasMethods() {
        return !this.methods.isEmpty();
    }

    public ArrayList getMethods() {
        return this.methods;
    }

    public boolean hasSlots() {
        return !this.slots.isEmpty();
    }

    public ArrayList getSlots() {
        return this.slots;
    }

    public String getExtends() {
        if (this.getElementDefn().getExtends() != null) {
            return this.makeElementLink(this.getElementDefn().getExtends(), "elements");
        }
        return "None";
    }

    public String getExtendable() {
        return this.yesNo(this.getElementDefn().canExtend());
    }

    public String getAbstract() {
        return this.yesNo(this.getElementDefn().isAbstract());
    }

    public String getNameSpace() {
        switch (this.getElementDefn().getNameSpaceID()) {
            case 0: {
                return "Styles";
            }
            case 4: {
                return "Data Sets";
            }
            case 3: {
                return "Data Sources";
            }
            case 1: {
                return "Report Items";
            }
            case 2: {
                return "Parameters";
            }
            case 5: {
                return "Pages";
            }
        }
        return "None";
    }

    public String getNameRequirement() {
        switch (this.getElementDefn().getNameOption()) {
            case 2: {
                return "Required";
            }
            case 1: {
                return "Optional";
            }
        }
        return "Not Supported";
    }

    public String getStyle() {
        String style = this.getElementDefn().getSelector();
        if (style == null) {
            return "None";
        }
        String[] styles = style.split(",");
        StringBuffer link = new StringBuffer();
        int i = 0;
        while (i < styles.length) {
            if (i > 0) {
                link.append(", ");
            }
            link.append("<a href=\"../styles.html#");
            link.append(styles[i]);
            link.append("\">");
            link.append(styles[i]);
            link.append("</a>");
            ++i;
        }
        return link.toString();
    }

    public String getUserProperties() {
        return this.yesNo(this.getElementDefn().allowsUserProperties());
    }

    public String getHasStyle() {
        return this.yesNo(this.getElementDefn().hasStyle());
    }

    public List getInheritedProperties() {
        ArrayList<ElementPropertyDefn> inherited = new ArrayList<ElementPropertyDefn>();
        for (ElementPropertyDefn elementPropertyDefn : this.getElementDefn().getProperties()) {
            if (elementPropertyDefn.definedBy() == this.defn || elementPropertyDefn.getTypeCode() == 18 || elementPropertyDefn.isStyleProperty()) continue;
            inherited.add(elementPropertyDefn);
        }
        Collections.sort(inherited, new DocComposite.PropComparator());
        return inherited;
    }

    public List getStyleProperties() {
        ArrayList<ElementPropertyDefn> inherited = new ArrayList<ElementPropertyDefn>();
        for (ElementPropertyDefn elementPropertyDefn : this.getElementDefn().getProperties()) {
            if (elementPropertyDefn.definedBy() == this.defn || elementPropertyDefn.getTypeCode() == 18 || !elementPropertyDefn.isStyleProperty()) continue;
            inherited.add(elementPropertyDefn);
        }
        Collections.sort(inherited, new DocComposite.PropComparator());
        return inherited;
    }

    public boolean hasStyle() {
        return this.getElementDefn().hasStyle();
    }

    public List getInheritedMethods() {
        ArrayList<ElementPropertyDefn> inherited = new ArrayList<ElementPropertyDefn>();
        for (ElementPropertyDefn elementPropertyDefn : this.getElementDefn().getProperties()) {
            if (elementPropertyDefn.definedBy() == this.defn || elementPropertyDefn.getTypeCode() != 18) continue;
            inherited.add(elementPropertyDefn);
        }
        return inherited;
    }

    public List getInheritedSlots() {
        return new ArrayList();
    }

    public String getXmlElement() {
        if (this.getElementDefn().isAbstract()) {
            return "None";
        }
        return this.getElementDefn().getXmlName();
    }

    public void setXmlSummary(String string) {
        this.xmlSummary = string;
    }

    public void addInheritedPropertyNote(DocInheritedProperty prop) {
        this.inheritedPropertyNote.add(prop);
    }

    public List getInheritedPropertyNotes() {
        return this.inheritedPropertyNote;
    }

    public DocMethod getMethod(String name) {
        for (DocMethod method : this.methods) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public DocSlot getSlot(String name) {
        for (DocSlot slot : this.slots) {
            if (!slot.getName().equals(name)) continue;
            return slot;
        }
        return null;
    }

    public boolean isElement() {
        return true;
    }

    public String getDefiningElement(String name) {
        return ((ElementPropertyDefn)this.defn.findProperty(name)).definedBy().getName();
    }
}

