/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.TextualPropertyType;

public class MemberKeyPropertyType
extends TextualPropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.memberKey";

    public MemberKeyPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 22;
    }

    public String getName() {
        return "memberKey";
    }

    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (defn != null);
        if (value == null) {
            if (defn.isStructureMember()) {
                throw new PropertyValueException(null, "Error.PropertyValueException.VALUE_REQUIRED", 22);
            }
            return null;
        }
        if (value instanceof String) {
            String stringValue = this.trimString((String)value, defn.getTrimOption());
            if (stringValue == null) {
                if (defn.isStructureMember()) {
                    throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 22);
                }
                return null;
            }
            return stringValue;
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 22);
    }

    public Object validateXml(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if (tmpValue == null) {
            return null;
        }
        return this.trimString(tmpValue, defn.getTrimOption());
    }
}

