/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FontCanvas;
import org.eclipse.birt.chart.ui.swt.interfaces.IFontDefinitionDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FontDefinitionComposite
extends Composite {
    private static final String TOOLTIP = Messages.getString("FontDefinitionComposite.Tooltip.FontDialog");
    private Composite cmpContent = null;
    private FontCanvas cnvSelection = null;
    private Button btnFont = null;
    private FontDefinition fdCurrent = null;
    private ColorDefinition cdCurrent = null;
    private Vector<Listener> vListeners = null;
    public static final int FONT_CHANTED_EVENT = 1;
    public static final int FONT_DATA = 0;
    public static final int COLOR_DATA = 1;
    private int iSize = 18;
    private boolean bEnabled = true;
    private boolean isAlignmentEnabled = true;
    private ChartWizardContext wizardContext;

    public FontDefinitionComposite(Composite parent, int style, ChartWizardContext wizardContext, FontDefinition fdSelected, ColorDefinition cdSelected, boolean isAlignmentEnabled) {
        super(parent, style);
        this.wizardContext = wizardContext;
        this.fdCurrent = fdSelected;
        this.cdCurrent = cdSelected;
        this.isAlignmentEnabled = isAlignmentEnabled;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    private void init() {
        if (Display.getCurrent().getHighContrast()) {
            GC gc = new GC((Drawable)this);
            this.iSize = gc.getFontMetrics().getHeight() + 2;
        }
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glContent = new GridLayout();
        glContent.verticalSpacing = 0;
        glContent.horizontalSpacing = 2;
        glContent.marginHeight = 0;
        glContent.marginWidth = 0;
        glContent.numColumns = 2;
        this.setLayout((Layout)flMain);
        this.cmpContent = new Composite((Composite)this, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.cnvSelection = new FontCanvas(this.cmpContent, 2048, this.fdCurrent, this.cdCurrent, false, true, false);
        GridData gdCNVSelection = new GridData(768);
        gdCNVSelection.heightHint = this.iSize;
        this.cnvSelection.setLayoutData(gdCNVSelection);
        this.cnvSelection.setToolTipText(TOOLTIP);
        this.cnvSelection.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FontDefinitionComposite.this.openFontDialog();
            }
        });
        this.cnvSelection.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FontDefinitionComposite.this.cnvSelection.traverse(16);
            }
        });
        this.btnFont = new Button(this.cmpContent, 0);
        GridData gdBEllipsis = new GridData();
        ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gdBEllipsis);
        this.btnFont.setLayoutData((Object)gdBEllipsis);
        this.btnFont.setText("A");
        this.btnFont.setFont(new Font((Device)Display.getCurrent(), "Times New Roman", 14, 1));
        this.btnFont.setToolTipText(TOOLTIP);
        this.btnFont.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDefinitionComposite.this.openFontDialog();
            }
        });
    }

    public void setEnabled(boolean bState) {
        this.btnFont.setEnabled(bState);
        this.cnvSelection.setEnabled(bState);
        this.cnvSelection.redraw();
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public FontDefinition getFontDefinition() {
        return this.fdCurrent;
    }

    public ColorDefinition getFontColor() {
        return this.cdCurrent;
    }

    public void setFontDefinition(FontDefinition fd) {
        this.fdCurrent = fd;
        this.cnvSelection.setFontDefinition(this.fdCurrent);
        this.cnvSelection.redraw();
    }

    public void setFontColor(ColorDefinition cd) {
        this.cdCurrent = cd;
        this.cnvSelection.setColor(this.cdCurrent);
        this.cnvSelection.redraw();
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    void openFontDialog() {
        IFontDefinitionDialog fontDlg = this.openFontDefinitionDialog(this.getShell(), this.fdCurrent, this.cdCurrent);
        if (fontDlg.open() == 0) {
            this.fdCurrent = fontDlg.getFontDefinition();
            this.cdCurrent = fontDlg.getFontColor();
            this.cnvSelection.setFontDefinition(this.fdCurrent);
            this.cnvSelection.setColor(this.cdCurrent);
            this.cnvSelection.redraw();
            this.fireEvent();
        }
    }

    protected IFontDefinitionDialog openFontDefinitionDialog(Shell shellParent, FontDefinition fdCurrent, ColorDefinition cdCurrent) {
        return this.wizardContext.getUIFactory().createFontDefinitionDialog(shellParent, this.wizardContext, fdCurrent, cdCurrent, this.isAlignmentEnabled);
    }

    private void fireEvent() {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            Object[] data;
            Event se = new Event();
            se.widget = this;
            se.data = data = new Object[]{this.fdCurrent, this.cdCurrent};
            se.type = 1;
            this.vListeners.get(iL).handleEvent(se);
            ++iL;
        }
    }

    public Point getPreferredSize() {
        Point bP = this.btnFont.computeSize(-1, -1);
        return new Point(this.cnvSelection.getPreferredWidth() + bP.x + 2, bP.y);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = FontDefinitionComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = FontDefinitionComposite.this.toControl(new Point(e.x, e.y));
                if (FontDefinitionComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FontDefinitionComposite.this.getBounds();
                Point pt = FontDefinitionComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

