/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Line Chart";
    protected static final String STACKED_SUBTYPE_LITERAL = "Stacked";
    protected static final String PERCENTSTACKED_SUBTYPE_LITERAL = "Percent Stacked";
    protected static final String OVERLAY_SUBTYPE_LITERAL = "Overlay";

    public LineChart() {
        this.chartTitle = Messages.getString("LineChart.Txt.DefaultLineChartTitle");
    }

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return UIHelper.getImage((String)"icons/obj16/linecharticon.gif");
    }

    protected Image getImageForSubtype(String sDimension, Orientation orientation, String subtype) {
        String imagePath = null;
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            if (subtype.equals(OVERLAY_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/sidebysidelinechartimage.gif" : "icons/wizban/horizontalsidebysidelinechartimage.gif";
            } else if (subtype.equals(STACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/stackedlinechartimage.gif" : "icons/wizban/horizontalstackedlinechartimage.gif";
            } else if (subtype.equals(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/percentstackedlinechartimage.gif" : "icons/wizban/horizontalpercentstackedlinechartimage.gif";
            }
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            imagePath = "icons/wizban/sidebysidelinechart3dimage.gif";
        }
        if (imagePath != null) {
            return UIHelper.getImage((String)imagePath);
        }
        return null;
    }

    protected String getDescriptionForSubtype(String subtypeLiteral) {
        if (OVERLAY_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString("LineChart.Txt.OverlayDescription");
        }
        if (STACKED_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString("LineChart.Txt.StackedDescription");
        }
        if (PERCENTSTACKED_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString("LineChart.Txt.PercentStackedDescription");
        }
        return null;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("LineChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, OVERLAY_SUBTYPE_LITERAL), this.getDescriptionForSubtype(OVERLAY_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.Overlay")));
            if (this.isStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, STACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(STACKED_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.Stacked")));
            }
            if (this.isPercentStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(PERCENTSTACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, PERCENTSTACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(PERCENTSTACKED_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.PercentStacked")));
            }
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, OVERLAY_SUBTYPE_LITERAL), this.getDescriptionForSubtype(OVERLAY_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.Overlay")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        Series valueSeries;
        SeriesDefinition sdY;
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.createDefault();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        ChartElementUtil.setEObjectAttribute((EObject)newChart, (String)"orientation", (Object)orientation, (orientation == null ? 1 : 0) != 0);
        ChartElementUtil.setEObjectAttribute((EObject)newChart, (String)"dimension", (Object)ChartUIUtil.getDimensionType((String)sDimension), (sDimension == null ? 1 : 0) != 0);
        try {
            ChartElementUtil.setDefaultValue((Object)newChart.getAxes().get(0), (String)"categoryAxis", (Object)true);
        }
        catch (ChartException chartException) {}
        Axis xAxis = (Axis)newChart.getAxes().get(0);
        SeriesDefinition sdX = SeriesDefinitionImpl.createDefault();
        Series categorySeries = SeriesImpl.createDefault();
        sdX.getSeries().add((Object)categorySeries);
        xAxis.getSeriesDefinitions().add((Object)sdX);
        Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
        if (sSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL)) {
            sdY = SeriesDefinitionImpl.createDefault();
            valueSeries = this.getSeries(false);
            valueSeries.setStacked(true);
            sdY.getSeries().add((Object)valueSeries);
            yAxis.getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
            sdY = SeriesDefinitionImpl.createDefault();
            valueSeries = this.getSeries(false);
            valueSeries.setStacked(true);
            sdY.getSeries().add((Object)valueSeries);
            yAxis.getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(OVERLAY_SUBTYPE_LITERAL)) {
            sdY = SeriesDefinitionImpl.createDefault();
            valueSeries = this.getSeries(false);
            sdY.getSeries().add((Object)valueSeries);
            yAxis.getSeriesDefinitions().add((Object)sdY);
        }
        if (sDimension != null && sDimension.equals(THREE_DIMENSION_TYPE)) {
            newChart.setRotation(Rotation3DImpl.createDefault((Angle3D[])new Angle3D[]{Angle3DImpl.createDefault((double)-20.0, (double)45.0, (double)0.0)}));
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.createDefault((int)3);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            SeriesDefinition sdZ = SeriesDefinitionImpl.createDefault();
            sdZ.getSeries().add((Object)SeriesImpl.createDefault());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
        }
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,-4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        if (newChart.getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
            sdAncillary.setDataSetRepresentation("Series 1");
            sd.getAncillarySampleData().add((Object)sdAncillary);
        }
        newChart.setSampleData(sd);
    }

    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Chart helperModel = currentChart.copyInstance();
        helperModel.eAdapters().addAll((Collection)currentChart.eAdapters());
        ChartDimension oldDimension = currentChart.getDimension();
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        IChartType oldType = ChartUIUtil.getChartType((String)currentChart.getType());
        if (currentChart instanceof ChartWithAxes) {
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                currentChart.setSubType(sNewSubType);
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                        if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                            ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                        }
                        ((Axis)axes.get(i)).setPercent(true);
                    } else {
                        ((Axis)axes.get(i)).setPercent(false);
                    }
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    Series firstSeries = ((SeriesDefinition)seriesdefinitions.get(0)).getDesignTimeSeries();
                    int j = 0;
                    while (j < seriesdefinitions.size()) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            if (j != 0) {
                                series = this.getConvertedSeriesAsFirst(series, seriesIndex, firstSeries);
                            }
                            ++seriesIndex;
                            if (!ChartPreviewPainter.isLivePreviewActive() && ((Axis)axes.get(i)).isSetType() && !this.isNumbericAxis((Axis)axes.get(i))) {
                                ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                            }
                            if (series.canBeStacked()) {
                                series.setStacked(true);
                            }
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        } else {
                            series.setStacked(false);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                currentChart.setType(TYPE_LITERAL);
                currentChart.setSubType(sNewSubType);
                Text title = currentChart.getTitle().getLabel().getCaption();
                if (title.getValue() != null && (title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim()))) {
                    title.setValue(this.getDefaultTitle());
                }
                ArrayList<AxisType> axisTypes = new ArrayList<AxisType>();
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (!ChartPreviewPainter.isLivePreviewActive() && ((Axis)axes.get(i)).isSetType() && !this.isNumbericAxis((Axis)axes.get(i))) {
                        ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                    }
                    ((Axis)axes.get(i)).setPercent(sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL));
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    int j = 0;
                    while (j < seriesdefinitions.size()) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex++);
                        if (!ChartPreviewPainter.isLivePreviewActive() && ((Axis)axes.get(i)).isSetType() && !this.isNumbericAxis((Axis)axes.get(i))) {
                            ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                        }
                        boolean isStacked = sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL);
                        series.setStacked(isStacked);
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        axisTypes.add(((Axis)axes.get(i)).getType());
                        ++j;
                    }
                    ++i;
                }
                currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType(), axisTypes));
            }
        } else {
            currentChart = ChartWithAxesImpl.createDefault();
            this.copyChartProperties(helperModel, currentChart);
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"orientation", (Object)newOrientation, (newOrientation == null ? 1 : 0) != 0);
            ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"dimension", (Object)ChartUIUtil.getDimensionType((String)sNewDimension), (sNewDimension == null ? 1 : 0) != 0);
            try {
                ChartElementUtil.setDefaultValue((Object)((ChartWithAxes)currentChart).getAxes().get(0), (String)"categoryAxis", (Object)true);
            }
            catch (ChartException chartException) {}
            Axis xAxis = (Axis)((ChartWithAxes)currentChart).getAxes().get(0);
            Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
            xAxis.getSeriesDefinitions().clear();
            xAxis.getSeriesDefinitions().add((Object)((SeriesDefinition)((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0)));
            yAxis.getSeriesDefinitions().clear();
            yAxis.getSeriesDefinitions().addAll((Collection)((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeriesDefinitions());
            Series series = ((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = yAxis.getSeriesDefinitions();
            int j = 0;
            while (j < seriesdefinitions.size()) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                    series.setStacked(true);
                } else {
                    series.setStacked(false);
                }
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                ++j;
            }
            Text title = currentChart.getTitle().getLabel().getCaption();
            if (title.getValue() != null && (title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim()))) {
                title.setValue(this.getDefaultTitle());
            }
        }
        ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"orientation", (Object)newOrientation, (newOrientation == null ? 1 : 0) != 0);
        ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"dimension", (Object)ChartUIUtil.getDimensionType((String)sNewDimension), (sNewDimension == null ? 1 : 0) != 0);
        if (sNewDimension != null && sNewDimension.equals(THREE_DIMENSION_TYPE) && ChartUIUtil.getDimensionType((String)sNewDimension) != oldDimension) {
            ((ChartWithAxes)currentChart).setRotation(Rotation3DImpl.createDefault((Angle3D[])new Angle3D[]{Angle3DImpl.createDefault((double)-20.0, (double)45.0, (double)0.0)}));
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.createDefault((int)3);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            SeriesDefinition sdZ = SeriesDefinitionImpl.createDefault();
            sdZ.getSeries().add((Object)SeriesImpl.createDefault());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
            if (currentChart.getSampleData().getAncillarySampleData().isEmpty()) {
                BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
                sdAncillary.setDataSetRepresentation("Series 1");
                currentChart.getSampleData().getAncillarySampleData().add((Object)sdAncillary);
            }
            EList seriesdefinitions = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)currentChart, (int)0);
            int j = 0;
            while (j < seriesdefinitions.size()) {
                Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series.setStacked(false);
                ++j;
            }
        }
        ChartUIUtil.restoreLabelPositionFromCache((Chart)currentChart);
        return currentChart;
    }

    private boolean isNumbericAxis(Axis axis) {
        return axis.getType().getValue() == 0 || axis.getType().getValue() == 1;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        LineSeries lineseries = (LineSeries)ChartCacheManager.getInstance().findSeries(LineSeriesImpl.class.getName(), seriesIndex);
        if (lineseries == null) {
            lineseries = (LineSeries)this.getSeries(false);
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)lineseries);
        return lineseries;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE, THREE_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return true;
    }

    public boolean supportsTransposition(String dimension) {
        if (ChartUIUtil.getDimensionType((String)dimension) == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return false;
        }
        return this.supportsTransposition();
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("LineChart.Txt.DisplayName");
    }

    public Series getSeries() {
        return this.getSeries(true);
    }

    public Series getSeries(boolean needInitializing) {
        if (needInitializing) {
            LineSeries series = (LineSeries)LineSeriesImpl.create();
            ((Marker)series.getMarkers().get(0)).setVisible(true);
            series.setPaletteLineColor(true);
            return series;
        }
        LineSeries series = (LineSeries)LineSeriesImpl.createDefault();
        return series;
    }

    public boolean canCombine() {
        return true;
    }

    protected boolean isStackedSupported() {
        return true;
    }

    protected boolean isPercentStackedSupported() {
        return true;
    }

    public boolean canExpand() {
        return true;
    }
}

