/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FractionNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerLineImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerRangeImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.TextDataElement;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LabelAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.TriggerEditorDialog;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataElementComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class AxisMarkersSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    protected Composite cmpContent;
    private Composite cmpList = null;
    private Button btnAddLine = null;
    private Button btnAddRange = null;
    private Button btnRemove = null;
    private List lstMarkers = null;
    private Group grpGeneral = null;
    private StackLayout slMarkers = null;
    private Composite cmpLine = null;
    private Group grpMarkerLine = null;
    private Label lblValue = null;
    private IDataElementComposite txtValue = null;
    private Button btnLineFormatSpecifier = null;
    private Label lblAnchor = null;
    private ChartCombo cmbLineAnchor = null;
    private LineAttributesComposite liacMarkerLine = null;
    private Composite cmpRange = null;
    private Group grpMarkerRange = null;
    private Label lblStartValue = null;
    private IDataElementComposite txtStartValue = null;
    private Button btnStartFormatSpecifier = null;
    private Label lblEndValue = null;
    private IDataElementComposite txtEndValue = null;
    private Button btnEndFormatSpecifier = null;
    private Label lblRangeAnchor = null;
    private ChartCombo cmbRangeAnchor = null;
    private Label lblRangeFill = null;
    private FillChooserComposite fccRange = null;
    private LineAttributesComposite liacMarkerRange = null;
    private LabelAttributesComposite lacLabel = null;
    private Button btnLineTriggers;
    private Button btnRangeTriggers;
    private int iLineCount = 0;
    private int iRangeCount = 0;
    private Axis axis;
    private ChartWizardContext context;
    private String MARKER_LINE_LABEL = Messages.getString("AxisMarkersSheet.MarkerLine.displayName");
    private String MARKER_RANGE_LABEL = Messages.getString("AxisMarkersSheet.MarkerRange.displayName");
    private Axis defAxis;

    public AxisMarkersSheet(String title, ChartWizardContext context, Axis axis, Axis defAxis) {
        super(title, context, true);
        this.axis = axis;
        this.context = context;
        this.defAxis = defAxis;
    }

    protected void bindHelp(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Markers_ID");
    }

    protected Composite getComponent(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        GridLayout glList = new GridLayout();
        glList.numColumns = 3;
        glList.horizontalSpacing = 5;
        glList.verticalSpacing = 5;
        glList.marginHeight = 0;
        glList.marginWidth = 0;
        this.cmpList = new Composite(this.cmpContent, 0);
        GridData gdCMPList = new GridData(1808);
        gdCMPList.horizontalSpan = 2;
        this.cmpList.setLayoutData((Object)gdCMPList);
        this.cmpList.setLayout((Layout)glList);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 3;
        glButtons.horizontalSpacing = 5;
        glButtons.verticalSpacing = 5;
        glButtons.marginHeight = 5;
        glButtons.marginWidth = 0;
        Composite cmpButtons = new Composite(this.cmpList, 0);
        GridData gdCMPButtons = new GridData(768);
        gdCMPButtons.horizontalSpan = 3;
        cmpButtons.setLayoutData((Object)gdCMPButtons);
        cmpButtons.setLayout((Layout)glButtons);
        this.btnAddLine = new Button(cmpButtons, 8);
        GridData gdBTNAddLine = new GridData(768);
        this.btnAddLine.setLayoutData((Object)gdBTNAddLine);
        this.btnAddLine.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.AddLine"));
        this.btnAddLine.addSelectionListener((SelectionListener)this);
        this.btnAddRange = new Button(cmpButtons, 8);
        GridData gdBTNAddRange = new GridData(768);
        this.btnAddRange.setLayoutData((Object)gdBTNAddRange);
        this.btnAddRange.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.AddRange"));
        this.btnAddRange.addSelectionListener((SelectionListener)this);
        this.btnRemove = new Button(cmpButtons, 8);
        GridData gdBTNRemove = new GridData(768);
        this.btnRemove.setLayoutData((Object)gdBTNRemove);
        this.btnRemove.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.RemoveEntry"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.lstMarkers = new List(this.cmpList, 2564);
        GridData gdLSTMarkers = new GridData(768);
        gdLSTMarkers.horizontalSpan = 3;
        gdLSTMarkers.heightHint = 100;
        this.lstMarkers.setLayoutData((Object)gdLSTMarkers);
        this.lstMarkers.addSelectionListener((SelectionListener)this);
        this.slMarkers = new StackLayout();
        this.slMarkers.marginHeight = 0;
        this.slMarkers.marginWidth = 0;
        this.grpGeneral = new Group(this.cmpContent, 0);
        GridData gdCMPGeneral = new GridData(770);
        this.grpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.grpGeneral.setLayout((Layout)this.slMarkers);
        this.grpGeneral.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerProperties"));
        GridLayout glMarkerLine = new GridLayout();
        glMarkerLine.numColumns = 3;
        glMarkerLine.horizontalSpacing = 5;
        glMarkerLine.verticalSpacing = 5;
        glMarkerLine.marginHeight = 7;
        glMarkerLine.marginWidth = 7;
        this.cmpLine = new Composite((Composite)this.grpGeneral, 0);
        GridData gdGRPLine = new GridData(768);
        this.cmpLine.setLayoutData((Object)gdGRPLine);
        this.cmpLine.setLayout((Layout)glMarkerLine);
        this.lblValue = new Label(this.cmpLine, 0);
        GridData gdLBLValue = new GridData();
        gdLBLValue.horizontalIndent = 5;
        this.lblValue.setLayoutData((Object)gdLBLValue);
        this.lblValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Value"));
        this.txtValue = this.createValuePicker(this.cmpLine, null, "value");
        this.btnLineFormatSpecifier = new Button(this.cmpLine, 8);
        GridData gdBTNLineFormatSpecifier = new GridData();
        this.btnLineFormatSpecifier.setLayoutData((Object)gdBTNLineFormatSpecifier);
        this.btnLineFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnLineFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnLineFormatSpecifier.setText(Messages.getString("Format.Button.Lbl&"));
        this.lblAnchor = new Label(this.cmpLine, 0);
        GridData gdLBLAnchor = new GridData();
        gdLBLAnchor.horizontalIndent = 5;
        this.lblAnchor.setLayoutData((Object)gdLBLAnchor);
        this.lblAnchor.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Anchor"));
        this.cmbLineAnchor = this.getContext().getUIFactory().createChartCombo(this.cmpLine, 12, null, "labelAnchor", ChartUIUtil.getFlippedAnchor((Anchor)((MarkerLine)this.defAxis.getMarkerLines().get(0)).getLabelAnchor(), (boolean)this.isFlippedAxes()).getName());
        GridData gdCMBAnchor = new GridData(768);
        gdCMBAnchor.horizontalSpan = 2;
        this.cmbLineAnchor.setLayoutData((Object)gdCMBAnchor);
        this.cmbLineAnchor.addSelectionListener((SelectionListener)this);
        this.cmbLineAnchor.getWidget().setVisibleItemCount(30);
        this.grpMarkerLine = new Group(this.cmpLine, 0);
        GridData gdGRPMarkerLine = new GridData(768);
        gdGRPMarkerLine.horizontalSpan = 3;
        this.grpMarkerLine.setLayoutData((Object)gdGRPMarkerLine);
        this.grpMarkerLine.setLayout((Layout)new FillLayout());
        this.grpMarkerLine.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerLineAttributes"));
        int lineStyles = 15;
        this.liacMarkerLine = new LineAttributesComposite((Composite)this.grpMarkerLine, 0, lineStyles |= this.context.getUIFactory().supportAutoUI() ? 16 : lineStyles, this.getContext(), null, ((MarkerLine)this.defAxis.getMarkerLines().get(0)).getLineAttributes());
        this.liacMarkerLine.addListener(this);
        this.btnLineTriggers = new Button(this.cmpLine, 8);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.btnLineTriggers.setLayoutData((Object)gd);
        this.btnLineTriggers.setText(Messages.getString("AxisMarkersSheet.Label.Interactivity"));
        this.btnLineTriggers.addSelectionListener((SelectionListener)this);
        this.btnLineTriggers.setEnabled(this.getChart().getInteractivity().isEnable());
        GridLayout glMarkerRange = new GridLayout();
        glMarkerRange.numColumns = 3;
        glMarkerRange.horizontalSpacing = 5;
        glMarkerRange.verticalSpacing = 5;
        glMarkerRange.marginHeight = 7;
        glMarkerRange.marginWidth = 7;
        this.cmpRange = new Composite((Composite)this.grpGeneral, 0);
        GridData gdGRPRange = new GridData(768);
        this.cmpRange.setLayoutData((Object)gdGRPRange);
        this.cmpRange.setLayout((Layout)glMarkerRange);
        this.lblStartValue = new Label(this.cmpRange, 0);
        GridData gdLBLStartValue = new GridData();
        gdLBLStartValue.horizontalIndent = 5;
        this.lblStartValue.setLayoutData((Object)gdLBLStartValue);
        this.lblStartValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.StartValue"));
        this.txtStartValue = this.createValuePicker(this.cmpRange, null, "startValue");
        this.btnStartFormatSpecifier = new Button(this.cmpRange, 8);
        GridData gdBTNStartFormatSpecifier = new GridData();
        gdBTNStartFormatSpecifier.heightHint = 18;
        this.btnStartFormatSpecifier.setLayoutData((Object)gdBTNStartFormatSpecifier);
        this.btnStartFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnStartFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnStartFormatSpecifier.setText(Messages.getString("Format.Button.Lbl&"));
        this.lblEndValue = new Label(this.cmpRange, 0);
        GridData gdLBLEndValue = new GridData();
        gdLBLEndValue.horizontalIndent = 5;
        this.lblEndValue.setLayoutData((Object)gdLBLEndValue);
        this.lblEndValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.EndValue"));
        this.txtEndValue = this.createValuePicker(this.cmpRange, null, "endValue");
        this.btnEndFormatSpecifier = new Button(this.cmpRange, 8);
        GridData gdBTNEndFormatSpecifier = new GridData();
        gdBTNEndFormatSpecifier.heightHint = 18;
        this.btnEndFormatSpecifier.setLayoutData((Object)gdBTNEndFormatSpecifier);
        this.btnEndFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnEndFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnEndFormatSpecifier.setText(Messages.getString("Format.Button.Label"));
        this.lblRangeAnchor = new Label(this.cmpRange, 0);
        GridData gdLBLRangeAnchor = new GridData();
        gdLBLRangeAnchor.horizontalIndent = 5;
        this.lblRangeAnchor.setLayoutData((Object)gdLBLRangeAnchor);
        this.lblRangeAnchor.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Anchor"));
        this.cmbRangeAnchor = this.getContext().getUIFactory().createChartCombo(this.cmpRange, 12, null, "labelAnchor", ChartUIUtil.getFlippedAnchor((Anchor)((MarkerLine)this.defAxis.getMarkerLines().get(0)).getLabelAnchor(), (boolean)this.isFlippedAxes()).getName());
        GridData gdCMBRangeAnchor = new GridData(768);
        gdCMBRangeAnchor.horizontalSpan = 2;
        this.cmbRangeAnchor.setLayoutData((Object)gdCMBRangeAnchor);
        this.cmbRangeAnchor.addSelectionListener((SelectionListener)this);
        this.cmbRangeAnchor.getWidget().setVisibleItemCount(30);
        this.lblRangeFill = new Label(this.cmpRange, 0);
        GridData gdLBLRangeFill = new GridData();
        gdLBLRangeFill.horizontalIndent = 5;
        this.lblRangeFill.setLayoutData((Object)gdLBLRangeFill);
        this.lblRangeFill.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Fill"));
        int fillStyles = 27;
        this.fccRange = new FillChooserComposite(this.cmpRange, 0, fillStyles |= this.getContext().getUIFactory().supportAutoUI() ? 4 : fillStyles, this.getContext(), null);
        GridData gdFCCRange = new GridData(768);
        gdFCCRange.horizontalSpan = 2;
        this.fccRange.setLayoutData(gdFCCRange);
        this.fccRange.addListener(this);
        this.grpMarkerRange = new Group(this.cmpRange, 0);
        GridData gdGRPMarkerRange = new GridData(768);
        gdGRPMarkerRange.horizontalSpan = 3;
        this.grpMarkerRange.setLayoutData((Object)gdGRPMarkerRange);
        this.grpMarkerRange.setLayout((Layout)new FillLayout());
        this.grpMarkerRange.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.RangeOutline"));
        this.liacMarkerRange = new LineAttributesComposite((Composite)this.grpMarkerRange, 0, lineStyles, this.getContext(), null, ((MarkerRange)this.defAxis.getMarkerRanges().get(0)).getOutline());
        this.liacMarkerRange.addListener(this);
        this.btnRangeTriggers = new Button(this.cmpRange, 8);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 2;
        this.btnRangeTriggers.setLayoutData((Object)gd2);
        this.btnRangeTriggers.setText(Messages.getString("AxisMarkersSheet.Label.Interactivity"));
        this.btnRangeTriggers.addSelectionListener((SelectionListener)this);
        this.btnRangeTriggers.setEnabled(this.getChart().getInteractivity().isEnable());
        this.lacLabel = new LabelAttributesComposite(this.cmpContent, 0, this.getContext(), this.getLabelAttributesContext(), Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerLabelProperties"), null, null, "label", (EObject)this.defAxis.getMarkerLines().get(0), this.getChart().getUnits());
        GridData gdLACLabel = new GridData(770);
        this.lacLabel.setLayoutData(gdLACLabel);
        this.lacLabel.addListener(this);
        this.lacLabel.setDefaultLabelValue(DefaultValueProvider.defLabel());
        this.slMarkers.topControl = this.cmpLine;
        this.populateLists();
        this.refreshButtons();
        return this.cmpContent;
    }

    protected LabelAttributesComposite.LabelAttributesContext getLabelAttributesContext() {
        LabelAttributesComposite.LabelAttributesContext attributesContext = new LabelAttributesComposite.LabelAttributesContext();
        attributesContext.isPositionEnabled = false;
        attributesContext.isFontAlignmentEnabled = false;
        attributesContext.isLabelEnabled = true;
        return attributesContext;
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.lacLabel)) {
            if (this.lstMarkers.getSelection().length != 0) {
                switch (event.type) {
                    case 1: {
                        ChartElementUtil.setEObjectAttribute((EObject)this.getSelectedMarkerLabel(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                        break;
                    }
                    case 3: {
                        this.getSelectedMarkerLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
                        this.getSelectedMarkerLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
                        break;
                    }
                    case 4: {
                        this.getSelectedMarkerLabel().setBackground((Fill)event.data);
                        break;
                    }
                    case 5: {
                        this.getSelectedMarkerLabel().setShadowColor((ColorDefinition)event.data);
                        break;
                    }
                    case 6: {
                        ChartElementUtil.setEObjectAttribute((EObject)this.getSelectedMarkerLabel().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                        break;
                    }
                    case 7: {
                        ChartElementUtil.setEObjectAttribute((EObject)this.getSelectedMarkerLabel().getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                        break;
                    }
                    case 8: {
                        this.getSelectedMarkerLabel().getOutline().setColor((ColorDefinition)event.data);
                        break;
                    }
                    case 9: {
                        ChartElementUtil.setEObjectAttribute((EObject)this.getSelectedMarkerLabel().getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                        break;
                    }
                    case 10: {
                        this.getSelectedMarkerLabel().setInsets((Insets)event.data);
                        break;
                    }
                    case 11: {
                        this.getSelectedMarkerLabel().getCaption().setValue((String)event.data);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (event.widget.equals((Object)this.fccRange)) {
            ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).setFill((Fill)event.data);
        } else if (event.widget.equals(this.txtValue)) {
            MarkerLine line = (MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex());
            if (event.type == 0) {
                line.setValue(this.getNotNullDataElement(this.txtValue.getDataElement()));
            } else if (event.type == 1 && !(line.getFormatSpecifier() instanceof FractionNumberFormatSpecifier)) {
                line.setFormatSpecifier((FormatSpecifier)this.createDefaultFractionFormatSpecifier());
            }
        } else if (event.widget.equals(this.txtStartValue)) {
            MarkerRange range = (MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex());
            if (event.type == 0) {
                range.setStartValue(this.getNotNullDataElement(this.txtStartValue.getDataElement()));
            } else if (event.type == 1 && !(range.getFormatSpecifier() instanceof FractionNumberFormatSpecifier)) {
                range.setFormatSpecifier((FormatSpecifier)this.createDefaultFractionFormatSpecifier());
            }
        } else if (event.widget.equals(this.txtEndValue)) {
            MarkerRange range = (MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex());
            if (event.type == 0) {
                range.setEndValue(this.getNotNullDataElement(this.txtEndValue.getDataElement()));
            } else if (event.type == 1 && !(range.getFormatSpecifier() instanceof FractionNumberFormatSpecifier)) {
                range.setFormatSpecifier((FormatSpecifier)this.createDefaultFractionFormatSpecifier());
            }
        } else if (event.widget.equals((Object)this.liacMarkerLine)) {
            if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes().setColor((ColorDefinition)event.data);
            } else {
                ChartElementUtil.setEObjectAttribute((EObject)((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
            }
        } else if (event.widget.equals((Object)this.liacMarkerRange)) {
            if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline().setColor((ColorDefinition)event.data);
            } else {
                ChartElementUtil.setEObjectAttribute((EObject)((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnAddLine)) {
            MarkerLine line = AxisMarkersSheet.createMarkerLine(this.getAxisForProcessing(), this.createDefaultDataElement(), this.getContext());
            line.eAdapters().addAll((Collection)this.getAxisForProcessing().eAdapters());
            ++this.iLineCount;
            this.buildList();
            this.lstMarkers.select(this.lstMarkers.getItemCount() - 1);
            this.updateUIForSelection();
            if (this.lstMarkers.getItemCount() >= 1) {
                this.setState(true);
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.btnAddRange)) {
            MarkerRange range = this.createMarkerRange(this.getAxisForProcessing(), this.createDefaultDataElement(), this.createDefaultDataElement(), this.getContext());
            range.eAdapters().addAll((Collection)this.getAxisForProcessing().eAdapters());
            ++this.iRangeCount;
            this.buildList();
            this.lstMarkers.select(this.lstMarkers.getItemCount() - 1);
            this.updateUIForSelection();
            if (this.lstMarkers.getItemCount() >= 1) {
                this.setState(true);
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.btnRemove)) {
            if (this.lstMarkers.getSelection().length == 0) {
                return;
            }
            String sSelectedMarker = this.lstMarkers.getSelection()[0];
            boolean bLine = sSelectedMarker.startsWith(this.MARKER_LINE_LABEL);
            int iMarkerIndex = this.getMarkerIndex();
            if (bLine) {
                this.getAxisForProcessing().getMarkerLines().remove(iMarkerIndex);
                --this.iLineCount;
            } else {
                this.getAxisForProcessing().getMarkerRanges().remove(iMarkerIndex);
                --this.iRangeCount;
            }
            this.buildList();
            if (this.lstMarkers.getItemCount() > 0) {
                this.lstMarkers.select(0);
                this.updateUIForSelection();
                this.setState(true);
            } else {
                this.setState(false);
                this.resetUI();
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.lstMarkers)) {
            this.updateUIForSelection();
            this.setState(true);
            this.refreshButtons();
        } else if (e.getSource().equals(this.cmbLineAnchor)) {
            String selectedAnchor = this.cmbLineAnchor.getSelectedItemData();
            if (selectedAnchor != null) {
                ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).setLabelAnchor(ChartUIUtil.getFlippedAnchor((Anchor)Anchor.getByName((String)selectedAnchor), (boolean)this.isFlippedAxes()));
            }
        } else if (e.getSource().equals(this.cmbRangeAnchor)) {
            String selectedAnchor = this.cmbRangeAnchor.getSelectedItemData();
            if (selectedAnchor != null) {
                ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).setLabelAnchor(ChartUIUtil.getFlippedAnchor((Anchor)Anchor.getByName((String)selectedAnchor), (boolean)this.isFlippedAxes()));
            }
        } else if (e.getSource().equals(this.btnLineFormatSpecifier)) {
            this.handleMarkerLineFormatBtnSelected();
        } else if (e.getSource().equals(this.btnStartFormatSpecifier) || e.getSource().equals(this.btnEndFormatSpecifier)) {
            this.handleMarkerRangeFormatBtnSelected();
        } else if (e.widget.equals(this.btnLineTriggers)) {
            new TriggerEditorDialog(this.cmpContent.getShell(), (EList<Trigger>)((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getTriggers(), (EObject)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex()), this.getContext(), Messages.getString("AxisMarkersSheet.Title.MarkerLine"), 32, 16).open();
        } else if (e.widget.equals(this.btnRangeTriggers)) {
            new TriggerEditorDialog(this.cmpContent.getShell(), (EList<Trigger>)((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getTriggers(), (EObject)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex()), this.getContext(), Messages.getString("AxisMarkersSheet.Title.MarkerRange"), 64, 16).open();
        }
    }

    protected void handleMarkerRangeFormatBtnSelected() {
        String sAxisTitle = "";
        try {
            String sTitleString = this.getAxisForProcessing().getTitle().getCaption().getValue();
            int iSeparatorIndex = sTitleString.indexOf("=");
            if (iSeparatorIndex > 0) {
                sTitleString = sTitleString.substring(iSeparatorIndex);
            } else if (iSeparatorIndex == 0) {
                sTitleString = sTitleString.substring("=".length());
            }
            sAxisTitle = new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.ForAxis")).format(new Object[]{sTitleString});
        }
        catch (NullPointerException nullPointerException) {}
        FormatSpecifier formatspecifier = null;
        if (((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getFormatSpecifier() != null) {
            formatspecifier = ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getFormatSpecifier();
        }
        this.getContext().getUIServiceProvider().getFormatSpecifierHandler().handleFormatSpecifier(this.cmpContent.getShell(), new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerRange")).format(new Object[]{this.getMarkerIndex() + 1, sAxisTitle}), new AxisType[]{this.getDataElementType(((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getStartValue())}, formatspecifier, (EObject)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex()), "formatSpecifier", this.getContext());
    }

    protected void handleMarkerLineFormatBtnSelected() {
        String sAxisTitle = "";
        try {
            sAxisTitle = new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.ForAxis")).format(new Object[]{this.getAxisForProcessing().getTitle().getCaption().getValue()});
        }
        catch (NullPointerException nullPointerException) {}
        FormatSpecifier formatspecifier = null;
        if (((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getFormatSpecifier() != null) {
            formatspecifier = ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getFormatSpecifier();
        }
        this.getContext().getUIServiceProvider().getFormatSpecifierHandler().handleFormatSpecifier(this.cmpContent.getShell(), new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerLine")).format(new Object[]{this.getMarkerIndex() + 1, sAxisTitle}), new AxisType[]{this.getDataElementType(((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getValue())}, formatspecifier, (EObject)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex()), "formatSpecifier", this.getContext());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected Axis getAxisForProcessing() {
        return this.axis;
    }

    protected int getMarkerIndex() {
        String sSelectedMarker = this.lstMarkers.getSelection()[0];
        int iSelectionIndex = this.lstMarkers.getSelectionIndex();
        if (sSelectedMarker.startsWith(this.MARKER_LINE_LABEL)) {
            return iSelectionIndex;
        }
        return iSelectionIndex - this.getAxisForProcessing().getMarkerLines().size();
    }

    private void buildList() {
        this.lstMarkers.removeAll();
        this.iLineCount = this.getAxisForProcessing().getMarkerLines().size();
        this.iRangeCount = this.getAxisForProcessing().getMarkerRanges().size();
        int iLines = 0;
        while (iLines < this.iLineCount) {
            this.lstMarkers.add(String.valueOf(this.MARKER_LINE_LABEL) + " - " + (iLines + 1));
            ++iLines;
        }
        int iRanges = 0;
        while (iRanges < this.iRangeCount) {
            this.lstMarkers.add(String.valueOf(this.MARKER_RANGE_LABEL) + " - " + (iRanges + 1));
            ++iRanges;
        }
    }

    private void refreshButtons() {
        this.btnRemove.setEnabled(this.lstMarkers.getSelectionIndex() != -1);
    }

    private void updateUIForSelection() {
        String sSelectedMarker = this.lstMarkers.getSelection()[0];
        if (sSelectedMarker.startsWith(this.MARKER_LINE_LABEL)) {
            this.slMarkers.topControl = this.cmpLine;
            this.grpGeneral.layout();
            MarkerLine line = (MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex());
            this.txtValue.setEObjectParent((EObject)line);
            this.txtValue.setDataElement(line.getValue());
            this.cmbLineAnchor.setEObjectParent((EObject)line);
            this.cmbLineAnchor.setSelection(ChartUIUtil.getFlippedAnchor((Anchor)line.getLabelAnchor(), (boolean)this.isFlippedAxes()).getName());
            this.liacMarkerLine.setLineAttributes(line.getLineAttributes());
            this.lacLabel.setLabel(line.getLabel(), this.getChart().getUnits(), (EObject)line);
        } else {
            this.slMarkers.topControl = this.cmpRange;
            this.grpGeneral.layout();
            MarkerRange range = (MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex());
            this.txtStartValue.setEObjectParent((EObject)range);
            this.txtStartValue.setDataElement(range.getStartValue());
            this.txtEndValue.setEObjectParent((EObject)range);
            this.txtEndValue.setDataElement(range.getEndValue());
            this.cmbRangeAnchor.setEObjectParent((EObject)range);
            this.cmbRangeAnchor.setSelection(ChartUIUtil.getFlippedAnchor((Anchor)range.getLabelAnchor(), (boolean)this.isFlippedAxes()).getName());
            this.fccRange.setFill(range.getFill());
            this.liacMarkerRange.setLineAttributes(range.getOutline());
        }
    }

    private void populateLists() {
        this.buildList();
        NameSet ns = LiteralHelper.anchorSet;
        this.cmbLineAnchor.setItems(ns.getDisplayNames());
        this.cmbLineAnchor.setItemData(ns.getNames());
        this.cmbLineAnchor.select(0);
        this.cmbRangeAnchor.setItems(ns.getDisplayNames());
        this.cmbRangeAnchor.setItemData(ns.getNames());
        this.cmbRangeAnchor.select(0);
        if (this.lstMarkers.getItemCount() > 0) {
            this.lstMarkers.select(0);
            this.updateUIForSelection();
            this.setState(true);
        } else {
            this.setState(false);
        }
    }

    private void setState(boolean bState) {
        this.btnLineFormatSpecifier.setEnabled(bState);
        this.lblAnchor.setEnabled(bState);
        this.cmbLineAnchor.setEnabled(bState);
        this.lblValue.setEnabled(bState);
        this.txtValue.setEnabled(bState);
        this.liacMarkerLine.setAttributesEnabled(bState);
        this.btnLineTriggers.setEnabled(bState && this.getChart().getInteractivity().isEnable());
        this.btnStartFormatSpecifier.setEnabled(bState);
        this.btnEndFormatSpecifier.setEnabled(bState);
        this.lblRangeAnchor.setEnabled(bState);
        this.cmbRangeAnchor.setEnabled(bState);
        this.lblStartValue.setEnabled(bState);
        this.txtStartValue.setEnabled(bState);
        this.lblEndValue.setEnabled(bState);
        this.txtEndValue.setEnabled(bState);
        this.liacMarkerRange.setAttributesEnabled(bState);
        this.lacLabel.setEnabled(bState);
        this.lblRangeFill.setEnabled(bState);
        this.fccRange.setEnabled(bState);
        this.btnRangeTriggers.setEnabled(bState && this.getChart().getInteractivity().isEnable());
        this.grpGeneral.setEnabled(bState);
        this.grpMarkerLine.setEnabled(bState);
        this.grpMarkerRange.setEnabled(bState);
    }

    private void resetUI() {
        this.cmbLineAnchor.select(0);
        this.cmbRangeAnchor.select(0);
        this.slMarkers.topControl = this.cmpLine;
        this.txtValue.setDataElement(null);
        this.liacMarkerLine.setLineAttributes(null);
        this.liacMarkerLine.layout();
        this.txtStartValue.setDataElement(null);
        this.txtEndValue.setDataElement(null);
        this.fccRange.setFill(null);
        this.liacMarkerRange.setLineAttributes(null);
        this.liacMarkerRange.layout();
        this.lacLabel.setLabel(LabelImpl.create(), this.getChart().getUnits(), null);
        this.lacLabel.layout();
    }

    private org.eclipse.birt.chart.model.component.Label getSelectedMarkerLabel() {
        String sSelectedMarker = this.lstMarkers.getSelection()[0];
        int iMarkerIndex = this.getMarkerIndex();
        if (sSelectedMarker.startsWith(this.MARKER_LINE_LABEL)) {
            return ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(iMarkerIndex)).getLabel();
        }
        return ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(iMarkerIndex)).getLabel();
    }

    private DataElement createDefaultDataElement() {
        Axis axis = this.getAxisForProcessing();
        if (axis.isSetType()) {
            if (axis.getType().equals((Object)AxisType.DATE_TIME_LITERAL) && !axis.isCategoryAxis()) {
                Calendar c = Calendar.getInstance();
                c.set(1970, 0, 1, 0, 0, 0);
                return DateTimeDataElementImpl.create((Calendar)c);
            }
            return NumberDataElementImpl.create((double)0.0);
        }
        return null;
    }

    protected AxisType getDataElementType(DataElement de) {
        if (de instanceof TextDataElement) {
            return AxisType.TEXT_LITERAL;
        }
        if (de instanceof DateTimeDataElement) {
            return AxisType.DATE_TIME_LITERAL;
        }
        return AxisType.LINEAR_LITERAL;
    }

    private boolean isFlippedAxes() {
        return ((ChartWithAxes)this.context.getModel()).getOrientation().equals((Object)Orientation.HORIZONTAL_LITERAL);
    }

    private IDataElementComposite createValuePicker(Composite parent, DataElement data, String sProperty) {
        IDataElementComposite picker = null;
        Axis axis = this.getAxisForProcessing();
        if (axis.getType().getValue() == 3 && !axis.isCategoryAxis()) {
            try {
                picker = this.getContext().getUIFactory().createDateTimeDataElementComposite(parent, 2048, (DateTimeDataElement)data, true, null, sProperty);
            }
            catch (Exception exception) {
                picker = this.getContext().getUIFactory().createDateTimeDataElementComposite(parent, 2048, null, true, null, sProperty);
            }
        } else {
            try {
                picker = this.getContext().getUIFactory().createNumberDataElementComposite(parent, data, null, sProperty);
            }
            catch (Exception exception) {
                picker = this.getContext().getUIFactory().createNumberDataElementComposite(parent, null, null, sProperty);
            }
        }
        if (picker != null) {
            GridData gd = new GridData(768);
            picker.setLayoutData((Object)gd);
            picker.addListener((Listener)this);
        }
        return picker;
    }

    private DataElement getNotNullDataElement(DataElement de) {
        return de;
    }

    private FractionNumberFormatSpecifier createDefaultFractionFormatSpecifier() {
        FractionNumberFormatSpecifier ffs = FractionNumberFormatSpecifierImpl.create();
        ffs.setPrecise(false);
        return ffs;
    }

    private static MarkerLine createMarkerLine(Axis ax, DataElement de, ChartWizardContext context) {
        if (context.getUIFactory().supportAutoUI()) {
            return MarkerLineImpl.createDefault((Axis)ax, (DataElement)de, null);
        }
        return MarkerLineImpl.create((Axis)ax, (DataElement)de, (ColorDefinition)ColorDefinitionImpl.RED());
    }

    private MarkerRange createMarkerRange(Axis ax, DataElement deStart, DataElement deEnd, ChartWizardContext context) {
        if (context.getUIFactory().supportAutoUI()) {
            return MarkerRangeImpl.createDefault((Axis)ax, (DataElement)deStart, (DataElement)deEnd, null, null);
        }
        return MarkerRangeImpl.create((Axis)this.getAxisForProcessing(), (DataElement)deStart, (DataElement)deEnd, (Fill)ColorDefinitionImpl.TRANSPARENT(), (ColorDefinition)ColorDefinitionImpl.RED());
    }
}

