/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.NeedleComposite;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NeedleSheetImpl
extends SubtaskSheetImpl
implements SelectionListener {
    public void createControl(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, true);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        NeedleComposite cmpNeedle = new NeedleComposite(this.cmpContent, this.getContext(), (DialSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries());
        cmpNeedle.setLayoutData(new GridData(1808));
        this.createButtonGroup(this.cmpContent);
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        if (this.getContext().isInteractivityEnabled()) {
            InteractivitySheet popup = new InteractivitySheet(Messages.getString("SeriesYSheetImpl.Label.Interactivity"), this.getContext(), (EList<Trigger>)this.getSeriesDefinitionForProcessing().getDesignTimeSeries().getTriggers(), (EObject)this.getSeriesDefinitionForProcessing().getDesignTimeSeries(), 1, 1);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup);
            btnInteractivity.addSelectionListener((SelectionListener)this);
            btnInteractivity.setEnabled(this.getChart().getInteractivity().isEnable());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.getChart() instanceof ChartWithAxes) {
            int iAxis = this.getParentAxisIndex(this.getIndex());
            int iAxisSeries = this.getSeriesIndexWithinAxis(this.getIndex());
            sd = (SeriesDefinition)((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(iAxis)).getSeriesDefinitions().get(iAxisSeries);
        } else if (this.getChart() instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.getChart()).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(this.getIndex());
        }
        return sd;
    }

    private int getParentAxisIndex(int iSeriesDefinitionIndex) {
        int iTmp = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        int i = 0;
        while (i < iAxisCount) {
            if ((iTmp += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 >= iSeriesDefinitionIndex) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getSeriesIndexWithinAxis(int iSeriesDefinitionIndex) {
        int iTotalDefinitions = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        int i = 0;
        while (i < iAxisCount) {
            int iOldTotal = iTotalDefinitions;
            if ((iTotalDefinitions += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 >= iSeriesDefinitionIndex) {
                return iSeriesDefinitionIndex - iOldTotal;
            }
            ++i;
        }
        return iSeriesDefinitionIndex;
    }
}

