SELECT
  l.locktype, a.datname, c.relname, l.transactionid, l.pid,
  a.usename, a.current_query, a.query_start,
  age(current_timestamp, a.query_start), l.mode, l.granted
FROM pg_locks AS l
JOIN pg_stat_activity AS a ON (l.pid = a.procpid)
LEFT OUTER JOIN pg_class AS c ON (l.relation = c.oid)
WHERE pid != pg_backend_pid() ORDER BY a.query_start; 