/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ISortingFormProvider;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.GroupHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractSortingFormHandleProvider
extends AbstractDescriptorProvider
implements ISortingFormProvider {
    protected static Logger logger = Logger.getLogger(AbstractSortingFormHandleProvider.class.getName());
    protected Object input;

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) == 1;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean edit(int pos) {
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        if (!this.doEditItem(pos)) {
            stack.rollback();
            return false;
        }
        stack.commit();
        return true;
    }

    public void add(int pos) throws Exception {
        boolean sucess = false;
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        try {
            sucess = this.doAddItem(pos);
        }
        catch (Exception e) {
            stack.rollback();
            throw new Exception(e);
        }
        if (sucess) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    protected CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public FormContentProvider getFormContentProvider(IModelEventProcessor listener, IDescriptorProvider provider) {
        return new FormContentProvider(listener, provider);
    }

    public Object load() {
        return null;
    }

    public void save(Object value) throws SemanticException {
    }

    public boolean isAddEnable() {
        return true;
    }

    public boolean isEditEnable() {
        return true;
    }

    public boolean isDeleteEnable() {
        return true;
    }

    public boolean needRebuilded(NotificationEvent event) {
        return false;
    }

    public class FormContentProvider
    implements IStructuredContentProvider {
        private IModelEventProcessor listener;
        private IDescriptorProvider provider;

        public FormContentProvider(IModelEventProcessor listener, IDescriptorProvider provider) {
            this.listener = listener;
            this.provider = provider;
        }

        public Object[] getElements(Object inputElement) {
            assert (this.provider instanceof AbstractSortingFormHandleProvider);
            Object[] elements = ((AbstractSortingFormHandleProvider)this.provider).getElements(inputElement);
            this.registerEventManager();
            this.deRegisterEventManager();
            return elements;
        }

        public void dispose() {
            if (!((ISortingFormProvider)this.provider instanceof GroupHandleProvider)) {
                return;
            }
            Object[] elements = ((ISortingFormProvider)this.provider).getElements(AbstractSortingFormHandleProvider.this.input);
            if (elements == null) {
                return;
            }
            this.deRegisterEventManager();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        protected void deRegisterEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().removeModelEventProcessor(this.listener);
            }
        }

        protected void registerEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().addModelEventProcessor(this.listener);
            }
        }
    }
}

