/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TextPropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TextAndButtonDescriptor
extends PropertyDescriptor {
    private int buttonWidth = 60;
    private List selectList = new ArrayList();
    private String textText;
    private String buttonText;
    private TextPropertyDescriptor text;
    private Button button;
    IDescriptorProvider provider;

    public TextAndButtonDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        Composite composite = FormWidgetFactory.getInstance().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.text = DescriptorToolkit.createTextPropertyDescriptor(this.isFormStyle());
        if (this.provider != null) {
            this.text.setDescriptorProvider(this.provider);
        }
        this.text.createControl(composite);
        if (this.textText != null) {
            this.text.setText(this.textText);
        }
        WidgetUtil.setGridData(this.text.getControl(), 1, true);
        this.button = FormWidgetFactory.getInstance().createButton(composite, 8, this.isFormStyle());
        if (this.buttonText != null) {
            this.button.setText(this.buttonText);
        }
        if (!this.selectList.isEmpty()) {
            this.button.addSelectionListener((SelectionListener)this.selectList.get(0));
        } else {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextAndButtonDescriptor.this.onClickButton();
                }
            };
            this.selectList.add(listener);
        }
        GridData data = new GridData();
        data.widthHint = Math.max(this.button.computeSize((int)-1, (int)-1).x, this.buttonWidth);
        data.grabExcessHorizontalSpace = false;
        this.button.setLayoutData((Object)data);
        this.descriptorContainer.add(this.text);
        return composite;
    }

    protected void onClickButton() {
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.selectList.contains(listener)) {
            if (!this.selectList.isEmpty()) {
                this.removeSelectionListener((SelectionListener)this.selectList.get(0));
            }
            this.selectList.add(listener);
            if (this.button != null) {
                this.button.addSelectionListener(listener);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectList.contains(listener)) {
            this.selectList.remove(listener);
            if (this.button != null) {
                this.button.removeSelectionListener(listener);
            }
        }
    }

    public void forceFocus() {
        this.text.getControl().forceFocus();
    }

    public void setInput(Object input) {
        this.text.setInput(input);
    }

    public Object getInput() {
        return this.text.getInput();
    }

    public void load() {
        this.text.load();
    }

    public void setText(String aText) {
        if (this.text.getControl() != null) {
            this.text.setText(aText);
        }
        this.textText = aText;
    }

    public void setButtonText(String aText) {
        if (this.button != null) {
            this.button.setText(aText);
        }
        this.buttonText = aText;
    }

    public void save(Object obj) throws SemanticException {
        this.text.save(obj);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        if (this.text != null) {
            this.text.setDescriptorProvider(provider);
        }
        this.provider = provider;
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth = buttonWidth;
        if (this.button != null) {
            GridData data = new GridData();
            data.widthHint = Math.max(this.button.computeSize((int)-1, (int)-1).x, buttonWidth);
            data.grabExcessHorizontalSpace = false;
            this.button.setLayoutData((Object)data);
        }
    }
}

