/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class BooleanFieldEditor
extends AbstractFieldEditor {
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    private int style;
    private Button checkBox = null;

    protected BooleanFieldEditor() {
    }

    public BooleanFieldEditor(String name, String labelText, int style, Composite parent) {
        this.init(name, labelText);
        this.style = style;
        this.createControl(parent);
    }

    public BooleanFieldEditor(String name, String label, Composite parent) {
        this(name, label, 0, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.style == 1) {
            --numColumns;
        }
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        String text = this.getLabelText();
        switch (this.style) {
            case 1: {
                this.getLabelControl(parent);
                --numColumns;
                text = null;
            }
        }
        this.checkBox = this.getChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.checkBox.setLayoutData((Object)gd);
        if (text != null) {
            this.checkBox.setText(text);
        }
    }

    protected void doLoad() {
        if (this.checkBox != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.checkBox.setSelection(Boolean.valueOf(value).booleanValue());
            this.setOldValue(value);
        }
        this.markDirty(false);
    }

    protected void doLoadDefault() {
        if (this.checkBox != null) {
            String value = Boolean.valueOf(this.getPreferenceStore().getDefaultBoolean(this.getPreferenceName())).toString();
            this.checkBox.setSelection(Boolean.getBoolean(value));
            this.setDefaultValue(value);
            if (this.getPreferenceStore() instanceof StylePreferenceStore) {
                StylePreferenceStore store = (StylePreferenceStore)this.getPreferenceStore();
                if (store.hasLocalValue(this.getPreferenceName())) {
                    this.markDirty(true);
                } else {
                    this.markDirty(false);
                }
            } else {
                this.markDirty(true);
            }
        }
    }

    protected void doStore() {
        if (this.isDirty()) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.getPropValue());
        }
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 16416);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Boolean value = BooleanFieldEditor.this.checkBox.getSelection();
                    BooleanFieldEditor.this.valueChanged(Boolean.valueOf(BooleanFieldEditor.this.getDisplayValue()), value);
                    BooleanFieldEditor.this.setPropValue(value.toString());
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BooleanFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    public int getNumberOfControls() {
        switch (this.style) {
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
            this.markDirty(true);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (this.style == 1) {
            super.setEnabled(enabled, parent);
        }
        this.getChangeControl(parent).setEnabled(enabled);
    }

    protected String getStringValue() {
        return null;
    }
}

