/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ReportGraphicsViewPainter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.AddImageResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.ImageCanvas;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ThumbnailBuilder
extends BaseDialog {
    private Listener currentListener;
    private static final int GENERATE_TYPE = 0;
    private static final int BROWSER_TYPE = 1;
    private static final int IMPORT_TYPE = 2;
    private static String DEFAULT_TEXT = Messages.getString((String)"ThumbnailBuilder.Text.Title");
    private static String BUTTON_TEXT_GENERATE = Messages.getString((String)"ThumbnailBuilder.Button.Text.Generate");
    private static String BUTTON_TEXT_REMOVE = Messages.getString((String)"ThumbnailBuilder.Button.Text.Remove");
    private static String BUTTON_TEXT_IMPORT = Messages.getString((String)"ThumbnailBuilder.Button.Text.Import");
    private ImageCanvas previewCanvas;
    private Button radioBtnGenerate;
    private Button radioBtnBrowse;
    private Button radioBtnImport;
    private Button btnImport;
    private Button btnRemove;
    private String imageName;
    private Image image;
    private boolean hasThumbnail;
    private static final String[] IMAGE_FILTER = new String[]{"*.gif;*.jpg;*.jpeg;*.png;*.ico;*.bmp"};
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".gif", ".png", ".ico"};
    private ReportDesignHandle handle;
    private Listener btnGenerateListener = new Listener(){

        public void handleEvent(Event event) {
            ThumbnailBuilder.this.removeImage();
            ReportGraphicsViewPainter painter = new ReportGraphicsViewPainter(ThumbnailBuilder.this.getModuleHandle());
            ThumbnailBuilder.this.previewCanvas.layout();
            Rectangle rect = ThumbnailBuilder.this.previewCanvas.getBounds();
            ThumbnailBuilder.this.image = new Image(null, rect.width, rect.height);
            painter.paint((Drawable)ThumbnailBuilder.this.image, (Device)ThumbnailBuilder.this.previewCanvas.getDisplay(), rect);
            painter.dispose();
            ThumbnailBuilder.this.previewCanvas.loadImage(ThumbnailBuilder.this.image);
            ThumbnailBuilder.this.btnRemove.setEnabled(true);
            ThumbnailBuilder.this.hasThumbnail = true;
            ThumbnailBuilder.this.imageName = Messages.getString((String)"ThumbnailBuilder.Image.DefaultName");
        }
    };
    private Listener btnRemoveListener = new Listener(){

        public void handleEvent(Event event) {
            ThumbnailBuilder.this.removeImage();
            ThumbnailBuilder.this.hasThumbnail = false;
            ThumbnailBuilder.this.imageName = "";
        }
    };
    private Listener btnBrowseListener = new Listener(){

        public void handleEvent(Event event) {
            String fileName = null;
            FileDialog dialog = new FileDialog(ThumbnailBuilder.this.getShell(), 4096);
            dialog.setText(Messages.getString((String)"ThumbnailBuilder.FileDialog.Title"));
            dialog.setFilterExtensions(IMAGE_FILTER);
            fileName = dialog.open();
            if (fileName == null || fileName.trim().length() == 0) {
                return;
            }
            if (!ThumbnailBuilder.this.checkExtensions(fileName)) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Title"), Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Message"));
                return;
            }
            boolean continueSave = ThumbnailBuilder.this.continueSaveImage(fileName);
            if (!continueSave) {
                return;
            }
            ThumbnailBuilder.this.removeImage();
            try {
                ThumbnailBuilder.this.image = new Image(null, fileName);
                ThumbnailBuilder.this.previewCanvas.loadImage(ThumbnailBuilder.this.image);
                ThumbnailBuilder.this.btnRemove.setEnabled(true);
                ThumbnailBuilder.this.imageName = fileName;
                ThumbnailBuilder.this.hasThumbnail = true;
            }
            catch (Exception exception) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Title"), Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Message"));
            }
        }
    };
    private Listener btnImportListener = new Listener(){

        public void handleEvent(Event event) {
            String fileName = null;
            String absoluteFileName = null;
            AddImageResourceFileFolderSelectionDialog dlg = new AddImageResourceFileFolderSelectionDialog();
            if (dlg.open() != 0) {
                return;
            }
            fileName = dlg.getPath();
            if (fileName == null || fileName.trim().length() == 0) {
                return;
            }
            URL url = ThumbnailBuilder.this.getModuleHandle().findResource(fileName, 1);
            try {
                absoluteFileName = DEUtil.getFilePathFormURL((URL)url);
            }
            catch (Exception e) {
                ThumbnailBuilder.this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (!ThumbnailBuilder.this.checkExtensions(absoluteFileName)) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Title"), Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Message"));
                return;
            }
            boolean continueSave = ThumbnailBuilder.this.continueSaveImage(absoluteFileName);
            if (!continueSave) {
                return;
            }
            ThumbnailBuilder.this.removeImage();
            try {
                ThumbnailBuilder.this.image = new Image(null, absoluteFileName);
                ThumbnailBuilder.this.previewCanvas.loadImage(ThumbnailBuilder.this.image);
                ThumbnailBuilder.this.btnRemove.setEnabled(true);
                ThumbnailBuilder.this.hasThumbnail = true;
                ThumbnailBuilder.this.imageName = fileName;
            }
            catch (Exception exception) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Title"), Messages.getString((String)"ThumbnailBuilder.FileDialog.FileNameError.Message"));
            }
        }
    };

    public ThumbnailBuilder() {
        super(UIUtil.getDefaultShell(), DEFAULT_TEXT);
    }

    public ThumbnailBuilder(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public Image getImage() {
        return this.image;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite topComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(topComposite, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createSelectionArea(composite);
        this.createPreviewArea(composite);
        this.createButtons(composite);
        new Label(topComposite, 258).setLayoutData((Object)new GridData(768));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ThumbnailBuilder_ID");
        return topComposite;
    }

    protected void okPressed() {
        if (this.currentListener != null) {
            this.btnImport.removeListener(13, this.currentListener);
        }
        super.okPressed();
    }

    public boolean shouldSetThumbnail() {
        return this.hasThumbnail;
    }

    private void createSelectionArea(Composite composite) {
        Composite selectionArea = new Composite(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        selectionArea.setLayoutData((Object)gd);
        selectionArea.setLayout((Layout)new GridLayout());
        this.radioBtnGenerate = new Button(selectionArea, 16);
        this.radioBtnGenerate.setText(Messages.getString((String)"ThumbnailBuilder.Button.GenerateFromReport"));
        this.radioBtnGenerate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThumbnailBuilder.this.switchTo(0);
            }
        });
        this.radioBtnBrowse = new Button(selectionArea, 16);
        this.radioBtnBrowse.setText(Messages.getString((String)"ThumbnailBuilder.Button.BrowseFromFileSystem"));
        this.radioBtnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThumbnailBuilder.this.switchTo(1);
            }
        });
        this.radioBtnImport = new Button(selectionArea, 16);
        this.radioBtnImport.setText(Messages.getString((String)"ThumbnailBuilder.Button.ImportFromResource"));
        this.radioBtnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThumbnailBuilder.this.switchTo(2);
            }
        });
    }

    private void switchTo(int type) {
        if (this.currentListener != null) {
            this.btnImport.removeListener(13, this.currentListener);
        }
        switch (type) {
            case 0: {
                this.radioBtnGenerate.setSelection(true);
                this.radioBtnBrowse.setSelection(false);
                this.radioBtnImport.setSelection(false);
                this.btnImport.setText(BUTTON_TEXT_GENERATE);
                this.LayoutButtons();
                this.currentListener = this.btnGenerateListener;
                this.btnImport.addListener(13, this.currentListener);
                break;
            }
            case 1: {
                this.radioBtnGenerate.setSelection(false);
                this.radioBtnBrowse.setSelection(true);
                this.radioBtnImport.setSelection(false);
                this.btnImport.setText(Messages.getString((String)"ThumbnailBuilder.Button.Text.Browse"));
                this.LayoutButtons();
                this.currentListener = this.btnBrowseListener;
                this.btnImport.addListener(13, this.currentListener);
                break;
            }
            case 2: {
                this.radioBtnGenerate.setSelection(false);
                this.radioBtnBrowse.setSelection(false);
                this.radioBtnImport.setSelection(true);
                this.btnImport.setText(BUTTON_TEXT_IMPORT);
                this.LayoutButtons();
                this.currentListener = this.btnImportListener;
                this.btnImport.addListener(13, this.currentListener);
                break;
            }
        }
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1);
        gd.widthHint = 184;
        gd.heightHint = 229;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FormLayout());
        this.previewCanvas = new ImageCanvas(previewArea);
        FormData formData = new FormData(180, 229);
        formData.left = new FormAttachment((Control)previewArea);
        formData.top = new FormAttachment((Control)previewArea);
        this.previewCanvas.setLayoutData(formData);
    }

    protected boolean initDialog() {
        this.hasThumbnail = false;
        ReportDesignHandle moduleHandle = this.getModuleHandle();
        if (moduleHandle == null) {
            this.btnImport.setEnabled(false);
            this.btnRemove.setEnabled(false);
            return true;
        }
        ReportDesignHandle handle = moduleHandle;
        byte[] thumbnailData = handle.getThumbnail();
        if (thumbnailData == null || thumbnailData.length == 0) {
            this.btnRemove.setEnabled(false);
        } else {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(thumbnailData);
            this.image = new Image(null, (InputStream)inputStream);
            this.previewCanvas.clear();
            this.previewCanvas.loadImage(this.image);
            this.hasThumbnail = true;
        }
        this.switchTo(0);
        return true;
    }

    public ReportDesignHandle getModuleHandle() {
        if (this.handle == null) {
            return (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
        }
        return this.handle;
    }

    public void setReportDesignHandle(ReportDesignHandle handle) {
        this.handle = handle;
    }

    private void createButtons(Composite composite) {
        Composite buttonArea = new Composite(composite, 0);
        GridData gd = new GridData(1040);
        buttonArea.setLayoutData((Object)gd);
        buttonArea.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.btnImport = new Button(buttonArea, 8);
        this.btnImport.setLayoutData((Object)gd);
        this.btnRemove = new Button(buttonArea, 8);
        this.btnRemove.setText(BUTTON_TEXT_REMOVE);
        this.btnRemove.setLayoutData((Object)gd);
        this.btnRemove.addListener(13, this.btnRemoveListener);
    }

    private void LayoutButtons() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 768;
        Point pnt1 = this.btnImport.computeSize(-1, -1, true);
        Point pnt2 = this.btnRemove.computeSize(-1, -1, true);
        gd.widthHint = Math.max(pnt1.x, pnt2.x);
        this.btnImport.setLayoutData((Object)gd);
        this.btnRemove.setLayoutData((Object)gd);
        Control control = this.getDialogArea();
        if (control instanceof Composite) {
            ((Composite)control).layout();
        }
        this.getShell().pack();
    }

    private void removeImage() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.previewCanvas.clear();
        this.hasThumbnail = false;
        this.btnRemove.setEnabled(false);
    }

    private boolean checkExtensions(String fileName) {
        if (fileName == null) {
            return false;
        }
        int i = 0;
        while (i < IMAGE_TYPES.length) {
            if (fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean continueSaveImage(String fileName) {
        MessageDialog dialog;
        File file = new File(fileName);
        if (file.length() <= 0x100000L) {
            Image locImage = null;
            try {
                int imagePixel;
                locImage = new Image(null, fileName);
                ImageData imageData = locImage.getImageData();
                if (locImage != null && locImage.getImageData() != null && (imagePixel = imageData.height * imageData.width) <= 786432) {
                    return true;
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (locImage != null) {
                    locImage.dispose();
                }
            }
        }
        boolean ret = (dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"ThumbnailBuilder.PreviewImage.WarningDialog.Title"), null, Messages.getString((String)"ThumbnailBuilder.PreviewImage.WarningDialog.Prompt"), 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 1)).open() == 0;
        return ret;
    }
}

