/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.interfaces.IJointDataSetModel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class JointDataSetHandle
extends DataSetHandle
implements IJointDataSetModel {
    public JointDataSetHandle(Module module, JointDataSet element) {
        super(module, element);
    }

    public List getDataSetNames() {
        return ((JointDataSet)this.getElement()).getDataSetNames(this.module);
    }

    public Iterator dataSetsIterator() {
        List dataSetRefs = (List)this.getElement().getProperty(this.getModule(), "dataSets");
        if (dataSetRefs == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<DesignElementHandle> rtnList = new ArrayList<DesignElementHandle>();
        int i = 0;
        while (i < dataSetRefs.size()) {
            DataSet ds;
            ElementRefValue dataSetRef = (ElementRefValue)dataSetRefs.get(i);
            if (dataSetRef != null && (ds = (DataSet)dataSetRef.getElement()) != null) {
                rtnList.add(ds.getHandle(ds.getRoot()));
            }
            ++i;
        }
        return rtnList.iterator();
    }

    public void addDataSet(String dataSetName) throws SemanticException {
        ComplexPropertyCommand command = new ComplexPropertyCommand(this.module, this.getElement());
        command.addItem(new StructureContext(this.getElement(), (ElementPropertyDefn)this.getPropertyDefn("dataSets"), null), dataSetName);
    }

    public void removeDataSet(String dataSetName) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle("dataSets");
        propertyHandle.removeItem(dataSetName);
    }

    public Iterator joinConditionsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("joinConditions");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator paramBindingsIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void setProperty(String propName, Object value) throws SemanticException {
        if (!"paramBindings".equalsIgnoreCase(propName) && !"cachedRowCount".equalsIgnoreCase(propName) && !"afterClose".equalsIgnoreCase(propName) || "dataSetRowLimit".equalsIgnoreCase(propName) || "afterOpen".equalsIgnoreCase(propName) || "beforeClose".equalsIgnoreCase(propName) || "beforeOpen".equalsIgnoreCase(propName) || "dataSource".equalsIgnoreCase(propName) || "onFetch".equalsIgnoreCase(propName)) {
            super.setProperty(propName, value);
        }
    }
}

