/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator;

import hiro.yoshioka.generator.Messages;
import hiro.yoshioka.generator.MyFormatter;
import hiro.yoshioka.generator.bean.GeneratorBean;
import hiro.yoshioka.generator.bean.GroupGeneratorBean;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.util.SQLDataType;
import java.math.BigDecimal;
import java.util.Date;

public class SequenceFormatter
extends MyFormatter {
    static final String FORMAT = Messages.getString("SequenceFormatter.0");

    public SequenceFormatter() {
    }

    public SequenceFormatter(GeneratorBean generator) {
        super(generator, null);
        this.setZeroFilled(false);
    }

    public void setZeroFilled(boolean zeloFilled) {
        DBColumnValue column = this.generator.getParent().getColumn();
        SQLDataType dataType = column.getType();
        this.format = dataType.isDate() ? "%tF" : (dataType.isTimeStamp() ? "%tF %1$tT" : (dataType.isTime() ? "%tT" : (dataType.isNumerics() ? "%d" : (dataType.isString() ? (zeloFilled ? "%0" + column.getSize() + "d" : "%d") : "%d"))));
    }

    @Override
    public String getExtraFormat() {
        GroupGeneratorBean ggbean = this.generator.getParent();
        return String.format(FORMAT, ggbean.getStartValue());
    }

    @Override
    public String formatedString(int sumGeneratedGroupCount, int numOfGroupInCounter, int totalCounter, Date today) {
        GroupGeneratorBean ggbean = this.generator.getParent();
        ggbean.getParent();
        DBColumnValue column = ggbean.getColumn();
        SQLDataType dataType = column.getType();
        int total = totalCounter + ggbean.getStartValue();
        if (dataType.isBinary() || dataType.isBlob()) {
            return "NULL";
        }
        if (dataType.isBit()) {
            return String.valueOf(total % 2);
        }
        try {
            if (dataType.isDateOrDateTimeOrTime()) {
                return String.format(this.format, new Date());
            }
            if (column.getSize() > 0 && column.getSize() < 10) {
                BigDecimal divisor = new BigDecimal(10);
                divisor = divisor.pow(column.getSize());
                BigDecimal num = new BigDecimal(total);
                BigDecimal remainder = num.remainder(divisor);
                String val = String.format(this.format, remainder.intValue());
                return this.formatedString(val, column);
            }
            String val = String.format(this.format, total);
            return this.formatedString(val, column);
        }
        catch (Throwable e) {
            this.fLogger.warn((Object)("format error. Column[" + column.getName() + "] size[" + column.getSize() + "]"), e);
            return this.format;
        }
    }
}

