/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.csveditor.dialog.CSVConfigDialog;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.util.Date;
import jp.sf.orangesignal.csv.CsvConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.program.Program;

public class ResultSet2CsvJob
extends Job {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    ResultSetDataHolder2[] fResultSetDataHolder;
    CSVConfigDialog.MyCsvConfig fCsvConfig;

    public ResultSet2CsvJob(ResultSetDataHolder2[] rdh, CSVConfigDialog.MyCsvConfig cfg) {
        super("ResultSet => CSV");
        this.fResultSetDataHolder = rdh;
        this.fCsvConfig = cfg;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.CANCEL_STATUS;
        try {
            int total = this.fResultSetDataHolder.length;
            int success = 0;
            int failuer = 0;
            monitor.beginTask("ResultSet2CSV", total + 2);
            IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.csvFolder);
            folder = folder.getFolder(String.format("%tY%<tm%<td_%<tH%<tM%<tS", new Date()));
            folder.create(false, true, monitor);
            File fDir = ResourceMarker.cnvFile(folder);
            monitor.worked(1);
            ResultSetDataHolder2[] resultSetDataHolder2Array = this.fResultSetDataHolder;
            int n = this.fResultSetDataHolder.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                ResultSetDataHolder2 rdh = resultSetDataHolder2Array[n2];
                String pre = rdh.getTableName();
                if (StringUtil.isEmpty((Object)pre)) {
                    pre = rdh.getTableNameE();
                    pre = FileUtil.renameForWindows((String)pre, (String)"_");
                }
                if (rdh.saveCSV(file = ResourceMarker.cnvFile(ResourceMarker.createRandomFile(folder, ResourceMarker.csvFolder, pre)), this.fCsvConfig.getEncoding(), (CsvConfig)this.fCsvConfig, this.fCsvConfig.isWithRowColumn())) {
                    ++success;
                    Application.setStatus("Generated File[" + file.getAbsolutePath() + "]");
                    this.fLogger.trace((Object)("Generated File[" + file.getAbsolutePath() + "]"));
                } else {
                    ++failuer;
                }
                monitor.worked(1);
                monitor.setTaskName(String.format("TOTAL:%d SUCESS:%d FAILUER:%d", total, success, failuer));
                ++n2;
            }
            this.fLogger.trace((Object)("ret=" + ret));
            if (success > 0) {
                Program.launch((String)fDir.getAbsolutePath());
            }
            monitor.worked(1);
        }
        catch (Throwable e) {
            this.fLogger.fatal((Object)e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }
}

