/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.preferences.IExcelConst;
import hiro.yoshioka.preferences.Messages;
import hiro.yoshioka.preferences.PreferenceConstants;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.wolfdbmanager.Activator;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ConsolePreferencePage
extends PreferencePage
implements IExcelConst,
IWorkbenchPreferencePage {
    ColorRegistry registry = new ColorRegistry();
    List<MyItem> myItemList;
    TableViewer viewer;

    public ConsolePreferencePage() {
        this.setTitle(Messages.ConsolePreferencePage_Title);
        this.setMessage(Messages.ConsolePreferencePage_Title);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        try {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            ScrolledForm root = toolkit.createScrolledForm(parent);
            root.setText(Messages.ConsolePreferencePage_FgBg);
            root.getBody().setLayout((Layout)new GridLayout());
            Section section = toolkit.createSection(root.getBody(), 448);
            section.setDescription(Messages.ConsolePreferencePage_RestartMessage);
            section.setText(Messages.ConsolePreferencePage_Style);
            Composite inner = toolkit.createComposite((Composite)section);
            inner.setLayout((Layout)new GridLayout(3, false));
            this.viewer = new TableViewer(inner, 65536);
            Table table = this.viewer.getTable();
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            TableColumn column = new TableColumn(table, 0);
            column.setText(Messages.ConsolePreferencePage_Level);
            column.setWidth(120);
            column = new TableColumn(table, 0);
            column.setText(Messages.ConsolePreferencePage_Fg);
            column.setWidth(120);
            column = new TableColumn(table, 0);
            column.setText(Messages.ConsolePreferencePage_Bg);
            column.setWidth(120);
            String[] properties = new String[]{"0", "1", "2"};
            this.viewer.setColumnProperties(properties);
            CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table), new ColorCellEditor((Composite)table), new ColorCellEditor((Composite)table)};
            this.viewer.setCellEditors(editors);
            this.viewer.setCellModifier((ICellModifier)new MyCellModifier(this.viewer));
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
            MyItem item = null;
            this.myItemList = new ArrayList<MyItem>();
            item = new MyItem();
            item.level = Level.SEVERE.getName();
            item.colorFg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_SEVER_FG_COLOR");
            item.colorBg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_SEVER_BG_COLOR");
            this.myItemList.add(item);
            item = new MyItem();
            item.level = Level.WARNING.getName();
            item.colorFg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_WARNING_FG_COLOR");
            item.colorBg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_WARNING_BG_COLOR");
            this.myItemList.add(item);
            item = new MyItem();
            item.level = Level.INFO.getName();
            item.colorFg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_INFO_FG_COLOR");
            item.colorBg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_INFO_BG_COLOR");
            this.myItemList.add(item);
            item = new MyItem();
            item.level = Level.CONFIG.getName();
            item.colorFg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_CONFIG_FG_COLOR");
            item.colorBg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_CONFIG_BG_COLOR");
            this.myItemList.add(item);
            item = new MyItem();
            item.level = Level.FINE.getName();
            item.colorFg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_FINE_FG_COLOR");
            item.colorBg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_FINE_BG_COLOR");
            this.myItemList.add(item);
            item = new MyItem();
            item.level = Level.FINER.getName();
            item.colorFg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_FINER_FG_COLOR");
            item.colorBg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_FINER_BG_COLOR");
            this.myItemList.add(item);
            item = new MyItem();
            item.level = Level.FINEST.getName();
            item.colorFg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_FINEST_FG_COLOR");
            item.colorBg = PreferenceUtil.getRGB("VIEW_CONSOLE_LEVEL_FINEST_BG_COLOR");
            this.myItemList.add(item);
            this.viewer.setInput(this.myItemList);
            section.setClient((Control)inner);
            section.setLayoutData((Object)new GridData(768));
            return root;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void performDefaults() {
        String[] levels = PreferenceConstants.VIEW_CONSOLE_LEVEL_FG_ARRAY;
        int i = 0;
        while (i < levels.length) {
            this.myItemList.get((int)i).colorFg = PreferenceUtil.getRGB(levels[i], true);
            this.myItemList.get((int)i).colorBg = PreferenceUtil.getRGB(PreferenceConstants.VIEW_CONSOLE_LEVEL_BG_ARRAY[i], true);
            ++i;
        }
        this.viewer.refresh();
    }

    protected void performApply() {
        String[] levels = PreferenceConstants.VIEW_CONSOLE_LEVEL_FG_ARRAY;
        int i = 0;
        while (i < levels.length) {
            MyItem item = this.myItemList.get(i);
            PreferenceUtil.setRGBString(levels[i], item.colorFg);
            PreferenceUtil.setRGBString(PreferenceConstants.VIEW_CONSOLE_LEVEL_BG_ARRAY[i], item.colorBg);
            ++i;
        }
        Application.resetLogColor();
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    class MyCellModifier
    implements ICellModifier {
        private TableViewer viewer;

        public MyCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return !"0".equals(property);
        }

        public Object getValue(Object element, String property) {
            MyItem item = (MyItem)element;
            if ("1".equals(property)) {
                return item.colorFg;
            }
            if ("2".equals(property)) {
                return item.colorBg;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            MyItem item = (MyItem)element;
            if ("1".equals(property)) {
                item.colorFg = (RGB)value;
            } else if ("2".equals(property)) {
                item.colorBg = (RGB)value;
            }
            this.viewer.update(element, null);
        }
    }

    class MyItem {
        String level = "";
        RGB colorBg;
        RGB colorFg;

        MyItem() {
        }
    }

    class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            MyItem item = (MyItem)element;
            switch (columnIndex) {
                case 0: {
                    return item.level;
                }
                case 1: {
                    return item.colorFg.toString();
                }
                case 2: {
                    return item.colorBg.toString();
                }
            }
            return "";
        }

        public Color getBackground(Object element, int columnIndex) {
            MyItem item = (MyItem)element;
            ConsolePreferencePage.this.registry.put(item.colorBg.toString(), item.colorBg);
            if (columnIndex == 0 || columnIndex == 2) {
                return ConsolePreferencePage.this.registry.get(item.colorBg.toString());
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            MyItem item = (MyItem)element;
            ConsolePreferencePage.this.registry.put(item.colorFg.toString(), item.colorFg);
            if (columnIndex == 0 || columnIndex == 1) {
                return ConsolePreferencePage.this.registry.get(item.colorFg.toString());
            }
            return null;
        }
    }
}

