/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.util.StringUtil;

public class DBConnectionInitialItem {
    public String fDriverName = "";
    public String fUser = "";
    public String fPassWord = "";
    public String fDisplayString = "";
    public String fURL;
    public String fDriverFilePath;
    public String fInternalLogon;
    public boolean fDBMS;

    public DBConnectionInitialItem(String driverName, String user, String password, String display) {
        this.fDriverName = driverName;
        this.fUser = user;
        this.fPassWord = password;
        this.fDisplayString = display;
    }

    private DBConnectionInitialItem() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBConnectionInitialItem) {
            DBConnectionInitialItem target = (DBConnectionInitialItem)obj;
            if (!StringUtil.nvl((Object)this.fDriverName).equals(target.fDriverName)) {
                return false;
            }
            if (!StringUtil.nvl((Object)this.fUser).equals(target.fUser)) {
                return false;
            }
            if (!StringUtil.nvl((Object)this.fPassWord).equals(target.fPassWord)) {
                return false;
            }
            return StringUtil.nvl((Object)this.fURL).equals(target.fURL);
        }
        return false;
    }

    public String miniString() {
        return String.valueOf(this.fDisplayString) + "->" + this.fURL + "|" + this.fUser;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fDriverName);
        buf.append("|").append(this.fUser);
        buf.append("|").append(this.fPassWord);
        buf.append("|").append(this.fDisplayString);
        buf.append("|").append(this.fURL);
        buf.append("|").append(this.fDriverFilePath);
        buf.append("|").append(this.fInternalLogon);
        buf.append("|").append(this.fDBMS);
        return buf.toString();
    }

    public void load(String data) {
        int i = 0;
        String[] datas = data.split("[|]", -1);
        this.fDriverName = datas[i++];
        this.fUser = datas[i++];
        this.fPassWord = datas[i++];
        this.fDisplayString = datas[i++];
        this.fURL = datas[i++];
        this.fDriverFilePath = datas[i++];
        this.fInternalLogon = datas[i++];
        this.fDBMS = "true".equals(datas[i++]);
    }

    public static DBConnectionInitialItem loadData(String string) {
        try {
            DBConnectionInitialItem ret = new DBConnectionInitialItem();
            ret.load(string);
            return ret;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public String getWindowTile() {
        if (this.fDisplayString == null || this.fDisplayString.length() == 0) {
            return String.valueOf(this.fURL) + ":" + this.fUser;
        }
        return String.format("[%s] %s:%s", this.fDisplayString, this.fURL, this.fUser);
    }
}

