/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.job.AbsBasicPoiWriter;
import hiro.yoshioka.preferences.AbsDDL;
import hiro.yoshioka.preferences.ExcelDefData;
import hiro.yoshioka.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class DDL2
extends AbsDDL {
    public DDL2(ExcelDefData excelDefData) {
        super(excelDefData);
    }

    @Override
    public String doWork() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.fExcelDefData.files.length) {
            try {
                if (this.fExcelDefData.files[i].isFile()) {
                    String text = this.createDDL(this.fExcelDefData.files[i]);
                    buf.append(text);
                    buf.append(StringUtil.LINE_SEPARATOR);
                }
            }
            catch (Exception e) {
                this.fLogger.error((Object)"", (Throwable)e);
            }
            ++i;
        }
        return buf.toString();
    }

    private String createDDL(File file) {
        MyPoi poi = new MyPoi(file);
        return poi.createDDL();
    }

    class MyPoi
    extends AbsBasicPoiWriter {
        public MyPoi(File file) {
            super(file);
            this.init();
        }

        public String createDDL() {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < this.fHSSFWorkbook.getNumberOfSheets()) {
                this.setName(buf, this.fHSSFWorkbook.getSheetAt(i));
                ++i;
            }
            return buf.toString();
        }

        public String setName(StringBuilder buf, HSSFSheet sheet) {
            HashMap<String, String> dobleCheck = new HashMap<String, String>();
            new StringBuilder();
            HSSFCell cell = this.getHSSFCellByA1(sheet, DDL2.this.fExcelDefData.fPhysicalTableName);
            String tblName = this.getCellString(cell);
            int j = DDL2.this.fExcelDefData.fStartLine;
            while (j < sheet.getLastRowNum()) {
                block7: {
                    try {
                        String name;
                        HSSFRow row = sheet.getRow(j);
                        if (row == null || (name = this.getCellString(cell = this.getHSSFCellByA1(sheet, DDL2.this.fExcelDefData.fPhysicalColumnName, j + 1))).length() == 0 || dobleCheck.get(name) != null) break block7;
                        dobleCheck.put(name, name);
                        buf.append("COMMENT ON COLUMN " + tblName + ".");
                        if (name.equals("COUNT")) {
                            buf.append("\"COUNT\"");
                        } else if (name.equals("BINARY")) {
                            buf.append("\"BINARY\"");
                        } else {
                            buf.append(".").append(name);
                        }
                        cell = this.getHSSFCellByA1(sheet, DDL2.this.fExcelDefData.fLogicalColumnName, j + 1);
                        buf.append(" IS '" + this.getCellString(cell) + "'");
                        buf.append(",\r\n");
                    }
                    catch (NullPointerException nullPointerException) {
                        break;
                    }
                }
                ++j;
            }
            buf.append(");\r\n");
            return buf.toString();
        }
    }
}

