/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.generator.GenerateManager;
import hiro.yoshioka.generator.usingrdh.RDHCustomizedWizard;
import hiro.yoshioka.generator.usingrdh.RandomGeneratorDialog;
import hiro.yoshioka.generator.usingrdh.SequenceGeneratorDialog;
import hiro.yoshioka.generator.usingrdh.TextFileGeneratorDialog;
import hiro.yoshioka.generator.usingrdh.XXXGeneratorDialog;
import hiro.yoshioka.job.DataInsertFromGeneratorsJob;
import hiro.yoshioka.preferences.GenerateType;
import hiro.yoshioka.preferences.Messages;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class DataGenerateDialog
extends Dialog
implements ModifyListener {
    public static final String[] COLUMN_HEADERS = new String[]{Messages.DataGenerateDialog_TH_Column, Messages.DataGenerateDialog_TH_Size, Messages.DataGenerateDialog_TH_GenerateType, Messages.DataGenerateDialog_TH_Format, Messages.DataGenerateDialog_TH_ExtFormat};
    public static final int[] COLUMN_HEADERS_WIDTH = new int[]{130, 45, 110, 160, 160};
    private static final int BTN_ID_SAVE = 3400;
    private static final int BTN_ID_INSERT = 3890;
    Spinner fSpinTotalRecords;
    Spinner fSpinGroupRecords;
    GenerateManager manager;
    Table previewTable;
    TableViewer tableViewer;
    private ConnectionProperties connectionProperties;
    String insertScript;

    public DataGenerateDialog(Shell shell, DBTableValue dbTable, ConnectionProperties connectionProperties) {
        super(shell);
        this.manager = new GenerateManager(dbTable);
        this.manager.setGenerator(GenerateType.SEQUENCE);
        this.connectionProperties = connectionProperties;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButton(parent, 3890, "Direct Insert", false);
        super.createButton(parent, 3400, Messages.DataGenerateDialog_BtnSAVE, false);
        super.createButtonsForButtonBar(parent);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = Messages.DataGenerateDialog_Btn_GenerateInsertStatement;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 3890: {
                List<Map<String, BindObject>> insertMapList = this.manager.createInsertValuesMap(this.previewTable);
                String tableName = this.manager.getBean().getDbTable().getName();
                DataInsertFromGeneratorsJob job = new DataInsertFromGeneratorsJob(insertMapList, tableName, this.connectionProperties);
                this.close();
                job.setUser(true);
                job.schedule();
                break;
            }
            case 3400: {
                try {
                    String name = String.valueOf(this.manager.getBean().getDbTable().getName()) + ".gen";
                    IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.genFolder);
                    IFile file = ResourceMarker.createFile(folder, name);
                    PreferenceUtil.saveXML(file.getFullPath().toFile(), this.manager.getBean());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 0: {
                this.insertScript = this.manager.createScript(this.previewTable);
                this.close();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm root = toolkit.createScrolledForm(parent);
        root.setText(Messages.DataGenerateDialog_LbGenerator);
        root.setLayout((Layout)new GridLayout());
        root.setLayoutData((Object)new GridData(1808));
        root.getBody().setLayout((Layout)new GridLayout());
        root.getBody().setLayoutData((Object)new GridData(1808));
        Section section = toolkit.createSection(root.getBody(), 448);
        section.setText(Messages.DataGenerateDialog_LbGenerateMode);
        section.setDescription(Messages.DataGenerateDialog_MessageOfDoubleClick);
        GridData gd0 = new GridData(768);
        gd0.widthHint = 680;
        gd0.heightHint = 180;
        section.setLayoutData((Object)gd0);
        Table generatorSettingTable = new Table((Composite)section, 68352);
        generatorSettingTable.setHeaderVisible(true);
        this.tableViewer = new TableViewer(generatorSettingTable);
        int i = 0;
        while (i < COLUMN_HEADERS.length) {
            TableColumn col = new TableColumn(generatorSettingTable, 0);
            col.setText(COLUMN_HEADERS[i]);
            col.setWidth(COLUMN_HEADERS_WIDTH[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.tableViewer.setColumnProperties(COLUMN_HEADERS);
        this.tableViewer.getTable().addMouseListener((MouseListener)new MyClicker());
        this.tableViewer.setInput((Object)this.manager);
        this.tableViewer.getTable().setLinesVisible(true);
        section.setClient((Control)generatorSettingTable);
        Section section2 = toolkit.createSection(root.getBody(), 320);
        section2.setText(Messages.DataGenerateDialog_GenerateRecordsCounter);
        section2.setLayoutData((Object)new GridData(768));
        Composite inner2 = toolkit.createComposite((Composite)section2);
        section2.setClient((Control)inner2);
        inner2.setLayout((Layout)new GridLayout(4, false));
        toolkit.createLabel(inner2, Messages.DataGenerateDialog_NumOfGroupCount, 2048);
        this.fSpinGroupRecords = new Spinner(inner2, 2048);
        this.fSpinGroupRecords.setToolTipText("");
        this.fSpinGroupRecords.setMinimum(1);
        this.fSpinGroupRecords.setMaximum(500);
        this.fSpinGroupRecords.setSelection(3);
        this.fSpinGroupRecords.setLayoutData((Object)new GridData(768));
        this.fSpinGroupRecords.addModifyListener((ModifyListener)this);
        toolkit.createLabel(inner2, Messages.DataGenerateDialog_NumOfTotalCount, 2048);
        this.fSpinTotalRecords = new Spinner(inner2, 2048);
        this.fSpinTotalRecords.setToolTipText("");
        this.fSpinTotalRecords.setMinimum(1);
        this.fSpinTotalRecords.setMaximum(100000);
        this.fSpinTotalRecords.setSelection(100);
        this.fSpinTotalRecords.setLayoutData((Object)new GridData(768));
        this.fSpinTotalRecords.addModifyListener((ModifyListener)this);
        Section section3 = toolkit.createSection(root.getBody(), 320);
        section3.setText(Messages.DataGenerateDialog_GENERATE_RECOREDS);
        GridData gd2 = new GridData(1808);
        gd2.widthHint = 680;
        gd2.heightHint = 230;
        section3.setLayoutData((Object)gd2);
        this.previewTable = toolkit.createTable((Composite)section3, 0x10010300);
        this.previewTable.setHeaderVisible(true);
        section3.setClient((Control)this.previewTable);
        this.refresh();
        return root;
    }

    private void refresh() {
        if (this.manager.getBean().getAllType() == GenerateType.SELECTED_ROWS) {
            this.fSpinTotalRecords.setEnabled(false);
            this.fSpinGroupRecords.setEnabled(true);
            this.manager.refreshPreviewOfGroup(this.previewTable, this.fSpinGroupRecords.getSelection());
            try {
                int value = this.fSpinGroupRecords.getSelection() * this.manager.getBean().getGrpGenOfCols()[0].getGeneratorBean().getFormatterList().size();
                if (this.fSpinTotalRecords.getSelection() != value) {
                    this.fSpinTotalRecords.setSelection(value);
                }
            }
            catch (Exception exception) {}
        } else {
            this.fSpinTotalRecords.setEnabled(true);
            this.fSpinGroupRecords.setEnabled(false);
            this.manager.refreshPreviewSimple(this.previewTable, this.fSpinTotalRecords.getSelection());
        }
        this.previewTable.redraw();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doubleClicked(int rowIdx, int colIdx) {
        if (colIdx == 0 || rowIdx < 0) {
            return;
        }
        if (rowIdx == 0) {
            if (colIdx != 2) return;
            String[] buttons5 = new String[]{GenerateType.SEQUENCE.getMessage(), GenerateType.XXX.getMessage(), GenerateType.RANDOM.getMessage(), GenerateType.SELECTED_ROWS.getMessage(), Messages.DataGenerateDialog_CANSEL};
            MessageDialog dlg = new MessageDialog(this.getShell(), Messages.DataGenerateDialog_ChangeGenerateType, null, Messages.DataGenerateDialog_ChangeGenerateType, 2, buttons5, 2);
            int button = dlg.open();
            switch (button) {
                case -1: {
                    return;
                }
                case 0: {
                    SequenceGeneratorDialog sdialog = new SequenceGeneratorDialog(this.getShell());
                    sdialog.setBlockOnOpen(true);
                    if (1 == sdialog.open()) break;
                    this.manager.setAllSeqGenerator(sdialog.startValue, sdialog.zeroFilled);
                    break;
                }
                case 1: {
                    XXXGeneratorDialog xdialog = new XXXGeneratorDialog(this.getShell());
                    xdialog.setBlockOnOpen(true);
                    if (1 == xdialog.open()) break;
                    this.manager.setAllXxxGenerator(xdialog.mode);
                    this.fSpinTotalRecords.setSelection(1);
                    break;
                }
                case 2: {
                    RandomGeneratorDialog rdialog = new RandomGeneratorDialog(this.getShell());
                    rdialog.setBlockOnOpen(true);
                    if (1 == rdialog.open()) break;
                    this.manager.setAllRandomGenerator(rdialog.mode, rdialog.zeroFilled);
                    break;
                }
                case 3: {
                    RDHCustomizedWizard wizard = new RDHCustomizedWizard(this.manager.getBean().getDbTable(), this.connectionProperties);
                    WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                    if (1 == dialog.open()) break;
                    this.manager.setGenerator(GenerateType.SELECTED_ROWS, wizard.getFormats());
                    break;
                }
                case 4: {
                    return;
                }
            }
            this.tableViewer.refresh();
            this.refresh();
            return;
        } else {
            if (colIdx != 2) return;
            String[] buttons6 = new String[]{GenerateType.SEQUENCE.getMessage(), GenerateType.XXX.getMessage(), GenerateType.RANDOM.getMessage(), GenerateType.TEXT_FILE.getMessage(), GenerateType.SELECTED_ROWS.getMessage(), Messages.DataGenerateDialog_CANSEL};
            String[] buttons5 = new String[]{GenerateType.SEQUENCE.getMessage(), GenerateType.XXX.getMessage(), GenerateType.RANDOM.getMessage(), GenerateType.TEXT_FILE.getMessage(), Messages.DataGenerateDialog_CANSEL};
            GenerateType type = this.manager.getBean().getGenerateTypeAt(rowIdx - 1);
            String[] buttons = buttons6;
            if (type != GenerateType.SELECTED_ROWS) {
                buttons = buttons5;
            }
            MessageDialog dlg = null;
            dlg = new MessageDialog(this.getShell(), Messages.DataGenerateDialog_ChangeGenerateType, null, Messages.DataGenerateDialog_ChangeGenerateType, 2, buttons, 2);
            int button = dlg.open();
            switch (button) {
                case -1: {
                    return;
                }
                case 0: {
                    int stValue = this.manager.getPartOfStartValue(rowIdx - 1);
                    SequenceGeneratorDialog sdialog = new SequenceGeneratorDialog(this.getShell(), stValue);
                    sdialog.setBlockOnOpen(true);
                    if (1 == sdialog.open()) break;
                    this.manager.setPartOfSeqGenerator(sdialog.startValue, sdialog.zeroFilled, rowIdx - 1);
                    break;
                }
                case 1: {
                    XXXGeneratorDialog xdialog = new XXXGeneratorDialog(this.getShell());
                    xdialog.setBlockOnOpen(true);
                    if (1 == xdialog.open()) break;
                    this.manager.setPartOfXxxGenerator(xdialog.mode, rowIdx - 1);
                    break;
                }
                case 2: {
                    RandomGeneratorDialog rdialog = new RandomGeneratorDialog(this.getShell());
                    rdialog.setBlockOnOpen(true);
                    if (1 == rdialog.open()) break;
                    this.manager.setPartOfRandomGenerator(rdialog.mode, rdialog.zeroFilled, rowIdx - 1);
                    break;
                }
                case 3: {
                    TextFileGeneratorDialog tdialog = new TextFileGeneratorDialog(this.getShell());
                    tdialog.setBlockOnOpen(true);
                    if (1 == tdialog.open()) break;
                    this.manager.setPartOfTextGenerator(tdialog.sequencial, tdialog.splitted, tdialog.filePath, rowIdx - 1);
                    break;
                }
                case 4: {
                    if (type != GenerateType.SELECTED_ROWS) break;
                    RDHCustomizedWizard wizard = new RDHCustomizedWizard(this.manager.getBean().getDbTable(), this.manager.getColumnGenerateFormat(rowIdx - 1));
                    WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                    if (1 == dialog.open()) break;
                    this.manager.setPartGenerator(GenerateType.SELECTED_ROWS, rowIdx - 1, wizard.fColumnGenerateFormat);
                    break;
                }
                case 5: {
                    return;
                }
            }
            this.tableViewer.refresh();
            this.refresh();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.refresh();
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.manager.setDatabaseType(databaseType);
    }

    public void setDatabaseVersion(double majagerVersion) {
        this.manager.setDatabaseVersion(majagerVersion);
    }

    public String getInsertScript() {
        return this.insertScript;
    }

    private class MyClicker
    extends MouseAdapter {
        private MyClicker() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            Point p = new Point(e.x, e.y);
            Table tbl = DataGenerateDialog.this.tableViewer.getTable();
            TableItem item = tbl.getItem(p);
            if (item == null) {
                return;
            }
            TableItem[] items = tbl.getItems();
            int cols = tbl.getColumnCount();
            int i = 0;
            while (i < items.length) {
                if (items[i] == item) {
                    int coli = 0;
                    while (coli < cols) {
                        if (item.getBounds(coli).contains(p)) {
                            int lastSelectedRow = i;
                            int lastSelectedColumn = coli;
                            DataGenerateDialog.this.doubleClicked(lastSelectedRow, lastSelectedColumn);
                            return;
                        }
                        ++coli;
                    }
                }
                ++i;
            }
        }
    }

    private class MyContentProvider
    implements IStructuredContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof GenerateManager) {
                return ((GenerateManager)inputElement).getElements();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String[] strings = (String[])element;
            return strings[columnIndex];
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

