/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.selenium;

import com.google.common.base.Function;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.WebDriverBackedSelenium;
import hiro.yoshioka.job.DiffResultSetExcelWriter;
import hiro.yoshioka.job.ResultSetExcelWriter;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.selenium.Action;
import hiro.yoshioka.selenium.IScenarioRunnerListener;
import hiro.yoshioka.selenium.IssueParamPaser;
import hiro.yoshioka.selenium.Macro;
import hiro.yoshioka.selenium.Messages;
import hiro.yoshioka.selenium.NeverAskMimeType;
import hiro.yoshioka.selenium.TestBrowserType;
import hiro.yoshioka.selenium.WindowSize;
import hiro.yoshioka.selenium.inspect.BrowserAction;
import hiro.yoshioka.selenium.inspect.DatabaseAction;
import hiro.yoshioka.selenium.inspect.ExpectionType;
import hiro.yoshioka.selenium.inspect.VariableControlType;
import hiro.yoshioka.sql.AbsTransactionSQL;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.SQLUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.arnx.jsonic.JSON;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.seasar.fisshplate.template.FPTemplate;

public class ScenarioRunner {
    private static final List<String> NO_LOG_LIST = new ArrayList<String>();
    private static String INJECT_ERR_COLLECT_SCRIPT = "window.jsErrors = []; window.onerror = function(mes, url, line) {  window.jsErrors[window.jsErrors.length] = {'m': mes, 'url': url, 'line': line, 'dt': new Date()}; }";
    Pattern P_SKIP_DEF = Pattern.compile("all|skip|true|to([1-9][0-9]*)", 2);
    protected static Log fLogger = LogFactory.getLog(ScenarioRunner.class.getClass());
    IScenarioRunnerListener listerner;
    Counter counter = new Counter();
    private boolean doWork;
    private int pause_time;
    private LogEntry last_log_entry;
    private Properties scenario_variable_property = new Properties();
    private List<TestCaseResult> result_list = new ArrayList<TestCaseResult>();
    private HSSFWorkbook book;
    private Setting setting;
    ConnectionProperties connection_properties;
    private static Properties last_highelight_elm_css_info = new Properties();
    private static List<String> border_property_list = new ArrayList<String>();

    static {
        String[] stringArray = new String[]{"top", "right", "bottom", "left"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pos = stringArray[n2];
            border_property_list.add(String.format("boder-%s-color", pos));
            border_property_list.add(String.format("boder-%s-style", pos));
            border_property_list.add(String.format("boder-%s-width", pos));
            ++n2;
        }
        border_property_list.add("box-shadow");
        NO_LOG_LIST.add("XMLHttpRequest on the main thread is deprecated because of its detrimental effects to the end us");
    }

    private void injectJsErrorCollector(WebDriver driver) {
        if (driver instanceof InternetExplorerDriver) {
            try {
                ((JavascriptExecutor)driver).executeScript(INJECT_ERR_COLLECT_SCRIPT, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String replaceAutoNoMacro(String macro) {
        if (StringUtil.isEmpty((Object)macro)) {
            return macro;
        }
        if (macro.indexOf("${") < 0) {
            return macro;
        }
        if (this.scenario_variable_property.size() > 0) {
            for (Object key : this.scenario_variable_property.keySet()) {
                String s = "[$][{]" + key + "[}]";
                macro = macro.replaceAll(s, this.scenario_variable_property.getProperty(key.toString()));
            }
        }
        return Macro.replace(macro, this.setting.start_dt);
    }

    public static void main(String[] args) {
        String path = "C:/tmp/wolf_evidence/TO_NC_\u7e67\uff77\u7e5d\u7feb\u039c\u7e67\uff6a_2\u8fda\ufffd/20150706_1837/Firefox/21.17.\u83eb\uff6e\u8c41\uff63\u8413\u665e\ufffd\uff7c (\u87fe\uff65\u83f4\u61f7\u5cd9) /hoge.png";
        path = StringUtil.stripInvalidFileNameCharacter((String)path);
        System.out.println("path=" + path);
        File f = new File(path);
        System.out.println("f=" + f);
        File fp = f.getParentFile();
        try {
            fp.mkdirs();
            System.out.println("exists??" + fp.exists());
            FileUtil.writeFile((File)f, (String)"aaa", (String)"UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void highlight(WebDriver driver, WebElement elm) {
        last_highelight_elm_css_info.clear();
        try {
            for (String key : border_property_list) {
                String s = elm.getCssValue(key);
                last_highelight_elm_css_info.setProperty(key, s);
            }
            if (driver instanceof JavascriptExecutor) {
                JavascriptExecutor js = (JavascriptExecutor)driver;
                String color = "gold";
                if (!StringUtil.isEmpty((Object)this.setting.highlight_color)) {
                    color = this.setting.highlight_color;
                }
                String style = String.format("border:2px solid %s; box-shadow: 0 0 1em %s;", color, color);
                js.executeScript("arguments[0].setAttribute('style', arguments[1]);", new Object[]{elm, style});
            }
        }
        catch (Exception exception) {}
    }

    private void unHighlight(WebDriver driver, WebElement elm) {
        StringBuilder style_buf = new StringBuilder();
        for (String key : border_property_list) {
            style_buf.append(String.format("%s:%s;", key, last_highelight_elm_css_info.getProperty(key)));
        }
        try {
            if (driver instanceof JavascriptExecutor) {
                JavascriptExecutor js = (JavascriptExecutor)driver;
                js.executeScript("arguments[0].setAttribute('style', arguments[1]);", new Object[]{elm, style_buf.toString()});
            }
        }
        catch (Exception exception) {}
        last_highelight_elm_css_info.clear();
    }

    public Setting getSetting() {
        return this.setting;
    }

    public void setListerner(IScenarioRunnerListener listerner) {
        this.listerner = listerner;
    }

    public List<TestCaseResult> getResult_list() {
        return this.result_list;
    }

    public Properties getScenario_variable_property() {
        return this.scenario_variable_property;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public void init(File scenario_file) {
        block16: {
            FileInputStream in = null;
            try {
                try {
                    File f;
                    String output_path;
                    in = new FileInputStream(scenario_file);
                    this.book = new HSSFWorkbook((InputStream)in);
                    HSSFSheet sheet = this.book.getSheet("#setting");
                    this.setting = new Setting();
                    this.setting.num_of_test_case = this.countTestCase(this.setting);
                    this.setting.scenario_file = scenario_file;
                    this.setting.base_url = this.getPropertyValueOf(sheet, "base url");
                    if (StringUtil.isEmpty((Object)this.setting.base_url)) {
                        this.setting.base_url = "http://yahoo.co.jp";
                    }
                    if (!StringUtil.isEmpty((Object)(output_path = this.getPropertyValueOf(sheet, "output path")))) {
                        f = new File(output_path);
                        if (f.exists()) {
                            this.setting.evidence_output_folder = f;
                        } else if (f.mkdirs() && f.exists()) {
                            this.setting.evidence_output_folder = f;
                        }
                    }
                    this.setting.auto_take_pictures = "auto".equalsIgnoreCase(this.getPropertyValueOf(sheet, "take pictures"));
                    this.setting.take_on_changed_screen = this.isPropertyValueOf(sheet, "take_on_changed_screen");
                    this.setting.take_on_clicked = this.isPropertyValueOf(sheet, "take_on_clicked");
                    this.setting.take_on_sended_keys = this.isPropertyValueOf(sheet, "take_on_sended_keys");
                    this.setting.exit_on_failure = this.isPropertyValueOf(sheet, "exit on failure");
                    if (this.isPropertyValueOf(sheet, "Tested Firefox")) {
                        this.setting.test_browser_set.add(TestBrowserType.Firefox);
                    }
                    if (this.isPropertyValueOf(sheet, "Tested Chrome")) {
                        this.setting.test_browser_set.add(TestBrowserType.Chrome);
                        f = this.getPropertyFileValueOf(sheet, "webdriver.chrome.driver", true);
                        if (f != null) {
                            this.setting.webdriver_chrome_driver = f;
                        }
                    }
                    if (this.isPropertyValueOf(sheet, "Tested I.E.")) {
                        this.setting.test_browser_set.add(TestBrowserType.Ie);
                        f = this.getPropertyFileValueOf(sheet, "webdriver.ie.driver", true);
                        if (f != null) {
                            this.setting.webdriver_ie_driver = f;
                        }
                    }
                    this.setting.connection_id = this.getPropertyValueOf(sheet, "Connection Id");
                    if (!StringUtil.isEmpty((Object)this.setting.connection_id)) {
                        this.connection_properties = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(this.setting.connection_id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtils.closeQuietly((InputStream)in);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private File getPropertyFileValueOf(HSSFSheet sheet, String property_key, boolean must_be_exists) {
        String s = this.getPropertyValueOf(sheet, property_key);
        if (!StringUtil.isEmpty((Object)s)) {
            File f = new File(s);
            if (f.exists()) {
                return f;
            }
            fLogger.warn((Object)("File [" + f.getAbsolutePath() + "] is not exists."));
        }
        return null;
    }

    private String getPropertyValueOf(HSSFSheet sheet, String property_key) {
        HSSFRow row = this.getPropertyOf(sheet, property_key);
        if (row != null) {
            return this.getStringCellValue(row, 6);
        }
        return null;
    }

    private boolean isPropertyValueOf(HSSFSheet sheet, String property_key) {
        HSSFRow row = this.getPropertyOf(sheet, property_key);
        if (row != null) {
            return this.getBooleanCellValue(row, 6);
        }
        return false;
    }

    private HSSFRow getPropertyOf(HSSFSheet sheet, String property_key) {
        int i = sheet.getFirstRowNum();
        while (i <= sheet.getLastRowNum()) {
            String s;
            HSSFRow row = sheet.getRow(i);
            if (row != null && property_key.equalsIgnoreCase(s = this.getStringCellValue(row, 5))) {
                return row;
            }
            ++i;
        }
        return null;
    }

    public void run() {
        this.doWork = true;
        this.result_list = new ArrayList<TestCaseResult>();
        this.counter = new Counter();
        System.currentTimeMillis();
        Date d = new Date();
        File timed_folder = null;
        for (TestBrowserType browser_type : this.setting.test_browser_set) {
            if (!this.doWork) break;
            this.scenario_variable_property.clear();
            try {
                File now_evidence_folder = null;
                if (this.setting.evidence_output_folder != null && this.setting.evidence_output_folder.exists()) {
                    String fn;
                    String tn;
                    File scenario_folder;
                    String n = this.setting.scenario_file.getName();
                    if (n.endsWith(".xls")) {
                        n = n.substring(0, n.length() - 4);
                    }
                    if (n.endsWith(".xlsx")) {
                        n = n.substring(0, n.length() - 5);
                    }
                    if (!(scenario_folder = new File(this.setting.evidence_output_folder, n)).exists()) {
                        scenario_folder.mkdirs();
                    }
                    if (!(timed_folder = new File(scenario_folder, tn = String.format("%tY%tm%td_%tH%tM", d, d, d, d, d))).exists()) {
                        timed_folder.mkdirs();
                    }
                    if (!(now_evidence_folder = new File(timed_folder, fn = browser_type.name())).exists()) {
                        now_evidence_folder.mkdirs();
                    }
                    if (!now_evidence_folder.exists()) {
                        System.err.println("Nothing now_evidence_folder=" + now_evidence_folder.getAbsolutePath());
                        now_evidence_folder = null;
                    }
                }
                WebDriverBackedSelenium selenium = null;
                InternetExplorerDriver driver = null;
                switch (browser_type) {
                    case Firefox: {
                        FirefoxProfile profile = new FirefoxProfile();
                        profile.setPreference("browser.download.folderList", 2);
                        profile.setPreference("browser.download.useDownloadDir", true);
                        profile.setPreference("browser.download.dir", now_evidence_folder.getAbsolutePath());
                        profile.setPreference("browser.helperApps.neverAsk.saveToDisk", StringUtil.join(NeverAskMimeType.getMimeList(), (String)","));
                        profile.setPreference("browser.download.manager.showWhenStarting", false);
                        profile.setAcceptUntrustedCertificates(true);
                        driver = new FirefoxDriver(profile);
                        break;
                    }
                    case Chrome: {
                        if (this.setting.webdriver_chrome_driver != null) {
                            System.setProperty("webdriver.chrome.driver", this.setting.webdriver_chrome_driver.getAbsolutePath());
                        }
                        ChromeOptions options = new ChromeOptions();
                        options.addArguments(new String[]{"--ignore-certificate-errors"});
                        DesiredCapabilities c_caps = DesiredCapabilities.chrome();
                        LoggingPreferences logPrefs = new LoggingPreferences();
                        logPrefs.enable("browser", Level.ALL);
                        c_caps.setCapability("loggingPrefs", (Object)logPrefs);
                        c_caps.setCapability("chromeOptions", (Object)options);
                        driver = new ChromeDriver((Capabilities)c_caps);
                        break;
                    }
                    case Ie: {
                        DesiredCapabilities caps = DesiredCapabilities.internetExplorer();
                        caps.setCapability("ignoreZoomSetting", true);
                        caps.setCapability("ignoreProtectedModeSettings", true);
                        caps.setCapability("ensureCleanSession", true);
                        if (this.setting.webdriver_ie_driver == null) {
                            fLogger.info((Object)"setting.webdriver_ie_driver is null");
                        } else {
                            fLogger.info((Object)("setting.webdriver_ie_driver is [" + this.setting.webdriver_ie_driver.getAbsolutePath() + "]"));
                            System.setProperty("webdriver.ie.driver", this.setting.webdriver_ie_driver.getAbsolutePath());
                        }
                        driver = new InternetExplorerDriver((Capabilities)caps);
                    }
                }
                selenium = new WebDriverBackedSelenium(driver, this.setting.base_url);
                driver.manage().timeouts().implicitlyWait(4L, TimeUnit.SECONDS);
                this.runBySetting(browser_type, selenium, (WebDriver)driver, this.setting, now_evidence_folder);
            }
            catch (Exception e) {
                Application.openErrorDialog(null, "Error", e);
            }
        }
        if (this.listerner != null) {
            this.listerner.done(timed_folder);
        }
        if (timed_folder != null && timed_folder.exists()) {
            try {
                this.createResultBook(timed_folder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final Map<String, Object> createConstAsMap() {
        HashMap<String, Object> const_as = new HashMap<String, Object>();
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        const_as.put("today", cal.getTime());
        return const_as;
    }

    private void createResultBook(File timed_folder) {
        block8: {
            FPTemplate template = new FPTemplate();
            HashMap<String, Object> data = new HashMap<String, Object>();
            ArrayList sr_list = new ArrayList();
            ArrayList log_r_list = new ArrayList();
            Map<String, Object> const_as = ScenarioRunner.createConstAsMap();
            FileUtil util = new FileUtil(ScenarioRunner.class, "result_sample_scenario.xls");
            int i = this.result_list.size() - 1;
            while (i >= 0) {
                TestCaseResult result = this.result_list.get(i);
                HashMap<String, String> detail_map = new HashMap<String, String>();
                sr_list.add(detail_map);
                detail_map.put("browser", result.browser_type.name());
                detail_map.put("sheet_name", result.sheet_name);
                detail_map.put("description", result.description);
                detail_map.put("command", result.command);
                detail_map.put("parameter", result.parameter);
                detail_map.put("status", result.status);
                detail_map.put("result", result.result);
                detail_map.put("validation_result_of_db", result.inspection_result_of_db);
                detail_map.put("validation_result_of_browser", result.inspection_result_of_browser);
                detail_map.put("scenario_var", result.ctrl_variable);
                new StringBuilder();
                for (LogEntry entry : result.getLog_list()) {
                    Date dt = new Date(entry.getTimestamp());
                    HashMap<String, String> log_detail_map = new HashMap<String, String>();
                    log_r_list.add(log_detail_map);
                    log_detail_map.put("browser", result.browser_type.name());
                    log_detail_map.put("sheet_name", result.sheet_name);
                    log_detail_map.put("description", result.description);
                    log_detail_map.put("command", result.command);
                    log_detail_map.put("js_log_time", String.format("%tH:%tM:%tS", dt, dt, dt));
                    log_detail_map.put("js_log_level", entry.getLevel().getLocalizedName());
                    log_detail_map.put("js_log_l_level", entry.getLevel().getName());
                    log_detail_map.put("js_log_message", StringUtil.abbr((String)entry.getMessage(), (int)180));
                }
                if (result.getLog_list().size() > 0) {
                    detail_map.put("js_log", String.format(Messages.ScenarioRunner_NumOf, result.getLog_list().size()));
                }
                --i;
            }
            FileOutputStream out = null;
            try {
                try {
                    data.put("sr_list", sr_list);
                    data.put("log_r_list", log_r_list);
                    data.put("const_as", const_as);
                    HSSFWorkbook result_book = template.process((InputStream)util.getStream(), data);
                    File save_file = new File(timed_folder, "result_" + this.setting.scenario_file.getName());
                    out = new FileOutputStream(save_file);
                    result_book.write((OutputStream)out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOUtils.closeQuietly(out);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public int countTestCase(Setting setting) {
        int sum = 0;
        int i = 0;
        while (i < this.book.getNumberOfSheets()) {
            HSSFSheet sheet;
            if (!this.book.getSheetName(i).startsWith("#") && !this.isSkipAll(sheet = this.book.getSheetAt(i))) {
                int iRow = 3;
                while (iRow <= sheet.getLastRowNum()) {
                    HSSFRow row = null;
                    try {
                        Action action;
                        row = sheet.getRow(iRow);
                        String desc = this.getStringCellValue(row, 2);
                        if (!StringUtil.isEmpty((Object)desc) && (action = Action.parse(this.getStringCellValue(row, 3))) != null) {
                            ++sum;
                        }
                    }
                    catch (Exception exception) {}
                    ++iRow;
                }
            }
            ++i;
        }
        return sum;
    }

    public void runBySetting(TestBrowserType browser_type, WebDriverBackedSelenium selenium, WebDriver driver, Setting setting, File scenario_evidence_folder) {
        int i = 0;
        while (i < this.book.getNumberOfSheets()) {
            if (!this.doWork) break;
            if (!this.book.getSheetName(i).startsWith("#")) {
                File evidence_top_folder = null;
                if (scenario_evidence_folder != null) {
                    String folder_name = String.format("%02d.%s", i, FileUtil.renameForWindows((String)this.book.getSheetName(i), (String)"_"));
                    evidence_top_folder = new File(scenario_evidence_folder, folder_name);
                    evidence_top_folder.mkdirs();
                    if (!evidence_top_folder.exists()) {
                        evidence_top_folder = null;
                    }
                }
                this.exec_scenario(browser_type, this.book.getSheetAt(i), this.book.getSheetName(i), driver, selenium, setting, evidence_top_folder);
            }
            ++i;
        }
        if (setting.quitting_the_browser_at_end_of_scenario) {
            Application.createBalloon(Messages.ScenarioRunner_QuittingTheBrowser, String.valueOf(driver));
            if (this.doWork) {
                this.sleep(3000);
            }
            try {
                selenium.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                driver.quit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getStringCellValue(HSSFRow row, int col_index) {
        HSSFCell cell;
        if (row != null && (cell = row.getCell(col_index)) != null) {
            return cell.getStringCellValue();
        }
        return null;
    }

    private boolean getBooleanCellValue(HSSFRow row, int col_index) {
        HSSFCell cell;
        if (row != null && (cell = row.getCell(col_index)) != null) {
            return cell.getBooleanCellValue();
        }
        return false;
    }

    private int getIntCellValue(HSSFRow row, int col_index) {
        try {
            HSSFCell cell;
            if (row != null && (cell = row.getCell(col_index)) != null) {
                return new BigDecimal(cell.getNumericCellValue()).intValue();
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public void stop() {
        this.doWork = false;
    }

    private void createSkipExprResultFile(File evidence_top_folder, String desc_for_browser_inspection_result_file, boolean result, String skip_result_detail) {
        desc_for_browser_inspection_result_file = result ? String.valueOf(desc_for_browser_inspection_result_file) + "__SKIP_TRUE.txt" : String.valueOf(desc_for_browser_inspection_result_file) + "__SKIP_FALSE.txt";
        if (evidence_top_folder != null) {
            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
            FileUtil.writeFile((File)f, (String)skip_result_detail, (String)"UTF8");
        }
    }

    private void createSkippingInfoFile(File evidence_top_folder, String desc_for_browser_inspection_result_file, String skip_reason) {
        desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "__SKIP.txt";
        if (evidence_top_folder != null) {
            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
            FileUtil.writeFile((File)f, (String)skip_reason, (String)"UTF8");
        }
    }

    private void exec_scenario(TestBrowserType browser_type, HSSFSheet sheet, String sheet_name, WebDriver driver, WebDriverBackedSelenium selenium, Setting setting, File evidence_top_folder) {
        if (this.isSkipAll(sheet)) {
            return;
        }
        if (setting.has_failure) {
            return;
        }
        String dialog_message = null;
        System.out.println(String.valueOf(sheet_name) + "   ==>> setting.skip_to_sheet_name=" + setting.skip_to_sheet_name);
        int iRow = 3;
        while (iRow <= sheet.getLastRowNum()) {
            block77: {
                TestCaseResult case_result;
                block78: {
                    int current_no = iRow - 2;
                    if (setting.has_failure) break;
                    HSSFRow row = null;
                    String desc_for_browser_inspection_result_file = null;
                    case_result = new TestCaseResult(browser_type);
                    try {
                        ExpectionType db_expection_type;
                        Action action;
                        if (!this.doWork) break;
                        case_result.sheet_name = sheet_name;
                        row = sheet.getRow(iRow);
                        String desc = this.getStringCellValue(row, 2);
                        if (StringUtil.isEmpty((Object)desc)) break block77;
                        String desc_for_file = String.format("%03d_%s.png", iRow - 2, FileUtil.renameForWindows((String)desc, (String)"_"));
                        desc_for_browser_inspection_result_file = String.format("%03d_%s", iRow - 2, FileUtil.renameForWindows((String)desc, (String)"_"));
                        if (!StringUtil.isEmpty((Object)setting.skip_to_sheet_name)) {
                            if (!case_result.sheet_name.equals(setting.skip_to_sheet_name)) {
                                this.createSkippingInfoFile(evidence_top_folder, desc_for_browser_inspection_result_file, setting.skip_reason);
                                ++this.counter.rans;
                                break block77;
                            }
                            setting.skip_to_sheet_name = null;
                            System.out.println(" SET NULLLL   ==>> setting.skip_to_sheet_name=" + setting.skip_to_sheet_name);
                        }
                        if (setting.skip_this_no > 0) {
                            if (setting.skip_this_no != current_no) {
                                this.createSkippingInfoFile(evidence_top_folder, desc_for_browser_inspection_result_file, setting.skip_reason);
                                ++this.counter.rans;
                                break block77;
                            }
                            setting.skip_this_no = -1;
                            setting.skip_reason = null;
                        }
                        if ((action = Action.parse(this.getStringCellValue(row, 3))) == null) break block77;
                        if (this.pause_time > 0) {
                            try {
                                Thread.sleep(this.pause_time * 1000);
                            }
                            catch (Exception exception) {}
                            this.pause_time = 0;
                        }
                        ++this.counter.rans;
                        String parameter = this.replaceAutoNoMacro(this.getStringCellValue(row, 4));
                        String parameter2 = this.replaceAutoNoMacro(this.getStringCellValue(row, 5));
                        String parameter3 = this.replaceAutoNoMacro(this.getStringCellValue(row, 6));
                        case_result.description = desc;
                        case_result.command = action.getTitle();
                        case_result.parameter = parameter;
                        this.result_list.add(0, case_result);
                        int sleep = this.getIntCellValue(row, 9);
                        int before_count_of_query = 0;
                        ResultSetDataHolder2 before_query_result_set = null;
                        System.out.println("desc=" + desc);
                        Application.createBalloon(case_result.sheet_name, String.format("[%02d]%s", iRow - 2, desc));
                        this.changed(case_result, Messages.ScenarioRunner_running);
                        WebElement web_element = null;
                        DatabaseAction database_action = DatabaseAction.parse(this.getStringCellValue(row, 52));
                        if (database_action != null && this.connection_properties != null && (db_expection_type = ExpectionType.parse(this.getStringCellValue(row, 60))) != null && db_expection_type.needsBeforeSql()) {
                            this.changed(case_result, Messages.ScenarioRunner_RequestQueryToDB);
                            if (db_expection_type.needsQuery()) {
                                before_query_result_set = this.getResultSetDataHolder2(row, database_action);
                            } else {
                                before_count_of_query = this.countSql(row, database_action);
                            }
                        }
                        switch (action) {
                            case deleteAllCookies: {
                                if (StringUtil.isEmpty((Object)parameter)) {
                                    case_result.result = Messages.ScenarioRunner_error;
                                    case_result.inspection_result_of_browser = Messages.ScenarioRunner_SetCookiesClearSiteUrlAtParameterCell;
                                    ++this.counter.failures;
                                    break;
                                }
                                this.deleteAllCookies(driver, parameter);
                                case_result.result = Messages.ScenarioRunner_ok;
                                break;
                            }
                            case openUrl: {
                                driver.get(parameter);
                                this.changed(case_result, Messages.ScenarioRunner_waitForPageToLoad);
                                selenium.waitForPageToLoad("30000");
                                this.injectJsErrorCollector(driver);
                                case_result.result = Messages.ScenarioRunner_ok;
                                if (!setting.auto_take_pictures || evidence_top_folder == null) break;
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                                break;
                            }
                            case back: {
                                driver.navigate().back();
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                                break;
                            }
                            case forward: {
                                driver.navigate().forward();
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                                break;
                            }
                            case refresh: {
                                driver.navigate().refresh();
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                                break;
                            }
                            case execute_script: {
                                if (!(driver instanceof JavascriptExecutor)) break;
                                ((JavascriptExecutor)driver).executeScript(parameter, new Object[0]);
                                break;
                            }
                            case execute_async_script: {
                                if (!(driver instanceof JavascriptExecutor)) break;
                                ((JavascriptExecutor)driver).executeAsyncScript(parameter, new Object[0]);
                                break;
                            }
                            case setFile: {
                                web_element = this.getWebElement(driver, row);
                                this.highlight(driver, web_element);
                                web_element.sendKeys(new CharSequence[]{parameter});
                                case_result.result = Messages.ScenarioRunner_ok;
                                if (setting.auto_take_pictures && evidence_top_folder != null) {
                                    this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                                }
                                this.unHighlight(driver, web_element);
                                break;
                            }
                            case sendKeys: {
                                this.sendKeys(selenium, driver, row, web_element, parameter, parameter2, evidence_top_folder, desc_for_file, action, case_result, false);
                                break;
                            }
                            case click: 
                            case doubleClick: 
                            case moveToElement: 
                            case contextClick: {
                                if (this.isMultipleSelector(row)) {
                                    for (WebElement elm : this.getWebElements(driver, row)) {
                                        this.highlight(driver, web_element);
                                        this.clickOrMouseOver(selenium, driver, elm, action);
                                        case_result.result = Messages.ScenarioRunner_ok;
                                        if (setting.auto_take_pictures && evidence_top_folder != null) {
                                            this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false, true);
                                        }
                                        this.unHighlight(driver, web_element);
                                        this.sleep(100);
                                    }
                                    break;
                                }
                                web_element = this.getWebElement(driver, row);
                                this.clickOrMouseOver(selenium, driver, web_element, action);
                                case_result.result = Messages.ScenarioRunner_ok;
                                if (!setting.auto_take_pictures || evidence_top_folder == null) break;
                                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false, false);
                                break;
                            }
                            case selectByIndex: 
                            case selectByVisibleText: 
                            case selectByValue: {
                                this.selectBy(browser_type, this.getWebElement(driver, row), action, driver, evidence_top_folder, desc_for_file, case_result, parameter, parameter2, parameter3);
                                break;
                            }
                            case takesScreenshot: {
                                File sf = null;
                                sf = StringUtil.isEmpty((Object)parameter) ? new File(evidence_top_folder, desc_for_file) : new File(parameter);
                                if (evidence_top_folder == null) {
                                    case_result.result = Messages.ScenarioRunner_error;
                                    case_result.inspection_result_of_browser = Messages.ScenarioRunner_CheckYourSettingSheetOutputPath;
                                    break;
                                }
                                this.takeScreenShot(action, driver, sf, false);
                                case_result.result = Messages.ScenarioRunner_ok;
                                break;
                            }
                            case takesAllScreenshot: {
                                File sf2 = null;
                                File sf = StringUtil.isEmpty((Object)parameter) ? new File(evidence_top_folder, desc_for_file) : new File(parameter);
                                if (evidence_top_folder == null) {
                                    case_result.result = Messages.ScenarioRunner_error;
                                    case_result.inspection_result_of_browser = Messages.ScenarioRunner_CheckYourSettingSheetOutputPath;
                                    break;
                                }
                                this.takeScreenShot(action, driver, sf2, true);
                                case_result.result = Messages.ScenarioRunner_ok;
                                break;
                            }
                            case waitForInvisible: {
                                if (setting.auto_take_pictures && evidence_top_folder != null) {
                                    this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                                }
                                int wait_second = 60;
                                if (!StringUtil.isEmpty((Object)parameter)) {
                                    wait_second = StringUtil.parseIntNoneException((String)parameter, (int)60);
                                }
                                if (wait_second < 1) {
                                    wait_second = 1;
                                }
                                new WebDriverWait(driver, (long)wait_second).until((Function)ExpectedConditions.invisibilityOfElementLocated((By)this.getBy(row)));
                                case_result.result = Messages.ScenarioRunner_ok;
                                sleep = 0;
                                break;
                            }
                            case switchTo: {
                                driver.switchTo().frame(this.getWebElement(driver, row));
                                case_result.result = Messages.ScenarioRunner_ok;
                                break;
                            }
                            case switchToParentFrame: {
                                driver.switchTo().parentFrame();
                                case_result.result = Messages.ScenarioRunner_ok;
                                break;
                            }
                            case switchToDefaultContent: {
                                driver.switchTo().defaultContent();
                                case_result.result = Messages.ScenarioRunner_ok;
                                break;
                            }
                            case switchToConfirmAndAccept: {
                                if (setting.auto_take_pictures && evidence_top_folder != null) {
                                    this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), true);
                                }
                                Alert alert00 = driver.switchTo().alert();
                                dialog_message = alert00.getText();
                                alert00.accept();
                                break;
                            }
                            case switchToConfirmAndDismiss: {
                                if (setting.auto_take_pictures && evidence_top_folder != null) {
                                    this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), true);
                                }
                                Alert alert01 = driver.switchTo().alert();
                                dialog_message = alert01.getText();
                                alert01.dismiss();
                                break;
                            }
                            case switchToErrorAndAccept: {
                                if (setting.auto_take_pictures && evidence_top_folder != null) {
                                    this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), true);
                                }
                                Alert alert02 = driver.switchTo().alert();
                                dialog_message = alert02.getText();
                                alert02.accept();
                                break;
                            }
                            case setWindowSize: {
                                WindowSize windowSizeType = new WindowSize(parameter);
                                if (windowSizeType.getDisplay_resolution() == null) {
                                    driver.manage().window().setSize(windowSizeType.getDimension());
                                } else if (windowSizeType.isMaximize()) {
                                    driver.manage().window().maximize();
                                } else {
                                    driver.manage().window().setSize(windowSizeType.getDimension());
                                }
                                if (setting.auto_take_pictures && evidence_top_folder != null) {
                                    this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                                }
                                case_result.result = Messages.ScenarioRunner_ok;
                                break;
                            }
                            case inspectBrowser: {
                                this.inspectBrowser(driver, row, case_result, desc_for_browser_inspection_result_file, evidence_top_folder, dialog_message);
                                break;
                            }
                            case inspectDatabase: {
                                this.inspectDatabase(driver, row, case_result, desc_for_browser_inspection_result_file, evidence_top_folder, dialog_message, before_query_result_set, before_count_of_query);
                                break;
                            }
                            case gotoNoWhenExistsSelector: 
                            case gotoNoWhenExistsMultipleSelectors: 
                            case gotoNoWhenNotExistsSelector: {
                                boolean skip_proc_result = false;
                                WebElement skip_elm = null;
                                try {
                                    try {
                                        setting.skip_to_sheet_name = this.getSkipToSheetNo(parameter2);
                                        String message_pos = parameter;
                                        if (!StringUtil.isEmpty((Object)setting.skip_to_sheet_name)) {
                                            message_pos = String.format("[%s]%s", setting.skip_to_sheet_name, parameter);
                                        }
                                        if (action == Action.gotoNoWhenExistsSelector) {
                                            skip_elm = this.getWebElement(driver, row);
                                            setting.skip_reason = String.format(Messages.ScenarioRunner_Exists_GOTO, skip_elm, message_pos);
                                            setting.skip_this_no = StringUtil.parseIntNoneException((String)parameter, (int)-1);
                                            skip_proc_result = true;
                                        } else if (action == Action.gotoNoWhenNotExistsSelector) {
                                            setting.skip_reason = String.format(Messages.ScenarioRunner_NotExists_GOTO, message_pos);
                                            try {
                                                skip_elm = this.getWebElement(driver, row);
                                            }
                                            catch (Exception exception) {
                                                setting.skip_this_no = StringUtil.parseIntNoneException((String)parameter, (int)-1);
                                                skip_proc_result = true;
                                            }
                                        } else if (action == Action.gotoNoWhenExistsMultipleSelectors) {
                                            List<WebElement> elm = this.getWebElements(driver, row);
                                            setting.skip_reason = String.format(Messages.ScenarioRunner_Exists_GOTO, this.getWebElement(driver, row), message_pos);
                                            if (elm != null && elm.size() > 1) {
                                                setting.skip_this_no = StringUtil.parseIntNoneException((String)parameter, (int)-1);
                                                skip_proc_result = true;
                                            }
                                        }
                                    }
                                    catch (RuntimeException runtimeException) {
                                        this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format(Messages.ScenarioRunner_ExistsSelectorThenParams, new Object[]{action, skip_elm, parameter, skip_proc_result}));
                                        break;
                                    }
                                }
                                catch (Throwable throwable) {
                                    this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format(Messages.ScenarioRunner_ExistsSelectorThenParams, new Object[]{action, skip_elm, parameter, skip_proc_result}));
                                    throw throwable;
                                }
                                this.createSkipExprResultFile(evidence_top_folder, desc_for_browser_inspection_result_file, true, String.format(Messages.ScenarioRunner_ExistsSelectorThenParams, new Object[]{action, skip_elm, parameter, skip_proc_result}));
                                break;
                            }
                            default: {
                                case_result.result = Messages.ScenarioRunner_error;
                                System.err.println("what is action?" + (Object)((Object)action));
                                break block77;
                            }
                        }
                        if (!action.isInspectBrowser() && this.hasBrowserInspection(row)) {
                            this.changed(case_result, Messages.ScenarioRunner_InspectBrowser);
                            this.inspectBrowser(driver, row, case_result, desc_for_browser_inspection_result_file, evidence_top_folder, dialog_message);
                        }
                        if (!action.isInspectDatabase() && this.hasDatabaseInspection(row)) {
                            this.changed(case_result, Messages.ScenarioRunner_InspectDatabase);
                            this.inspectDatabase(driver, row, case_result, desc_for_browser_inspection_result_file, evidence_top_folder, dialog_message, before_query_result_set, before_count_of_query);
                        }
                        this.updateScenarioVariables(row, driver, case_result);
                        if (sleep > 0) {
                            this.changed(case_result, String.format(Messages.ScenarioRunner_sleep_ms, sleep));
                            this.sleep(sleep);
                        }
                        this.changed(case_result, Messages.ScenarioRunner_done);
                    }
                    catch (Exception e) {
                        case_result.result = "failure";
                        this.changed(case_result, Messages.ScenarioRunner_failures);
                        ++this.counter.failures;
                        e.printStackTrace();
                        if (evidence_top_folder != null) {
                            if (desc_for_browser_inspection_result_file == null) {
                                desc_for_browser_inspection_result_file = String.format("%03d_Exception", iRow - 2);
                            }
                            desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_NG.txt";
                            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
                            FileUtil.writeFile((File)f, (String)StringUtil.getStackTraceString((Throwable)e), (String)"UTF8");
                        }
                        if (!setting.exit_on_failure) break block78;
                        setting.has_failure = true;
                        return;
                    }
                }
                case_result.log_list = this.getJSLogs(browser_type, driver);
            }
            ++iRow;
        }
    }

    private void selectBy(TestBrowserType browser_type, WebElement web_element, Action action, WebDriver driver, File evidence_top_folder, String desc_for_file, TestCaseResult case_result, String parameter, String parameter2, String parameter3) {
        if (StringUtil.isEmpty((Object)parameter2) && StringUtil.isEmpty((Object)parameter3)) {
            this.selectBySub(browser_type, web_element, action, driver, evidence_top_folder, desc_for_file, case_result, parameter, false, null, true);
        } else {
            Select select = this.selectBySub(browser_type, web_element, action, driver, evidence_top_folder, desc_for_file, case_result, parameter, false, null, false);
            if (!StringUtil.isEmpty((Object)parameter2)) {
                this.selectBySub(browser_type, web_element, action, driver, evidence_top_folder, desc_for_file, case_result, parameter2, true, select, false);
            }
            if (!StringUtil.isEmpty((Object)parameter3)) {
                this.selectBySub(browser_type, web_element, action, driver, evidence_top_folder, desc_for_file, case_result, parameter3, true, select, false);
            }
        }
        case_result.result = Messages.ScenarioRunner_ok;
    }

    private Select selectBySub(TestBrowserType browser_type, WebElement web_element, Action action, WebDriver driver, File evidence_top_folder, String desc_for_file, TestCaseResult case_result, String parameter, boolean with_ctrl, Select select, boolean is_single_select) {
        if (select == null) {
            select = new Select(web_element);
        }
        this.highlight(driver, web_element);
        if (is_single_select || !browser_type.isChrome()) {
            if (with_ctrl) {
                web_element.sendKeys(new CharSequence[]{Keys.CONTROL});
            }
            switch (action) {
                case selectByIndex: {
                    select.selectByIndex(StringUtil.parseIntNoneException((String)parameter, (int)0));
                    break;
                }
                case selectByValue: {
                    select.selectByValue(parameter);
                    break;
                }
                case selectByVisibleText: {
                    select.selectByVisibleText(parameter);
                }
            }
        } else {
            switch (action) {
                case selectByIndex: {
                    int idx = StringUtil.parseIntNoneException((String)parameter, (int)0);
                    if (select.getOptions().size() <= idx) break;
                    WebElement options = (WebElement)select.getOptions().get(idx);
                    Actions builder = new Actions(driver);
                    if (with_ctrl) {
                        builder.sendKeys(new CharSequence[]{Keys.CONTROL});
                    }
                    builder.click(options);
                    builder.build().perform();
                    break;
                }
                case selectByValue: {
                    for (WebElement options : select.getOptions()) {
                        if (!StringUtil.nvl((Object)options.getAttribute("value")).equals(parameter)) continue;
                        Actions builder = new Actions(driver);
                        if (with_ctrl) {
                            builder.sendKeys(new CharSequence[]{Keys.CONTROL});
                        }
                        builder.click(options);
                        builder.build().perform();
                    }
                    break;
                }
                case selectByVisibleText: {
                    for (WebElement options : select.getOptions()) {
                        if (!options.getText().equals(parameter)) continue;
                        Actions builder = new Actions(driver);
                        if (with_ctrl) {
                            builder.sendKeys(new CharSequence[]{Keys.CONTROL});
                        }
                        builder.click(options);
                        builder.build().perform();
                    }
                    break;
                }
            }
        }
        if (this.setting.auto_take_pictures && evidence_top_folder != null) {
            this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false, false);
        }
        this.unHighlight(driver, web_element);
        return select;
    }

    private void updateScenarioVariables(HSSFRow row, WebDriver driver, TestCaseResult case_result) {
        VariableControlType var_ctrl_type = VariableControlType.parse(this.getStringCellValue(row, 13));
        String var_name = this.getStringCellValue(row, 14);
        String set_val = null;
        if (var_ctrl_type != null && !StringUtil.isEmpty((Object)var_name)) {
            switch (var_ctrl_type) {
                case clear: {
                    this.scenario_variable_property.remove(var_name);
                    case_result.ctrl_variable = String.format(Messages.ScenarioRunner_RemoveVar, var_name);
                    break;
                }
                case storeFromSelectorsValue: {
                    set_val = StringUtil.nvl((Object)this.getWebElement(driver, row).getAttribute("value"));
                    this.scenario_variable_property.setProperty(var_name, set_val);
                    case_result.ctrl_variable = String.format(Messages.ScenarioRunner_SetVar, var_name, set_val);
                    break;
                }
                case storeFromSelectorsText: {
                    set_val = StringUtil.nvl((Object)this.getWebElement(driver, row).getText());
                    this.scenario_variable_property.setProperty(var_name, set_val);
                    case_result.ctrl_variable = String.format(Messages.ScenarioRunner_SetVar, var_name, set_val);
                }
            }
            System.out.println("prop=" + this.scenario_variable_property);
        }
    }

    private String getSkipToSheetNo(String parameter2) {
        if (StringUtil.isEmpty((Object)parameter2) || this.book.getSheet(parameter2) == null) {
            return null;
        }
        return parameter2;
    }

    private void inspectBrowser(WebDriver driver, HSSFRow row, TestCaseResult case_result, String desc_for_browser_inspection_result_file, File evidence_top_folder, String dialog_message) {
        BrowserAction browser_action = BrowserAction.parse(this.getStringCellValue(row, 62));
        ExpectionType expection_type = ExpectionType.parse(this.getStringCellValue(row, 64));
        String expected_val = this.replaceAutoNoMacro(this.getStringCellValue(row, 65));
        StringBuilder message = new StringBuilder();
        message.append(String.format(Messages.ScenarioRunner_BrowserAction, browser_action.getTitle(), expection_type.getTitle()));
        String error_message = this.inspectBrowser(driver, row, browser_action, expection_type, expected_val, message, dialog_message);
        if (error_message != null) {
            Application.createBalloon(desc_for_browser_inspection_result_file, error_message, 1);
            case_result.result = Messages.ScenarioRunner_error;
            ++this.counter.errors;
            message.append(error_message);
            desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_BROWSER_NG.txt";
            System.err.println("Error! " + error_message);
            case_result.inspection_result_of_browser = error_message;
        } else {
            case_result.inspection_result_of_browser = expected_val;
            case_result.result = Messages.ScenarioRunner_ok;
            desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_BROWSER_OK.txt";
        }
        if (evidence_top_folder != null) {
            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
            FileUtil.writeFile((File)f, (String)message.toString(), (String)"UTF8");
        }
    }

    private boolean hasBrowserInspection(HSSFRow row) {
        BrowserAction browser_action = BrowserAction.parse(this.getStringCellValue(row, 62));
        return browser_action != null;
    }

    private boolean hasDatabaseInspection(HSSFRow row) {
        DatabaseAction database_action = DatabaseAction.parse(this.getStringCellValue(row, 52));
        return database_action != null;
    }

    private void changed(TestCaseResult case_result, String new_status) {
        if (this.listerner != null) {
            if (case_result != null && new_status != null) {
                case_result.status = new_status;
            }
            this.listerner.statusChanged();
        }
    }

    private boolean deleteAllCookies(WebDriver driver, String url) {
        try {
            fLogger.info((Object)("driver.navigate().to(" + url + ")"));
            driver.navigate().to(url);
            fLogger.info((Object)"[START] driver.manage().deleteAllCookies");
            driver.manage().deleteAllCookies();
            driver.manage().deleteCookieNamed("JSESSIONID");
            fLogger.info((Object)"[END] driver.manage().deleteAllCookies");
            if (driver instanceof InternetExplorerDriver) {
                fLogger.info((Object)"[START] RunDll32.exe InetCpl.cpl,ClearMyTracksByProcess 2");
                String command = "RunDll32.exe InetCpl.cpl,ClearMyTracksByProcess 2";
                int ret = Runtime.getRuntime().exec(command).waitFor();
                fLogger.info((Object)("[END] RunDll32.exe InetCpl.cpl,ClearMyTracksByProcess 2 [" + ret + "]"));
            }
            return true;
        }
        catch (Exception e2) {
            fLogger.warn((Object)e2.getMessage());
            return false;
        }
    }

    private void inspectDatabase(WebDriver driver, HSSFRow row, TestCaseResult case_result, String desc_for_browser_inspection_result_file, File evidence_top_folder, String dialog_message, ResultSetDataHolder2 before_query_resultset, int before_count_of_query) {
        int[] matchKeys = null;
        DatabaseAction db_action = DatabaseAction.parse(this.getStringCellValue(row, 52));
        String table_name = this.getStringCellValue(row, 53);
        String query = this.getStringCellValue(row, 54);
        ExpectionType expection_type = ExpectionType.parse(this.getStringCellValue(row, 60));
        String expected_val = this.replaceAutoNoMacro(this.getStringCellValue(row, 61));
        StringBuilder message = new StringBuilder();
        message.append(String.format(Messages.ScenarioRunner_DatabaseAction, db_action.getTitle(), expection_type.getTitle()));
        int current_count_of_query = -1;
        ResultSetDataHolder2 current_query_resultset = null;
        String error_message = null;
        if (this.connection_properties == null) {
            error_message = Messages.ScenarioRunner_UndefinedConnectionIdAtSettingSheet;
        } else {
            try {
                if (expection_type.needsQuery()) {
                    current_query_resultset = this.getResultSetDataHolder2(row, db_action);
                    List<String> lower_case_of_pk_list = this.getLowerCasePrimaryKeyColumns(row);
                    ArrayList<Integer> int_pk_list = new ArrayList<Integer>();
                    String[] keys = current_query_resultset.getKey();
                    int i = 0;
                    while (i < keys.length) {
                        if (lower_case_of_pk_list.contains(keys[i].toLowerCase())) {
                            int_pk_list.add(i);
                        }
                        ++i;
                    }
                    matchKeys = new int[int_pk_list.size()];
                    i = 0;
                    while (i < int_pk_list.size()) {
                        matchKeys[i] = (Integer)int_pk_list.get(i);
                        ++i;
                    }
                } else {
                    current_count_of_query = this.countSql(row, db_action);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            File rdh_evidence_file = new File(evidence_top_folder, String.valueOf(desc_for_browser_inspection_result_file) + "_DB_DIFF.xls");
            error_message = this.inspectDatabase(driver, row, db_action, table_name, query, expection_type, expected_val, message, dialog_message, before_count_of_query, current_count_of_query, before_query_resultset, current_query_resultset, matchKeys, rdh_evidence_file);
        }
        if (error_message != null) {
            Application.createBalloon(desc_for_browser_inspection_result_file, error_message, 1);
            case_result.result = Messages.ScenarioRunner_error;
            ++this.counter.errors;
            message.append(error_message);
            desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_DB_NG.txt";
            System.err.println("Error! " + error_message);
            case_result.inspection_result_of_db = error_message;
        } else {
            case_result.inspection_result_of_db = expected_val;
            case_result.result = Messages.ScenarioRunner_ok;
            desc_for_browser_inspection_result_file = String.valueOf(desc_for_browser_inspection_result_file) + "_DB_OK.txt";
        }
        if (evidence_top_folder != null) {
            File f = new File(evidence_top_folder, desc_for_browser_inspection_result_file);
            FileUtil.writeFile((File)f, (String)message.toString(), (String)"UTF8");
        }
    }

    private String inspectBrowser(WebDriver driver, HSSFRow row, BrowserAction action, ExpectionType expect, String parameter, StringBuilder message, String dialog_message) {
        WebElement element = null;
        String error_message = null;
        String s1 = null;
        String s2 = parameter;
        String selector = null;
        switch (action) {
            case window_name: {
                s1 = driver.getTitle();
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
                break;
            }
            case dialog_text: {
                s1 = dialog_message;
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
                break;
            }
            case element_text: {
                element = this.getWebElement(driver, row);
                selector = element.toString();
                s1 = element.getText();
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
                break;
            }
            case element_value: {
                element = this.getWebElement(driver, row);
                selector = element.toString();
                s1 = element.getAttribute("value");
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
                break;
            }
            case element_count: {
                List<WebElement> elm_list = this.getWebElements(driver, row);
                s1 = String.valueOf(elm_list.size());
                if (this.matcheAt(expect, s1, s2)) break;
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, s1, s2);
            }
        }
        if (!StringUtil.isEmpty(selector)) {
            message.append(String.format("Selector:%s %n", selector));
        }
        message.append(String.format(Messages.ScenarioRunner_expected_value_is, s2));
        return error_message;
    }

    private String getQueryString(HSSFRow row) {
        ArrayList<String> bind_list = new ArrayList<String>();
        String query = this.getStringCellValue(row, 54);
        int i = 1;
        while (i <= 5) {
            int iCol = 54 + i;
            String b = this.getStringCellValue(row, iCol);
            if (!StringUtil.isEmpty((Object)b)) {
                bind_list.add(b);
            }
            ++i;
        }
        HSSFSheet sheet = this.book.getSheet(query);
        StringBuilder buf = new StringBuilder();
        int i2 = 3;
        while (i2 <= sheet.getLastRowNum()) {
            String s;
            HSSFRow q_row = sheet.getRow(i2);
            if (q_row != null && !StringUtil.isEmpty((Object)(s = this.getStringCellValue(q_row, 2)))) {
                buf.append(String.format("%s%n", s));
            }
            ++i2;
        }
        return buf.toString();
    }

    private List<String> getLowerCasePrimaryKeyColumns(HSSFRow row) {
        ArrayList<String> pk_list = new ArrayList<String>();
        String sheet_name = this.getStringCellValue(row, 54);
        HSSFSheet sheet = this.book.getSheet(sheet_name);
        HSSFRow q_row = sheet.getRow(2);
        if (q_row == null) {
            return Collections.EMPTY_LIST;
        }
        String s = this.getStringCellValue(q_row, 2);
        if (StringUtil.isEmpty((Object)s)) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = s.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            if (!StringUtil.isEmpty((Object)(ss = ss.trim().toLowerCase())) && !pk_list.contains(ss)) {
                pk_list.add(ss);
            }
            ++n2;
        }
        return pk_list;
    }

    private ResultSetDataHolder2 getResultSetDataHolder2(HSSFRow row, DatabaseAction action_type) throws SQLException {
        ArrayList<String> bind_list = new ArrayList<String>();
        String sql_statement = this.getQueryString(row);
        int i = 1;
        while (i <= 5) {
            int iCol = 54 + i;
            String b = this.getStringCellValue(row, iCol);
            if (!StringUtil.isEmpty((Object)b)) {
                bind_list.add(b);
            }
            ++i;
        }
        if (!SQLServerThread.isConnected((String)this.setting.connection_id) && !SQLServerThread.runNowThisRequest((Request)new Request(SQLOperationType.CONNECT, this.connection_properties))) {
            return null;
        }
        AbsTransactionSQL i_sql = (AbsTransactionSQL)SQLServerThread.getSQLServer().getTransactionSQL(this.connection_properties);
        System.out.println("sql=" + sql_statement);
        return i_sql.executePrepareQuery(sql_statement, (Object[])bind_list.toArray(new String[bind_list.size()]));
    }

    private int countSql(HSSFRow row, DatabaseAction action_type) throws SQLException {
        String sql_statement = null;
        ArrayList<String> bind_list = new ArrayList<String>();
        String table_name = this.getStringCellValue(row, 53);
        int i = 1;
        while (i <= 5) {
            int iCol = 54 + i;
            String b = this.getStringCellValue(row, iCol);
            if (!StringUtil.isEmpty((Object)b)) {
                bind_list.add(b);
            }
            ++i;
        }
        switch (action_type) {
            case count_table: {
                sql_statement = String.format("SELECT COUNT(*) AS CNT FROM %s ", table_name);
                if (bind_list.size() > 0) {
                    i = 0;
                    while (i < bind_list.size()) {
                        sql_statement = i == 0 ? String.valueOf(sql_statement) + "  WHERE " : String.valueOf(sql_statement) + "  AND ";
                        sql_statement = String.valueOf(sql_statement) + (String)bind_list.get(i);
                        ++i;
                    }
                }
                bind_list.clear();
                break;
            }
            case count_query: {
                sql_statement = this.getQueryString(row);
                break;
            }
            default: {
                return -1;
            }
        }
        if (!SQLServerThread.isConnected((String)this.setting.connection_id) && !SQLServerThread.runNowThisRequest((Request)new Request(SQLOperationType.CONNECT, this.connection_properties))) {
            return -1;
        }
        AbsTransactionSQL i_sql = (AbsTransactionSQL)SQLServerThread.getSQLServer().getTransactionSQL(this.connection_properties);
        System.out.println("sql=" + sql_statement);
        return i_sql.countAndReturnFirstColumn(sql_statement, bind_list.toArray(new String[bind_list.size()]));
    }

    private String inspectDatabase(WebDriver driver, HSSFRow row, DatabaseAction action, String table_name, String query, ExpectionType expect, String parameter, StringBuilder message, String dialog_message, int before_count_of_query, int current_count_of_query, ResultSetDataHolder2 before_query_resultset, ResultSetDataHolder2 current_query_resultset, int[] matchKeys, File rdh_evidence_file) {
        String error_message = null;
        String s2 = parameter;
        Object selector = null;
        switch (action) {
            case count_table: 
            case count_query: {
                if (this.matcheAt(expect, before_count_of_query, current_count_of_query, s2)) break;
                if (expect.needsBeforeSql()) {
                    error_message = String.format(Messages.ScenarioRunner_BeforeAndAfterValues, expect.getTitle(), before_count_of_query, current_count_of_query);
                    break;
                }
                error_message = String.format(Messages.ScenarioRunner_A_is_diff_from_exp_B, String.valueOf(current_count_of_query), s2);
                break;
            }
            case select_query: {
                try {
                    DiffToResultSetDataHolder drh = new DiffToResultSetDataHolder();
                    drh.diffConfigure((StringRecordDataHolder)before_query_resultset, (StringRecordDataHolder)current_query_resultset, matchKeys);
                    drh.setCase_insensitive(true);
                    drh.diff();
                    Map<IssueParamPaser.CUDType, IssueParamPaser.IssueParam> validator_map = IssueParamPaser.parse(s2);
                    boolean hasError = false;
                    StringBuilder em = new StringBuilder();
                    for (IssueParamPaser.IssueParam issue : validator_map.values()) {
                        boolean this_loop_has_error = false;
                        int total_num = 0;
                        switch (issue.getCud_type()) {
                            case Create: {
                                total_num = drh.getSumInsert();
                                break;
                            }
                            case Update: {
                                total_num = drh.getSumUpdate();
                                break;
                            }
                            case Delete: {
                                total_num = drh.getSumDelete();
                            }
                        }
                        switch (expect) {
                            case equals: {
                                if (total_num == issue.getExpected_value()) break;
                                this_loop_has_error = true;
                                break;
                            }
                            case greater_equal: {
                                if (total_num < issue.getExpected_value()) break;
                                this_loop_has_error = true;
                                break;
                            }
                            case greater_than: {
                                if (total_num <= issue.getExpected_value()) break;
                                this_loop_has_error = true;
                                break;
                            }
                            case less_equal: {
                                if (total_num > issue.getExpected_value()) break;
                                this_loop_has_error = true;
                                break;
                            }
                            case less_than: {
                                if (total_num >= issue.getExpected_value()) break;
                                this_loop_has_error = true;
                            }
                        }
                        if (this_loop_has_error) {
                            hasError = true;
                            em.append(String.format(Messages.ScenarioRunner_15, new Object[]{issue.getCud_type(), total_num, issue.getComparator(), issue.getExpected_value()}));
                            continue;
                        }
                        em.append(String.format(Messages.ScenarioRunner_16, new Object[]{issue.getCud_type(), total_num, issue.getComparator(), issue.getExpected_value()}));
                    }
                    if (rdh_evidence_file == null) break;
                    String on = rdh_evidence_file.getName();
                    if (hasError) {
                        error_message = em.toString();
                        rdh_evidence_file = new File(rdh_evidence_file.getParentFile(), String.valueOf(on.substring(0, on.length() - 4)) + "_NG.xls");
                    } else {
                        rdh_evidence_file = new File(rdh_evidence_file.getParentFile(), String.valueOf(on.substring(0, on.length() - 4)) + "_OK.xls");
                    }
                    DiffResultSetExcelWriter writer = new DiffResultSetExcelWriter(new DiffToResultSetDataHolder[]{drh}, "diff", "diff", rdh_evidence_file);
                    ResultSetExcelWriter.configure(PreferenceUtil.getBoolean("EXCEL_DO_COLBREAK"), PreferenceUtil.getInt("EXCEL_COLBREAK_NUM"), PreferenceUtil.getInt("EXCEL_COL_WIDTH"), PreferenceUtil.getBoolean("EXCEL_DO_SHEETBREAK"));
                    writer.write((IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                catch (Exception e) {
                    fLogger.warn((Object)"", (Throwable)e);
                }
            }
        }
        if (!StringUtil.isEmpty(selector)) {
            message.append(String.format("Selector:%s %n", selector));
        }
        message.append(String.format(Messages.ScenarioRunner_expected_value_is, s2));
        return error_message;
    }

    private boolean matcheAt(ExpectionType expect, int before_count_of_query, int current_count_of_query, String expected_value) {
        BigDecimal current_count = null;
        BigDecimal expected_count = null;
        if (!expect.isEquals() && expect.isNumericType()) {
            new BigDecimal(before_count_of_query);
            current_count = new BigDecimal(current_count_of_query);
            try {
                expected_count = new BigDecimal(expected_value);
            }
            catch (Exception exception) {}
        }
        switch (expect) {
            case equals: {
                return before_count_of_query == current_count_of_query;
            }
            case increase: {
                return before_count_of_query < current_count_of_query;
            }
            case decrease: {
                return before_count_of_query > current_count_of_query;
            }
            case greater_equal: {
                return current_count.compareTo(expected_count) >= 0;
            }
            case greater_than: {
                return current_count.compareTo(expected_count) > 0;
            }
            case less_equal: {
                return current_count.compareTo(expected_count) <= 0;
            }
            case less_than: {
                return current_count.compareTo(expected_count) < 0;
            }
        }
        return false;
    }

    private boolean matcheAt(ExpectionType expect, String s1, String s2) {
        s1 = StringUtil.nvl((Object)s1);
        s2 = StringUtil.nvl((Object)s2);
        BigDecimal b1 = null;
        BigDecimal b2 = null;
        if (!expect.isEquals() && expect.isNumericType()) {
            b1 = new BigDecimal(s1);
            b2 = new BigDecimal(s2);
        }
        switch (expect) {
            case equals: {
                return s1.equals(s2);
            }
            case match: {
                return s1.matches(s2);
            }
            case contain: {
                return s1.indexOf(s2) >= 0;
            }
            case greater_equal: {
                System.out.println("b1=" + b1);
                System.out.println("b2=" + b2);
                System.out.println("bc=" + b1.compareTo(b2));
                return b1.compareTo(b2) >= 0;
            }
            case greater_than: {
                return b1.compareTo(b2) > 0;
            }
            case less_equal: {
                return b1.compareTo(b2) <= 0;
            }
            case less_than: {
                return b1.compareTo(b2) < 0;
            }
        }
        return false;
    }

    private String clickUsingScript(WebDriverBackedSelenium selenium, WebDriver driver, WebElement element, Action click_pattern) {
        String message = null;
        System.out.println("click\u7e3a\u52b1\u222a\u7e5d\uff7c\u7e3a\ufffd" + element);
        if (driver instanceof JavascriptExecutor) {
            String script = "var clickEvt = document.createEvent('MouseEvents'); var es = ''; try {clickEvt.initEvent('click', true, false); arguments[0].dispatchEvent(clickEvt); } catch(e){ es = e; } return es;";
            message = (String)((JavascriptExecutor)driver).executeScript(script, new Object[]{element});
            System.out.println("click\u7e3a\u52b1\u25c6\u7e3a\u4ee3\u25b2\u7e3a\u4e5d\ufffd\uff6e\u7e5d\uff61\u7e5d\ufffd\u7e67\uff7b\u7e5d\uff7c\u7e67\uff78\u7e3a\uff6f[" + message + "]");
            if (message != null && message.length() == 0) {
                message = null;
            }
            if (!StringUtil.isEmpty((Object)message)) {
                fLogger.error((Object)message);
            }
        }
        System.out.println("click\u7e3a\u52b1\u25c6\u7e3a\u4ee3\u25b2\u7e3a\u4e5d\ufffd\uff6e\u8b5b\ufffd\u90a8\u3089\u566a\u7e3a\uff6a\u7e5d\uff61\u7e5d\ufffd\u7e67\uff7b\u7e5d\uff7c\u7e67\uff78\u7e3a\uff6f[" + message + "]");
        return message;
    }

    public void clickOrMouseOver(WebDriverBackedSelenium selenium, WebDriver driver, WebElement element, Action click_pattern) {
        switch (click_pattern) {
            case click: {
                if (driver instanceof InternetExplorerDriver) {
                    boolean general_click_flg = false;
                    try {
                        String tag_name = element.getTagName().toLowerCase();
                        if ("input".equals(tag_name)) {
                            String type = element.getAttribute("type").toLowerCase();
                            if ("checkbox".equals(type) || "radio".equals(type) || "button".equals(type)) {
                                general_click_flg = true;
                            }
                        } else if ("li".equals(tag_name) || "div".equals(tag_name) || "span".equals(tag_name) || "tr".equals(tag_name)) {
                            general_click_flg = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (general_click_flg) {
                        if (this.clickUsingScript(selenium, driver, element, click_pattern) == null) break;
                        Actions action = new Actions(driver);
                        action.click(element).build().perform();
                        break;
                    }
                    Actions actions = new Actions(driver);
                    actions.moveToElement(element);
                    actions.sendKeys(new CharSequence[]{Keys.CONTROL});
                    actions.build().perform();
                    this.sleep(100);
                    element.sendKeys(new CharSequence[]{Keys.ENTER});
                    this.sleep(100);
                    break;
                }
                if (driver instanceof ChromeDriver) {
                    if (this.clickUsingScript(selenium, driver, element, click_pattern) == null) break;
                    Actions actions = new Actions(driver);
                    actions.moveToElement(element);
                    actions.click();
                    actions.build().perform();
                    break;
                }
                Actions actions = new Actions(driver);
                actions.moveToElement(element);
                actions.click();
                actions.build().perform();
                break;
            }
            case doubleClick: {
                if (driver instanceof InternetExplorerDriver) {
                    if (driver instanceof JavascriptExecutor) {
                        String script = "var clickEvt = document.createEvent('MouseEvents'); var es = ''; try {clickEvt.initEvent('dblclick', true, false); arguments[0].dispatchEvent(clickEvt); } catch(e){ es = e; } return es;";
                        Object o = ((JavascriptExecutor)driver).executeScript(script, new Object[]{element});
                        if (StringUtil.isEmpty((Object)o)) break;
                        fLogger.error(o);
                        break;
                    }
                    Actions actions = new Actions(driver);
                    actions.moveToElement(element);
                    actions.doubleClick();
                    actions.build().perform();
                    break;
                }
                Actions actions = new Actions(driver);
                actions.moveToElement(element);
                actions.doubleClick();
                actions.build().perform();
                break;
            }
            case contextClick: {
                if (driver instanceof InternetExplorerDriver) {
                    if (driver instanceof JavascriptExecutor) {
                        String script = "var clickEvt = document.createEvent('MouseEvents'); var es = ''; try {clickEvt.initEvent('contextmenu', true, false); arguments[0].dispatchEvent(clickEvt); } catch(e){ es = e; } return es;";
                        Object o = ((JavascriptExecutor)driver).executeScript(script, new Object[]{element});
                        System.out.println("-------------- o= " + o);
                        if (StringUtil.isEmpty((Object)o)) break;
                        fLogger.error(o);
                        break;
                    }
                    Actions actions = new Actions(driver);
                    actions.moveToElement(element);
                    actions.contextClick();
                    actions.build().perform();
                    break;
                }
                Actions actions = new Actions(driver);
                actions.moveToElement(element);
                actions.contextClick();
                actions.build().perform();
            }
        }
    }

    private boolean isChromeDateElement(WebDriver driver, WebElement web_element) {
        String type;
        return driver instanceof ChromeDriver && "input".equalsIgnoreCase(web_element.getTagName()) && ("date".equalsIgnoreCase(type = web_element.getAttribute("type")) || "month".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type) || type.indexOf("datetime") >= 0);
    }

    public void sendKeys(WebDriverBackedSelenium selenium, WebDriver driver, HSSFRow row, WebElement web_element, String s1, String s2, File evidence_top_folder, String desc_for_file, Action action, TestCaseResult case_result, boolean is_set_date_or_time) {
        String parameter = s1;
        if (s2 != null) {
            parameter = String.valueOf(parameter) + s2;
        }
        if (this.isMultipleSelector(row)) {
            for (WebElement elm : this.getWebElements(driver, row)) {
                this.highlight(driver, web_element);
                if (this.isChromeDateElement(driver, elm)) {
                    this.sendKeysForDateElement(driver, web_element, parameter);
                } else {
                    elm.clear();
                    elm.sendKeys(new CharSequence[]{parameter});
                }
                case_result.result = Messages.ScenarioRunner_ok;
                if (this.setting.auto_take_pictures && evidence_top_folder != null) {
                    this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
                }
                this.sleep(100);
                this.unHighlight(driver, web_element);
            }
        } else {
            web_element = this.getWebElement(driver, row);
            this.highlight(driver, web_element);
            if (this.isChromeDateElement(driver, web_element)) {
                this.sendKeysForDateElement(driver, web_element, parameter);
            } else {
                web_element.clear();
                web_element.sendKeys(new CharSequence[]{parameter});
            }
            case_result.result = Messages.ScenarioRunner_ok;
            if (this.setting.auto_take_pictures && evidence_top_folder != null) {
                this.takeScreenShot(action, driver, new File(evidence_top_folder, desc_for_file), false);
            }
            this.unHighlight(driver, web_element);
        }
    }

    private void sendKeysForDateElement(WebDriver driver, WebElement element, String parameter) {
        element.sendKeys(new CharSequence[]{Keys.DELETE});
        String type = element.getAttribute("type");
        String step = element.getAttribute("step");
        System.out.println("step=" + step);
        try {
            Robot robot = new Robot();
            if ("date".equalsIgnoreCase(type)) {
                java.sql.Date d = SQLUtil.getDate((String)parameter);
                Actions actions = new Actions(driver);
                actions.moveToElement(element);
                actions.sendKeys(new CharSequence[]{String.valueOf(d.getYear() + 1900)});
                actions.build().perform();
                robot.keyPress(39);
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getMonth() + 1)});
                actions.build().perform();
                robot.keyPress(39);
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getDate())});
                actions.build().perform();
            } else if ("month".equalsIgnoreCase(type)) {
                java.sql.Date d = SQLUtil.getDate((String)parameter);
                Actions actions = new Actions(driver);
                actions.moveToElement(element);
                actions.sendKeys(new CharSequence[]{String.valueOf(d.getYear() + 1900)});
                actions.build().perform();
                robot.keyPress(39);
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getMonth() + 1)});
                actions.build().perform();
            } else if ("time".equalsIgnoreCase(type)) {
                Time d = SQLUtil.getTime((String)parameter);
                Actions actions = new Actions(driver);
                actions.moveToElement(element);
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getHours())});
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getMinutes())});
                if (!StringUtil.isEmpty((Object)step) && StringUtil.parseIntNoneException((String)step, (int)0) % 60 != 0) {
                    actions.sendKeys(new CharSequence[]{String.format("%02d", d.getSeconds())});
                }
                actions.build().perform();
            } else {
                Timestamp d = SQLUtil.getTimeStamp((String)parameter);
                Actions actions = new Actions(driver);
                actions.moveToElement(element);
                actions.sendKeys(new CharSequence[]{String.valueOf(d.getYear() + 1900)});
                actions.build().perform();
                robot.keyPress(39);
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getMonth() + 1)});
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getDate())});
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getHours())});
                actions.sendKeys(new CharSequence[]{String.format("%02d", d.getMinutes())});
                actions.build().perform();
            }
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    private boolean isAlertPresent(WebDriver driver) {
        try {
            return driver.switchTo().alert() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void takeScreenShot(Action action, WebDriver driver, File save_file, boolean is_all) {
        this.takeScreenShot(action, driver, save_file, is_all, false);
    }

    private void takeScreenShot(Action action, WebDriver driver, File save_file, boolean is_all, boolean withoutAlertPresentCheck) {
        boolean force_full_screen = false;
        if (action.isClick() && !withoutAlertPresentCheck) {
            force_full_screen = this.isAlertPresent(driver);
        }
        if (is_all || force_full_screen) {
            try {
                Robot robot = new Robot();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                BufferedImage image = robot.createScreenCapture(new Rectangle(0, 0, screenSize.width, screenSize.height));
                ImageIO.write((RenderedImage)image, "PNG", save_file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (driver instanceof TakesScreenshot) {
            this.sleep(200);
            TakesScreenshot ts = (TakesScreenshot)driver;
            try {
                FileUtils.copyFile((File)((File)ts.getScreenshotAs(OutputType.FILE)), (File)save_file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void scrollTo(WebDriver driver, WebElement elm) {
        try {
            int y = elm.getLocation().y;
            if (y > 30) {
                y -= 30;
            }
            System.out.println("y=" + y);
            ((JavascriptExecutor)driver).executeScript(String.format("window.scrollTo(0,%d);", elm.getLocation().y), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isSkipAll(HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(0);
        if (row == null) {
            return false;
        }
        String def = this.getStringCellValue(row, 2);
        if (StringUtil.isEmpty((Object)def)) {
            return false;
        }
        Matcher m = this.P_SKIP_DEF.matcher(this.getStringCellValue(row, 2));
        if (m.find()) {
            String to_num = m.group(1);
            if (StringUtil.isEmpty((Object)to_num)) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isMultipleSelector(HSSFRow row) {
        String val = this.getStringCellValue(row, 30);
        return "true".equalsIgnoreCase(val) || "1".equals(val);
    }

    private WebElement getWebElement(WebDriver driver, HSSFRow row) {
        By by = this.getBy(row);
        if (by == null) {
            throw new SeleniumException(String.format(Messages.ScenarioRunner_SelectorIsNotSpecified, row.getRowNum()));
        }
        return driver.findElement(by);
    }

    private List<WebElement> getWebElements(WebDriver driver, HSSFRow row) {
        By by = this.getBy(row);
        if (by == null) {
            System.err.println("nothing selector...");
        }
        return driver.findElements(by);
    }

    private By getBy(HSSFRow row) {
        int i = 31;
        while (i <= 38) {
            String val = this.getStringCellValue(row, i);
            if (!StringUtil.isEmpty((Object)val)) {
                switch (i) {
                    case 31: {
                        return By.cssSelector((String)val);
                    }
                    case 32: {
                        return By.className((String)val);
                    }
                    case 33: {
                        return By.id((String)val);
                    }
                    case 34: {
                        return By.name((String)val);
                    }
                    case 35: {
                        return By.tagName((String)val);
                    }
                    case 36: {
                        return By.linkText((String)val);
                    }
                    case 37: {
                        return By.partialLinkText((String)val);
                    }
                    case 38: {
                        return By.xpath((String)val);
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private void sleep(int microtime) {
        try {
            Thread.sleep(microtime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void pause(int pause_time) {
        this.pause_time = pause_time;
    }

    public List<LogEntry> getJSLogs(TestBrowserType browser_type, WebDriver driver) {
        ArrayList<LogEntry> retList = new ArrayList<LogEntry>();
        if (browser_type.isChrome()) {
            try {
                LogEntry now_last_entry = null;
                LogEntries logEntries = driver.manage().logs().get("browser");
                Iterator iterator = logEntries.iterator();
                block4: while (iterator.hasNext()) {
                    LogEntry entry;
                    now_last_entry = entry = (LogEntry)iterator.next();
                    if (this.last_log_entry != null && this.last_log_entry.getTimestamp() <= now_last_entry.getTimestamp()) continue;
                    for (String s : NO_LOG_LIST) {
                        if (entry.getMessage().indexOf(s) > 0) continue block4;
                    }
                    retList.add(entry);
                }
                this.last_log_entry = now_last_entry;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (driver instanceof InternetExplorerDriver) {
            try {
                JavascriptExecutor js_driver = (JavascriptExecutor)driver;
                Object o = js_driver.executeScript("var ret = null; try { ret = JSON.stringify(window.jsErrors); } catch(e){ ret = [e]; } return ret;", new Object[0]);
                if (o != null) {
                    if (o instanceof String) {
                        String json_str = (String)o;
                        JSON json = new JSON();
                        List list = (List)json.parse((CharSequence)json_str);
                        LogEntry now_last_entry = null;
                        block6: for (Map om : list) {
                            LogEntry entry;
                            String message = (String)om.get("m");
                            String url = (String)om.get("url");
                            BigDecimal line = (BigDecimal)om.get("line");
                            String dt = (String)om.get("dt");
                            java.sql.Date d = SQLUtil.getDate((String)dt, (boolean)false);
                            System.out.println("d=" + d);
                            long time = 0L;
                            if (d != null) {
                                time = d.getTime();
                                System.out.println("  time=" + time);
                            }
                            now_last_entry = entry = new LogEntry(Level.SEVERE, time, String.format("%s Line[%03d] %s", url, line.intValue(), message));
                            if (this.last_log_entry != null && this.last_log_entry.getTimestamp() <= now_last_entry.getTimestamp()) continue;
                            for (String s : NO_LOG_LIST) {
                                if (entry.getMessage().indexOf(s) > 0) continue block6;
                            }
                            retList.add(entry);
                        }
                        this.last_log_entry = now_last_entry;
                    } else {
                        System.out.println("oooo instance===" + o.getClass());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retList;
    }

    public static class Counter {
        public int rans;
        public int failures;
        public int errors;
        public int total_cases;
    }

    public class Setting {
        public String base_url;
        public File evidence_output_folder;
        public File scenario_file;
        public boolean auto_take_pictures;
        public boolean take_on_changed_screen;
        public boolean take_on_clicked;
        public boolean take_on_sended_keys;
        public boolean exit_on_failure;
        public Set<TestBrowserType> test_browser_set = new LinkedHashSet<TestBrowserType>();
        public File webdriver_chrome_driver;
        public File webdriver_ie_driver;
        public int num_of_test_case;
        public boolean has_failure;
        public String connection_id;
        public String skip_to_sheet_name;
        public int skip_this_no = -1;
        public String skip_reason;
        public Date start_dt = new Date();
        public String highlight_color;
        public boolean quitting_the_browser_at_end_of_scenario;
    }

    public class TestCaseResult {
        public TestBrowserType browser_type;
        public String sheet_name;
        public String description;
        public String command;
        public String parameter;
        public String status;
        public String inspection_result_of_db;
        public String inspection_result_of_browser;
        public String result;
        public String ctrl_variable;
        private List<LogEntry> log_list;

        public TestCaseResult(TestBrowserType browser_type) {
            this.browser_type = browser_type;
        }

        public List<LogEntry> getLog_list() {
            if (this.log_list == null) {
                return Collections.EMPTY_LIST;
            }
            return this.log_list;
        }

        public void setLog_list(List<LogEntry> log_list) {
            this.log_list = log_list;
        }
    }
}

