/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.yaml;

import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.yaml.Messages;
import hiro.yoshioka.sql.yaml.bean.Case;
import hiro.yoshioka.sql.yaml.bean.ComparisionOperatorType;
import hiro.yoshioka.sql.yaml.bean.Entry;
import hiro.yoshioka.sql.yaml.bean.ExecuteTimingType;
import hiro.yoshioka.sql.yaml.bean.ResultExpect;
import hiro.yoshioka.sql.yaml.bean.ResultSetValidatorType;
import hiro.yoshioka.sql.yaml.bean.TestPatternType;
import hiro.yoshioka.util.StringUtil;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class YamlTestWizard
extends Wizard {
    Entry entry;

    public YamlTestWizard(Entry entry) {
        this.entry = entry;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        ArrayList<Case> caseList = new ArrayList<Case>();
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            CasePage casePage;
            Case caze;
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof CasePage && (caze = (casePage = (CasePage)page).getCase()) != null) {
                caseList.add(caze);
            }
            ++n2;
        }
        this.entry.cases = caseList.toArray(new Case[caseList.size()]);
        return true;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        try {
            System.out.println("next=" + nextPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nextPage;
    }

    public void addPages() {
        try {
            Case caze;
            ChoiceTestPatternPage page0 = new ChoiceTestPatternPage();
            this.addPage((IWizardPage)page0);
            ConditionPage page1 = new ConditionPage();
            this.addPage((IWizardPage)page1);
            int i = 1;
            Case[] caseArray = this.getEntry().getCases();
            int n = caseArray.length;
            int n2 = 0;
            while (n2 < n) {
                caze = caseArray[n2];
                this.addPage((IWizardPage)new CasePage(i, caze));
                ++i;
                ++n2;
            }
            while (i <= 5) {
                caze = new Case();
                this.addPage((IWizardPage)new CasePage(i, caze));
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private Text addTextWithLabel(Composite c, String title, String textPlaceHolder, int style) {
        Label lb = new Label(c, 0);
        lb.setText(title);
        Text text = new Text(c, style);
        if (!StringUtil.isEmpty((Object)textPlaceHolder)) {
            text.setMessage(textPlaceHolder);
        }
        GridData gd = new GridData(768);
        if ((style & 2) == 2) {
            gd.minimumHeight = 100;
            gd.heightHint = 100;
        }
        text.setLayoutData((Object)gd);
        return text;
    }

    private Spinner addSpinnerWithLabel(Composite c, String title, int defaultValue) {
        Label lb = new Label(c, 0);
        lb.setText(title);
        Spinner spinner = new Spinner(c, 0);
        spinner.setSelection(defaultValue);
        spinner.setLayoutData((Object)new GridData(768));
        return spinner;
    }

    private Combo addComboWithLabel(Composite c, String title) {
        Label lb = new Label(c, 0);
        lb.setText(title);
        Combo combo = new Combo(c, 8);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    private List addListWithLabel(Composite c, String title, int types) {
        Label lb = new Label(c, 0);
        lb.setText(title);
        List list = new List(c, types);
        list.setLayoutData((Object)new GridData(768));
        return list;
    }

    private Group addGroupWithLabel(Composite c, String title) {
        Group group = new Group(c, 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        group.setLayoutData((Object)layoutData);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(title);
        return group;
    }

    class CasePage
    extends WizardPage {
        private String INPUT_MESSAGE;
        private String INPUT_OPERATOR_MESSAGE;
        Text titleTxt;
        Text sql_statementTxt;
        Text txtExpectedValue;
        Label targetCellLbl;
        Label explainCellLbl;
        Spinner targetRowSpin;
        Spinner targetColSpin;
        Combo validatorCombo;
        Combo operatorCombo;
        ResultSetValidatorType validatorType;
        ComparisionOperatorType operatorType;
        private boolean extra;
        Case caze;
        ResultExpect expect;

        protected CasePage(int num, Case caze) {
            super(Messages.YamlTestWizard_CaseSetting);
            this.INPUT_MESSAGE = Messages.YamlTestWizard_PleaseInputTestCaseTitle;
            this.INPUT_OPERATOR_MESSAGE = Messages.YamlTestWizard_PleaseSelectComparisionOperator;
            this.validatorType = ResultSetValidatorType.None;
            this.caze = caze;
            this.expect = caze.result_expects[0];
            this.setTitle(String.format(Messages.YamlTestWizard_TestCaseSetting, num));
            this.extra = num > 1;
        }

        Case getCase() {
            this.caze.title = this.titleTxt.getText();
            if (StringUtil.isEmpty((Object)this.caze.title)) {
                return null;
            }
            this.caze.sql_statement = this.sql_statementTxt.getText();
            if (this.validatorType.isNone()) {
                this.caze.clearResultExpect();
                return this.caze;
            }
            ResultExpect expect = new ResultExpect();
            expect.type = this.validatorType.name();
            expect.setOperator_type(this.operatorType);
            expect.rowcol = String.format("%d:%d", this.targetRowSpin.getSelection(), this.targetColSpin.getSelection());
            expect.setValue(this.txtExpectedValue.getText());
            this.caze.result_expects = new ResultExpect[]{expect};
            return this.caze;
        }

        public void createControl(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            Group basicGroup = YamlTestWizard.this.addGroupWithLabel(c, Messages.YamlTestWizard_Basic);
            this.validatorCombo = YamlTestWizard.this.addComboWithLabel((Composite)basicGroup, Messages.YamlTestWizard_Type);
            ResultSetValidatorType[] resultSetValidatorTypeArray = ResultSetValidatorType.values();
            int n = resultSetValidatorTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResultSetValidatorType vType = resultSetValidatorTypeArray[n2];
                this.validatorCombo.add(vType.getMessage());
                this.validatorCombo.setData(vType.getMessage(), (Object)vType);
                ++n2;
            }
            this.validatorCombo.select(this.expect.getResultSetValidatorType().ordinal());
            this.validatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CasePage.this.resetOperatorCombo();
                    CasePage.this.resetExpectedTextEnabled();
                }
            });
            this.titleTxt = YamlTestWizard.this.addTextWithLabel((Composite)basicGroup, Messages.YamlTestWizard_Title, Messages.YamlTestWizard_InputTestCaseTitle_message, 4);
            this.titleTxt.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    CasePage.this.validate();
                }
            });
            this.titleTxt.setText(this.caze.getTitle());
            this.sql_statementTxt = YamlTestWizard.this.addTextWithLabel((Composite)basicGroup, Messages.YamlTestWizard_SQLStatement, Messages.YamlTestWizard_Inputsqlstatement_message, 770);
            this.sql_statementTxt.setText(this.caze.getSqlStatement());
            Group expectedResultGroup = YamlTestWizard.this.addGroupWithLabel(c, Messages.YamlTestWizard_24);
            ((GridLayout)expectedResultGroup.getLayout()).numColumns = 4;
            this.targetCellLbl = new Label((Composite)expectedResultGroup, 0);
            this.targetCellLbl.setText("Target Cell");
            this.explainCellLbl = new Label((Composite)expectedResultGroup, 0);
            this.explainCellLbl.setText("set target cell posion");
            this.targetRowSpin = this.createSpin((Composite)expectedResultGroup, "Row Position:");
            this.targetColSpin = this.createSpin((Composite)expectedResultGroup, "Column Position:");
            this.operatorCombo = YamlTestWizard.this.addComboWithLabel((Composite)expectedResultGroup, Messages.YamlTestWizard_25);
            this.resetOperatorCombo();
            this.operatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CasePage.this.operatorType = (ComparisionOperatorType)CasePage.this.operatorCombo.getData(CasePage.this.operatorCombo.getText());
                }
            });
            this.operatorCombo.select(this.expect.getOperatorType().ordinal());
            this.operatorType = (ComparisionOperatorType)this.operatorCombo.getData(this.operatorCombo.getText());
            this.txtExpectedValue = YamlTestWizard.this.addTextWithLabel((Composite)expectedResultGroup, "expected value:", "<input expected value>", 4);
            if (this.expect.hasRowCol()) {
                Integer col;
                Integer row = this.expect.getExpectedRow();
                if (row != null) {
                    this.targetRowSpin.setSelection(row.intValue());
                }
                if ((col = this.expect.getExpectedCol()) != null) {
                    this.targetColSpin.setSelection(col.intValue());
                }
            }
            this.txtExpectedValue.setText(StringUtil.nvl((Object)this.expect.getValue()));
            this.validate();
            this.resetExpectedTextEnabled();
            this.setControl((Control)c);
        }

        private Spinner createSpin(Composite parent, String lbText) {
            Composite p = new Composite(parent, 0);
            p.setLayout((Layout)new FillLayout());
            new Label(p, 0).setText(lbText);
            Spinner spin = new Spinner(p, 0);
            spin.setValues(1, 1, 1000000, 0, 1, 5);
            return spin;
        }

        private void resetExpectedTextEnabled() {
            this.validatorType = (ResultSetValidatorType)this.validatorCombo.getData(this.validatorCombo.getText());
            if (this.validatorType != null && this.validatorType.isNone()) {
                this.txtExpectedValue.setEnabled(false);
            } else {
                this.txtExpectedValue.setEnabled(true);
            }
        }

        private void resetOperatorCombo() {
            this.operatorCombo.removeAll();
            this.validatorType = (ResultSetValidatorType)this.validatorCombo.getData(this.validatorCombo.getText());
            for (ComparisionOperatorType cType : ComparisionOperatorType.get((ResultSetValidatorType)this.validatorType)) {
                this.operatorCombo.add(cType.getTypeString());
                this.operatorCombo.setData(cType.getTypeString(), (Object)cType);
            }
        }

        private void validate() {
            if (this.isPageComplete()) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        }

        public boolean isPageComplete() {
            if (this.titleTxt == null || this.titleTxt.getText().trim().length() == 0) {
                if (this.extra) {
                    return true;
                }
                this.setErrorMessage(this.INPUT_MESSAGE);
                return false;
            }
            if (this.validatorType != ResultSetValidatorType.None && this.operatorCombo.getSelectionIndex() < 0) {
                this.setErrorMessage(this.INPUT_OPERATOR_MESSAGE);
            }
            return true;
        }
    }

    class ChoiceTestPatternPage
    extends WizardPage
    implements SelectionListener {
        protected ChoiceTestPatternPage() {
            super("Test Type");
        }

        public void createControl(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            TestPatternType[] testPatternTypeArray = TestPatternType.values();
            int n = testPatternTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestPatternType pattern = testPatternTypeArray[n2];
                Button bt = new Button(c, 16);
                bt.setText(pattern.getMessage());
                bt.setData((Object)pattern);
                bt.addSelectionListener((SelectionListener)this);
                bt.setSelection(true);
                ++n2;
            }
            this.setMessage(Messages.YamlTestWizard_PleaseChooseATestPattern, 1);
            this.setControl((Control)c);
        }

        public boolean isPageComplete() {
            return YamlTestWizard.this.getEntry().testPattern != null;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TestPatternType pType = (TestPatternType)((Button)e.widget).getData();
            this.setErrorMessage(null);
            this.setMessage(pType.getDescription(), 1);
            YamlTestWizard.this.getEntry().testPattern = pType;
            this.setPageComplete(true);
        }
    }

    class ConditionPage
    extends WizardPage {
        private String INPUT_MESSAGE;
        private String SELECT_CON_MESSAGE;
        Text titleTxt;
        Combo execTimingCombo;
        Spinner totalTimeLimit;
        Combo conCombo;

        protected ConditionPage() {
            super(Messages.YamlTestWizard_ConditionSetting);
            this.INPUT_MESSAGE = Messages.YamlTestWizard_PleaseInputProjectTitle;
            this.SELECT_CON_MESSAGE = Messages.YamlTestWizard_PleaseSelectConnectionDef;
        }

        public void createControl(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            Group basicGroup = YamlTestWizard.this.addGroupWithLabel(c, Messages.YamlTestWizard_Basic);
            this.setTitle(Messages.YamlTestWizard_ProjectSetting);
            this.titleTxt = YamlTestWizard.this.addTextWithLabel((Composite)basicGroup, Messages.YamlTestWizard_Title, Messages.YamlTestWizard_InputProjectTitle_message, 4);
            if (YamlTestWizard.this.getEntry().hasProjectTitle()) {
                this.titleTxt.setText(YamlTestWizard.this.getEntry().title);
            }
            this.titleTxt.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (ConditionPage.this.isPageComplete()) {
                        ConditionPage.this.setPageComplete(true);
                    }
                }
            });
            this.totalTimeLimit = YamlTestWizard.this.addSpinnerWithLabel((Composite)basicGroup, Messages.YamlTestWizard_totalTimeLimit, 5000);
            this.totalTimeLimit.setMinimum(0);
            this.totalTimeLimit.setMaximum(1800000);
            try {
                this.totalTimeLimit.setSelection((int)YamlTestWizard.this.getEntry().totalTimeLimit);
            }
            catch (Exception exception) {}
            this.execTimingCombo = YamlTestWizard.this.addComboWithLabel((Composite)basicGroup, Messages.YamlTestWizard_ExecuteTiming);
            ExecuteTimingType[] executeTimingTypeArray = ExecuteTimingType.values();
            int n = executeTimingTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecuteTimingType eTiming = executeTimingTypeArray[n2];
                this.execTimingCombo.add(eTiming.getMessage());
                this.execTimingCombo.setData(eTiming.getMessage(), (Object)eTiming);
                ++n2;
            }
            this.execTimingCombo.select(YamlTestWizard.this.getEntry().getExecuteTimingType().ordinal());
            Group connectionGroup = YamlTestWizard.this.addGroupWithLabel(c, Messages.YamlTestWizard_ConnectionDef);
            this.conCombo = YamlTestWizard.this.addComboWithLabel((Composite)connectionGroup, Messages.YamlTestWizard_use_con_disp);
            for (ConnectionProperties prop : SQLServerThread.getSQLServer().getConnectionList()) {
                this.conCombo.add(prop.getDisplayString());
                if (!YamlTestWizard.this.getEntry().getSetup().getUse_con_disp().equals(prop.getDisplayString())) continue;
                this.conCombo.select(this.conCombo.getItemCount() - 1);
            }
            this.conCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ConditionPage.this.isPageComplete()) {
                        ConditionPage.this.setPageComplete(true);
                    }
                }
            });
            this.isPageComplete();
            this.setControl((Control)c);
        }

        public IWizardPage getNextPage() {
            YamlTestWizard.this.getEntry().title = this.titleTxt.getText();
            YamlTestWizard.this.getEntry().execute_timing = this.execTimingCombo.getText();
            YamlTestWizard.this.getEntry().totalTimeLimit = this.totalTimeLimit.getSelection();
            YamlTestWizard.this.getEntry().getSetup().setUse_con_disp(this.conCombo.getText());
            return super.getNextPage();
        }

        public boolean isPageComplete() {
            if (this.titleTxt == null || this.titleTxt.getText().trim().length() == 0) {
                this.setErrorMessage(this.INPUT_MESSAGE);
                return false;
            }
            if (this.conCombo.getSelectionIndex() < 0) {
                this.setErrorMessage(this.SELECT_CON_MESSAGE);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
    }
}

