/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sql.resource.DBResource;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.view.DBResourceTreeSelection;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.Util;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DBRTreeToClipAction
extends Action
implements ISelectionChangedListener {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ExplorerView fView;
    String fSeparator = ", ";
    boolean aliasMode;
    AliasHelper fHelper;
    DBResourceTreeSelection fSelection;
    DBResource fSelectionResource;
    boolean fTextExtension;
    boolean fQuotDBSelected;

    public DBRTreeToClipAction(ExplorerView view, String separator) {
        this.fView = view;
        this.fSeparator = separator;
    }

    public void configureAction(String text, String toolTipText, ImageDescriptor image) {
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(image);
    }

    protected static String quotString(String str, boolean quot) {
        if (quot) {
            return String.format("\"%s\"", str);
        }
        return str;
    }

    protected String getSelectionString() {
        this.fHelper = new AliasHelper();
        StringBuffer buf = new StringBuffer();
        Tree tree = this.fView.getTreeViewer().getTree();
        TreeItem[] items = tree.getSelection();
        int i = 0;
        while (i < items.length) {
            this.fHelper.addResource((DBResource)items[i].getData());
            ++i;
        }
        i = 0;
        while (i < items.length) {
            DBResource item = (DBResource)items[i].getData();
            String name = "";
            name = this.aliasMode ? String.valueOf(this.fHelper.getAlias(items[i].getData())) + item.getName().replaceAll("\\p{Cntrl}", "") : String.valueOf(this.fHelper.getAlias(items[i].getData())) + item.getNameWithComment().replaceAll("\\p{Cntrl}", "");
            buf.append(name);
            buf.append(this.fSeparator);
            ++i;
        }
        buf.setLength(buf.length() - this.fSeparator.length());
        return buf.toString();
    }

    public void run() {
        String string = this.getSelectionString();
        this.setContents(string);
    }

    protected void setContents(String copyTo) {
        try {
            Util.getClipboard().setContents(new Object[]{copyTo}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        try {
            this.fSelection = (DBResourceTreeSelection)this.fView.getTreeViewer().getSelection();
            this.setEnabled(true);
            this.selectionChangedAfter();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void selectionChangedAfter() {
    }

    class AliasHelper {
        ArrayList<IDBResource> fTableList = new ArrayList();

        AliasHelper() {
        }

        public void addResource(DBResource resource) {
            if (DBRTreeToClipAction.this.fSelection.getFirstDBResource() instanceof IDBColumn) {
                if (!this.fTableList.contains(resource.getParent())) {
                    this.fTableList.add(resource.getParent());
                }
            } else if (DBRTreeToClipAction.this.fSelection.getFirstDBResource() instanceof IDBTable) {
                this.fTableList.add((IDBResource)resource);
            }
        }

        public String getAlias(Object resource) {
            if (this.fTableList.size() == 1 || !(resource instanceof DBResource)) {
                return "";
            }
            return "TBL" + this.fTableList.indexOf(((DBResource)resource).getParent()) + ".";
        }

        private String preSchemaString(IDBResource table) {
            String schemaString = table.getParent().getUName();
            if (schemaString.trim().length() == 0) {
                return "";
            }
            return "";
        }

        public String getTables(boolean quot) {
            IDBResource res = null;
            StringBuffer buf = new StringBuffer();
            if (this.fTableList.size() == 1) {
                res = this.fTableList.get(0);
                return String.valueOf(this.preSchemaString(res)) + DBRTreeToClipAction.quotString(res.getName(), quot);
            }
            int i = 0;
            while (i < this.fTableList.size()) {
                if (i >= 1) {
                    buf.append(", ");
                }
                res = this.fTableList.get(i);
                buf.append(String.valueOf(this.preSchemaString(res)) + DBRTreeToClipAction.quotString(res.getName(), quot)).append(" ").append("TBL").append(i);
                ++i;
            }
            return buf.toString();
        }

        public IDBTable getFirsTable() {
            if (this.fTableList.size() > 0) {
                return (IDBTable)this.fTableList.get(0);
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":" + this.fTableList;
        }
    }
}

