/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;

public class HsqlServerManager {
    static Log log = LogFactory.getLog(HsqlServerManager.class);
    private static HsqlServerManager single;
    private static Server server;

    static {
        server = new Server();
        PrintWriter normal = new PrintWriter(new MyWriter(true));
        server.setLogWriter(normal);
        PrintWriter err = new PrintWriter(new MyWriter(false));
        server.setErrWriter(err);
    }

    private HsqlServerManager() {
    }

    public static HsqlServerManager getInstance() {
        if (single == null) {
            single = new HsqlServerManager();
        }
        return single;
    }

    public void start() {
        if (!HsqlServerManager.isRunning()) {
            log.info((Object)"exec start");
            server.setDatabaseName(0, "hsql_db_yon");
            server.setDatabasePath(0, "file:hsql_db_yon");
            server.setPort(PreferenceUtil.getInt("HSQL_PORT"));
            server.setSilent(true);
            server.start();
        }
    }

    public void stop() {
        log.info((Object)"exec stop");
        HsqlServerManager.shutDownServer();
    }

    public static boolean isRunning() {
        if (server == null) {
            return false;
        }
        return server.getState() <= 4;
    }

    public static void dispose() {
        HsqlServerManager.shutDownServer();
    }

    private static void shutDownServer() {
        try {
            if (server != null) {
                server.shutdown();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static class MyWriter
    extends Writer {
        public boolean isNormal;

        public MyWriter(boolean isNormal) {
            this.isNormal = isNormal;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String target = new String(cbuf, off, len).trim();
            if (StringUtil.isEmpty((Object)target)) {
                return;
            }
            if (this.isNormal) {
                log.info((Object)target);
            } else {
                log.warn((Object)target);
            }
        }
    }
}

