/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.sql.ui.editor.action.Messages;
import hiro.yoshioka.sql.util.SQLHistroyManager;
import hiro.yoshioka.ui.action.AbsWorkbenchSQLEditorAction;
import hiro.yoshioka.ui.view.ResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.Date;
import org.eclipse.swt.widgets.Display;

public class NativeDBExecuteAction
extends AbsWorkbenchSQLEditorAction {
    SQLOperationType iOperation;

    public NativeDBExecuteAction(int style, SQLOperationType operation) {
        super(style);
        this.iOperation = operation;
    }

    @Override
    public void update() {
    }

    @Override
    public void execute(SQLEditor editor, ConnectionProperties p) throws Exception {
        TransactionRequest req = new TransactionRequest(this.iOperation, p, "");
        req.setPartName("NativeDBExecute");
        req.addListener((IRequestListener)new TableShowRequest(req));
        SQLServerThread.putRequest((Request)req);
    }

    class TableShowRequest
    extends RequestAdaptor
    implements Runnable {
        TransactionRequest fTransactionRequest;

        public TableShowRequest(TransactionRequest req) {
            this.fTransactionRequest = req;
        }

        public void called_pre(Request request, SQLOperationType operation) {
            Application.setStatus(String.format("Start[%tT]", new Date()));
        }

        public void called_done(Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
            Application.exec(this);
            Application.setStatus(String.format("End[%tT]", new Date()));
        }

        @Override
        public void run() {
            if (this.fTransactionRequest.getException() != null) {
                Application.openErrorDialog(Display.getCurrent().getActiveShell(), Messages.getString("SQLError"), this.fTransactionRequest.getException());
            }
            if (this.fTransactionRequest.getRdh() == null) {
                NativeDBExecuteAction.this.fLogger.warn((Object)"fTransactionRequest.getRdh() = null");
                return;
            }
            SQLHistroyManager.getInstance().addStatement(this.fTransactionRequest);
            ResultSetView part = null;
            try {
                part = NativeDBExecuteAction.this.iOperation == SQLOperationType.SELECT_SESSION ? (ResultSetView)Application.showAndCreateSessionView() : Application.showAndCreateRstView(this.fTransactionRequest.getTitle());
            }
            catch (Exception e) {
                Application.openErrorDialog(null, "error", e);
            }
            part.setPartName(this.fTransactionRequest.getTitle());
            part.setInput((Request)this.fTransactionRequest);
        }
    }
}

