/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.chart.ChartInfo;
import hiro.yoshioka.chart.PieChartInfo;
import hiro.yoshioka.chart.TimeChartInfo;
import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.IRDHHyperLinkAction;
import hiro.yoshioka.sdh.RDHTableViewer;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.util.CommentInfo;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.ui.view.internal.AbstractChartBuilder;
import hiro.yoshioka.ui.view.internal.ChartCanvas;
import hiro.yoshioka.ui.view.internal.DateTimeChartBuilder;
import hiro.yoshioka.ui.view.internal.PieChartBuilder;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ChartResultSetView
extends SingleResultSetView {
    protected RDHTableViewer fViewer;
    public static final String ID = "ChartResultSetViewID";
    private Composite fChartComposite;
    Calendar c = Calendar.getInstance();
    SashForm sash;
    private boolean isFirstView = true;
    ArrayList<Composite> gList = new ArrayList();

    @Override
    public int[] getSelectionIndices() {
        return this.fViewer.getTable().getSelectionIndices();
    }

    public void dispose() {
        this.resetResultSetLists();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.sash = new SashForm(parent, 256);
        this.fViewer = new RDHTableViewer((Composite)this.sash, 268536578);
        this.fChartComposite = new Composite((Composite)this.sash, 2048);
        this.fChartComposite.setLayout((Layout)new FillLayout(512));
    }

    public void setInput(ResultSetDataHolder2 o, CommentInfo comInfo) {
        this.comInfo = comInfo;
        this.fViewer.setSupportHyperLink(null);
        List chartList = comInfo.getChartList();
        if (chartList.size() == 0) {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.sash.setWeights(nArray);
        } else {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.sash.setWeights(nArray);
            int i = 0;
            while (i < this.gList.size()) {
                this.gList.get(i).dispose();
                ++i;
            }
            for (ChartInfo ci : chartList) {
                ci.rdh = o;
                Chart chart = this.createChart(ci);
                ChartCanvas canvas = new ChartCanvas(this.fChartComposite, 0);
                canvas.setChart(chart);
                canvas.setSize(800, 600);
                this.gList.add((Composite)canvas);
            }
            Display.getCurrent().timerExec(500, new Runnable(){

                @Override
                public void run() {
                    try {
                        ChartResultSetView.this.sash.setWeights(new int[]{60, 40});
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        this.fViewer.setSupportChart(false);
        if (comInfo != null) {
            this.fViewer.setSupportChart(comInfo.supportBarGraph);
            this.fViewer.setMaxMultiLine(comInfo.supportMultiLine);
            if (comInfo.hasOnClickEvent()) {
                this.fViewer.setSupportHyperLink((IRDHHyperLinkAction)comInfo.createHyperLinkToProgramLaunchAction());
            }
        }
        this.fResultSetDataHolder = o;
        if (o == null) {
            this.fViewer.setInput(null);
            return;
        }
        if (this.fResultSetDataHolder.isForUpdate()) {
            int i = 0;
            while (i < 10) {
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                ++i;
            }
        }
        if (this.isFirstView) {
            this.isFirstView = false;
            Application.setEnableAction(this, "ResultSetReflectActionID", this.fResultSetDataHolder.isForUpdate());
        }
        this.fViewer.setInputAdjustDatum((ResultSetDataHolder)this.fResultSetDataHolder);
        Application.setEnableAction(this, "ResultSet2InsertScriptID", this.fResultSetDataHolder.hasResultSetMetaData());
        Application.setStatus("estimatedTime[" + this.fResultSetDataHolder.getFormattedWrapTime() + "sec]");
        this.resetResultSetLists();
    }

    private Chart createChart(ChartInfo chartInfo) {
        AbstractChartBuilder builder = chartInfo instanceof PieChartInfo ? new PieChartBuilder((PieChartInfo)chartInfo) : new DateTimeChartBuilder((TimeChartInfo)chartInfo);
        builder.build();
        return builder.getChart();
    }

    public void setFocus() {
        this.fChartComposite.setFocus();
        this.fViewer.getTable().setFocus();
    }

    @Override
    public void selectAll() {
        this.fViewer.doOperation(6);
    }

    @Override
    public void adjustDatum() {
        this.fViewer.setInputAdjustDatum((ResultSetDataHolder)this.fResultSetDataHolder);
    }

    @Override
    public void adjustHeader() {
        this.fViewer.setInputAdjustHeader((ResultSetDataHolder)this.fResultSetDataHolder);
    }

    @Override
    public void adjustArea() {
        this.fViewer.setInputAdjustArea((CSVRecordDataHolder)this.fResultSetDataHolder);
    }

    @Override
    void lostFocus() {
    }
}

