/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.sql.util.SQLHistoryData;
import hiro.yoshioka.sql.util.SQLHistroyManager;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class HistoryView
extends ViewPart {
    public static final String ID = "HistoryViewID";
    static String[] TITLE = new String[]{"\u24ca", "ConnectionDisplay", "Date", "Time", "SQLStatement", "TABLE", "BIND", "CALLS", "ReturnedRow"};
    static int[] WIDTH = new int[]{33, 60, 80, 70, 305, 75, 75, 50, 50};
    SashForm sash;
    Text sqlStatementTxt;
    TableViewer tableViewer;
    Text filterText;

    public void clearSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        SQLHistroyManager manager = SQLHistroyManager.getInstance();
        Iterator ite = sel.iterator();
        while (ite.hasNext()) {
            manager.remove((SQLHistoryData)ite.next());
        }
        this.resetHistory();
    }

    public void createPartControl(Composite parent) {
        this.sash = new SashForm(parent, 256);
        this.tableViewer = new TableViewer((Composite)this.sash, 67586);
        this.tableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        int i = 0;
        while (i < TITLE.length) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setWidth(WIDTH[i]);
            column.getColumn().setText(TITLE[i]);
            column.getColumn().setMoveable(true);
            column.setLabelProvider((CellLabelProvider)new MyComulnProvider(i));
            new ColumnViewerSorter((ColumnViewer)this.tableViewer, column, i){

                @Override
                protected int doCompare(Viewer viewer, Object e1, Object e2) {
                    SQLHistoryData h1 = (SQLHistoryData)e1;
                    SQLHistoryData h2 = (SQLHistoryData)e2;
                    switch (this.idx) {
                        case 1: 
                        case 2: {
                            int ret = StringUtil.nvl((Object)h1.getDay()).compareTo(StringUtil.nvl((Object)h2.getDay()));
                            if (ret == 0) {
                                return StringUtil.nvl((Object)h1.getTime()).compareTo(StringUtil.nvl((Object)h2.getTime()));
                            }
                            return ret;
                        }
                        case 3: {
                            String s1 = StringUtil.nvl((Object)h1.getSQLStatement().trim().toUpperCase());
                            String s2 = StringUtil.nvl((Object)h2.getSQLStatement().trim().toUpperCase());
                            return s1.compareTo(s2);
                        }
                        case 4: {
                            return StringUtil.nvl((Object)h1.getTableName()).compareTo(StringUtil.nvl((Object)h2.getTableName()));
                        }
                        case 5: {
                            return StringUtil.nvl((Object)h1.getBindData()).compareTo(StringUtil.nvl((Object)h2.getBindData()));
                        }
                        case 6: {
                            return StringUtil.nvl((Object)h1.getCalls()).compareTo(StringUtil.nvl((Object)h2.getCalls()));
                        }
                    }
                    return 0;
                }
            };
            ++i;
        }
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)HistoryView.this.tableViewer.getSelection();
                SQLHistoryData data = (SQLHistoryData)sel.getFirstElement();
                if (data != null) {
                    HistoryView.this.sqlStatementTxt.setText(data.getSQLStatement());
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)HistoryView.this.tableViewer.getSelection();
                SQLHistoryData data = (SQLHistoryData)sel.getFirstElement();
                SQLEditor sqlEditor = Application.getActiveSQLEditor();
                if (sqlEditor == null) {
                    sqlEditor = Application.openNewSQLEditor(null, data.getDisplayString());
                }
                sqlEditor.setText(data.getSQLStatement());
                sqlEditor.setCanUpdatableMode(data.isUpdatable());
                sqlEditor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), data.getDisplayString());
                sqlEditor.setMaxRowNum(1000);
            }
        });
        Composite rightComposite = new Composite((Composite)this.sash, 2048);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        rightComposite.setLayout((Layout)layout);
        Composite c = new Composite(rightComposite, 2048);
        c.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayout((Layout)gl);
        new Label(c, 0).setText("Filter");
        this.filterText = new Text(c, 2052);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    HistoryView.this.resetHistory(HistoryView.this.filterText.getText().trim());
                }
            }
        });
        this.sqlStatementTxt = new Text(rightComposite, 2562);
        this.sqlStatementTxt.setBackground(ColorConstants.white);
        this.sqlStatementTxt.setLayoutData((Object)new GridData(1808));
        this.sash.setWeights(new int[]{70, 30});
        this.resetHistory();
    }

    public void setFocus() {
    }

    public void resetHistory() {
        this.resetHistory(null);
    }

    public void resetHistory(String text) {
        List list = SQLHistroyManager.getInstance().getHistory(text);
        SQLHistoryData[] arrays = new SQLHistoryData[list.size()];
        int i = 0;
        while (i < list.size()) {
            arrays[i] = (SQLHistoryData)list.get(list.size() - i - 1);
            ++i;
        }
        this.tableViewer.setInput((Object)arrays);
        this.tableViewer.refresh();
        if (list.size() > 0) {
            this.sqlStatementTxt.setText(((SQLHistoryData)list.get(0)).getSQLStatement());
        }
    }

    private static abstract class ColumnViewerSorter
    extends ViewerComparator {
        public static final int ASC = 1;
        public static final int NONE = 0;
        public static final int DESC = -1;
        int idx;
        private int direction = 0;
        private TableViewerColumn column;
        private ColumnViewer viewer;

        public ColumnViewerSorter(ColumnViewer viewer, TableViewerColumn column, int idx) {
            this.column = column;
            this.viewer = viewer;
            this.idx = idx;
            this.column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ColumnViewerSorter.this.viewer.getComparator() != null) {
                        if (ColumnViewerSorter.this.viewer.getComparator() == ColumnViewerSorter.this) {
                            int tdirection = ColumnViewerSorter.this.direction;
                            if (tdirection == 1) {
                                ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, -1);
                            } else if (tdirection == -1) {
                                ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 0);
                            }
                        } else {
                            ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                        }
                    } else {
                        ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                    }
                }
            });
        }

        public void setSorter(ColumnViewerSorter sorter, int direction) {
            if (direction == 0) {
                this.column.getColumn().getParent().setSortColumn(null);
                this.column.getColumn().getParent().setSortDirection(0);
                this.viewer.setComparator(null);
            } else {
                this.column.getColumn().getParent().setSortColumn(this.column.getColumn());
                sorter.direction = direction;
                if (direction == 1) {
                    this.column.getColumn().getParent().setSortDirection(1024);
                } else {
                    this.column.getColumn().getParent().setSortDirection(128);
                }
                if (this.viewer.getComparator() == sorter) {
                    this.viewer.refresh();
                } else {
                    this.viewer.setComparator((ViewerComparator)sorter);
                }
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.direction * this.doCompare(viewer, e1, e2);
        }

        protected abstract int doCompare(Viewer var1, Object var2, Object var3);
    }

    private static class MyComulnProvider
    extends ColumnLabelProvider {
        int colIdx;

        public MyComulnProvider(int idx) {
            this.colIdx = idx;
        }

        public String getText(Object element) {
            SQLHistoryData history = (SQLHistoryData)element;
            switch (this.colIdx) {
                case 0: {
                    return history.isUpdatable() ? "\u24ca" : "";
                }
                case 1: {
                    return history.getDisplayString();
                }
                case 2: {
                    return history.getDay();
                }
                case 3: {
                    return history.getTime();
                }
                case 4: {
                    return history.getSQLStatement();
                }
                case 5: {
                    return history.getTableName();
                }
                case 6: {
                    return history.getBindData();
                }
                case 7: {
                    return "" + history.getCalls();
                }
                case 8: {
                    return "" + history.getReturnedRows();
                }
            }
            return "";
        }
    }

    private class MyContentProvider
    implements IStructuredContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (SQLHistoryData[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

