/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view.internal;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ChartCanvas
extends Canvas {
    protected IDeviceRenderer render = null;
    protected Chart chart = null;
    protected GeneratedChartState state = null;
    private Image cachedImage = null;

    public ChartCanvas(Composite parent, int style) {
        super(parent, style);
        try {
            PluginSettings ps = PluginSettings.instance();
            this.render = ps.getDevice("dv.SWT");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite co = (Composite)e.getSource();
                Rectangle rect = co.getClientArea();
                if (ChartCanvas.this.cachedImage == null) {
                    ChartCanvas.this.buildChart();
                    ChartCanvas.this.drawToCachedImage(rect);
                }
                e.gc.drawImage(ChartCanvas.this.cachedImage, 0, 0, ((ChartCanvas)ChartCanvas.this).cachedImage.getBounds().width, ((ChartCanvas)ChartCanvas.this).cachedImage.getBounds().height, 0, 0, rect.width, rect.height);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                try {
                    ChartCanvas.this.buildChart();
                    ChartCanvas.this.cachedImage = null;
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void buildChart() {
        Point size = this.getSize();
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)size.x, (double)size.y);
        int resolution = this.render.getDisplayServer().getDpiResolution();
        bo.scale(72.0 / (double)resolution);
        if (this.chart == null) {
            return;
        }
        Image image = new Image((Device)Display.getCurrent(), size.x, size.y);
        GC gc = new GC((Drawable)image);
        this.render.setProperty("device.output.context", (Object)gc);
        Generator gr = Generator.instance();
        try {
            this.state = gr.build(this.render.getDisplayServer(), this.chart, bo, null, null, null);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void drawToCachedImage(Rectangle size) {
        GC gc = null;
        try {
            if (this.cachedImage != null) {
                this.cachedImage.dispose();
            }
            this.cachedImage = new Image((Device)Display.getCurrent(), size.width, size.height);
            gc = new GC((Drawable)this.cachedImage);
            this.render.setProperty("device.output.context", (Object)gc);
            if (this.state == null) {
                return;
            }
            try {
                Generator gr = Generator.instance();
                gr.render(this.render, this.state);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        if (this.cachedImage != null) {
            this.cachedImage.dispose();
        }
        this.cachedImage = null;
        this.chart = chart;
    }

    public void dispose() {
        try {
            if (this.cachedImage != null) {
                this.cachedImage.dispose();
            }
            super.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

