/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import java.sql.SQLException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class KillSessionAction
implements IViewActionDelegate {
    public static final String ID = "KillSessionActionID";
    private SingleResultSetView fView;

    public void init(IViewPart view) {
        this.fView = (SingleResultSetView)view;
    }

    public void run(IAction action) {
        int[] sel = this.fView.getSelectionIndices();
        if (sel.length == 0) {
            Application.openDialog("error", "Please select session", 1);
            return;
        }
        ConnectionProperties p = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(this.fView.getConnectionPropertiesDisplay());
        ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(p);
        try {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < sel.length) {
                ResultSetDataHolder2 rdh = this.fView.getResultSetDataHolders()[0];
                String sid = rdh.getStringData(sel[i], "SID");
                String serial = rdh.getStringData(sel[i], "SERIAL#");
                String user = rdh.getStringData(sel[i], "OSUSER");
                String machine = rdh.getStringData(sel[i], "MACHINE");
                String statement = String.format("ALTER SYSTEM KILL SESSION '%s,%s'", sid, serial);
                sql.execute(statement);
                buf.append("\n SID[").append(sid).append(",").append(serial);
                buf.append("] [").append(user).append(",").append(machine);
                buf.append("]");
                ++i;
            }
            Application.openDialog("result", "session killed" + buf, 2);
        }
        catch (SQLException e) {
            Application.openErrorDialog(null, "error", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

