/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.util.ConnectionSettingDialog;
import hiro.yoshioka.ui.action.Messages;
import hiro.yoshioka.ui.view.AbsResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ResultSetReflectAction
implements IViewActionDelegate,
IRequestListener {
    public static final String ID = "ResultSetReflectActionID";
    private AbsResultSetView fView;

    public void init(IViewPart view) {
        this.fView = (AbsResultSetView)view;
    }

    public void run(IAction action) {
        try {
            boolean result = this.fView.reflect();
            if (result) {
                action.setEnabled(false);
            }
            String disp = this.fView.getConnectionPropertiesDisplay();
            ConnectionSettingBean beans = SQLServerThread.getSQLServer().getConnectionSettingBean();
            ConnectionProperties p = beans.getConnectionPropertiesByDisplay(disp);
            if (p.isAutoCommit()) {
                if (result) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Information", (String)"Auto commited.");
                }
            } else {
                ConnectionSettingDialog dialog = new ConnectionSettingDialog(Display.getCurrent().getActiveShell(), beans.getConnectedConnectionSet(), p, 2);
                int ret = dialog.open();
                SQLOperationType operation = null;
                if (ret == 500) {
                    operation = SQLOperationType.COMMIT;
                } else if (ret == 600) {
                    operation = SQLOperationType.ROLLBACK;
                } else {
                    return;
                }
                Request fRequest = new Request(operation, p);
                fRequest.addListener((IRequestListener)this);
                SQLServerThread.putRequest((Request)fRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void called_pre(Request request, SQLOperationType operation) {
    }

    public void beginTask(String taskName, int row) {
    }

    public void called_done(Request request, SQLOperationType operation, ConnectionProperties properties, Object o) {
        Application.setStatus(String.format(Messages.getString("TransactionAction.result"), new Date(), this.fView.getConnectionPropertiesDisplay(), operation.name(), request.result));
        Throwable ex = request.getException();
        if (ex == null) {
            Application.exec(new Runnable(){

                @Override
                public void run() {
                    ResultSetReflectAction.this.fView.refresh();
                }
            });
        } else {
            Application.openErrorDialog(null, "SQLOperation[" + operation + "] failur " + properties.getDisplayString(), ex);
        }
    }

    public void subTask(String subTaskName) {
    }

    public void worked(int i) {
    }
}

