/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.ui.view.DiffResultSetView;
import hiro.yoshioka.ui.view.IResultSetView;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class SelectAndDiffExecuteAction
implements IViewActionDelegate {
    public static String ID = "SelectAndDiffExecuteActionID";
    protected Log fLogger = LogFactory.getLog(this.getClass());
    IResultSetView fIView;

    public void init(IViewPart view) {
        this.fIView = (IResultSetView)view;
    }

    public void run(IAction action) {
        MyJob job = new MyJob(this.fIView.getTitle());
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    class MyJob
    extends Job
    implements Runnable {
        DiffToResultSetDataHolder[] fResult;

        public MyJob(String name) {
            super("SELECTION TABLES [" + name + "]");
            this.fResult = new DiffToResultSetDataHolder[0];
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus ret = Status.CANCEL_STATUS;
            try {
                String[] execution_sql = SelectAndDiffExecuteAction.this.fIView.getSQLStatements();
                monitor.beginTask("EXECUTE SELECTION", execution_sql.length + 1);
                ArrayList<DiffToResultSetDataHolder> rList = new ArrayList<DiffToResultSetDataHolder>();
                int i = 0;
                while (i < execution_sql.length) {
                    String disp = SelectAndDiffExecuteAction.this.fIView.getConnectionPropertiesDisplay();
                    ConnectionProperties p = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(disp);
                    ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(p);
                    ResultSetDataHolder2 rdh = null;
                    try {
                        monitor.setTaskName("SELECT " + SelectAndDiffExecuteAction.this.fIView.getResultSetDataHolders()[i].getTableNameE());
                        rdh = sql.executePrepareQuery(execution_sql[i], (Object[])StringUtil.EMPTY_STRING_ARRAY);
                        rdh.setTableName(SelectAndDiffExecuteAction.this.fIView.getResultSetDataHolders()[i].getTableName());
                        rdh.setTableNameE(SelectAndDiffExecuteAction.this.fIView.getResultSetDataHolders()[i].getTableNameE());
                        rdh.setSchemaNameE(SelectAndDiffExecuteAction.this.fIView.getResultSetDataHolders()[i].getSchemaNameE());
                        monitor.worked(1);
                    }
                    catch (SQLException e) {
                        SelectAndDiffExecuteAction.this.fLogger.warn((Object)e);
                    }
                    DBRoot root = p.getDBRootResource();
                    root.getCurrentSchema();
                    DiffToResultSetDataHolder differ = new DiffToResultSetDataHolder();
                    int[] dp = SelectAndDiffExecuteAction.this.fIView.getMatchingPos()[i];
                    if (dp.length == 0) {
                        dp = new int[1];
                    }
                    int m = 0;
                    while (m < dp.length) {
                        SelectAndDiffExecuteAction.this.fLogger.info((Object)("Compare Key->" + dp[m]));
                        ++m;
                    }
                    if (rdh.getPkPositions() == null || rdh.getPkPositions().length == 0) {
                        int[] dp2 = new int[dp.length];
                        int n = 0;
                        while (n < dp.length) {
                            dp2[n] = dp[n] - 1;
                            ++n;
                        }
                        rdh.setPkPositions(dp2);
                    }
                    differ.diffConfigure((StringRecordDataHolder)SelectAndDiffExecuteAction.this.fIView.getResultSetDataHolders()[i], (StringRecordDataHolder)rdh, dp);
                    differ.diff();
                    rList.add(differ);
                    ++i;
                }
                this.fResult = rList.toArray(new DiffToResultSetDataHolder[rList.size()]);
                monitor.setTaskName("Result");
                monitor.worked(1);
                Application.exec(this);
            }
            catch (Throwable e) {
                SelectAndDiffExecuteAction.this.fLogger.warn((Object)e);
                ret = Status.CANCEL_STATUS;
            }
            return ret;
        }

        @Override
        public void run() {
            if (SelectAndDiffExecuteAction.this.fIView instanceof DiffResultSetView) {
                ((DiffResultSetView)SelectAndDiffExecuteAction.this.fIView).setInput(this.fResult, true);
                ResultSetDataHolder2[][] dm = ((DiffResultSetView)SelectAndDiffExecuteAction.this.fIView).getInput();
                String title = String.format("%tT \u7acd\ufffd %tT", dm[0][0].createTime, dm[1][0].createTime);
                ((DiffResultSetView)SelectAndDiffExecuteAction.this.fIView).setPartName("Compare [" + title + "]");
            } else {
                DiffResultSetView view = Application.showAndCreateDiffRstView(SelectAndDiffExecuteAction.this.fIView.getTitle());
                String title = String.format("%tT \u7acd\ufffd %tT", SelectAndDiffExecuteAction.this.fIView.getResultSetDataHolders()[0].createTime, ((ResultSetDataHolder)this.fResult[0].getRightTarget()).createTime);
                view.setPartName("Compare [" + title + "]");
                view.setInput(this.fResult, true);
                view.setConnectionPropertiesDisplay(SelectAndDiffExecuteAction.this.fIView.getConnectionPropertiesDisplay());
                view.setSQLStatements(SelectAndDiffExecuteAction.this.fIView.getSQLStatements());
                view.setMatchingPos(SelectAndDiffExecuteAction.this.fIView.getMatchingPos());
            }
        }
    }
}

