/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.wolfdbmanager;

import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.util.SQLHistroyManager;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    protected static Log fLogger = LogFactory.getLog(Activator.class.getClass());
    SQLServerThread fSingle;
    static final File configDir = new File("w_config");
    public static final String PLUGIN_ID = "WolfDBManagerID";
    private static Activator plugin;

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static URL getURL(String path) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        if (!BundleUtility.isReady((Bundle)bundle)) {
            fLogger.error((Object)("BundleUtility.is not Ready[" + bundle + "]"));
            return null;
        }
        URL fullPathString = BundleUtility.find((Bundle)bundle, (String)path);
        if (fullPathString == null) {
            fLogger.error((Object)"fullPathString is null");
        }
        return fullPathString;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        fLogger.trace((Object)("start... " + context));
        this.fSingle = SQLServerThread.getSQLServer();
        this.fSingle.init(configDir);
        System.out.println("loader~=" + Thread.currentThread().getContextClassLoader());
        SQLHistroyManager.getInstance();
        ResourceMarker.createThema();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        System.out.println("loader~=" + Thread.currentThread().getContextClassLoader());
        SQLHistroyManager.getInstance().save();
        super.stop(context);
        this.fSingle.dispose();
        try {
            ImageManager.dispose();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

