/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.wolfdbmanager.resource;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.wolfdbmanager.Activator;
import hiro.yoshioka.wolfdbmanager.resource.MyImageDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Shell;

public class ImageManager {
    protected static Log fLogger = LogFactory.getLog(ImageManager.class.getClass());
    private static final String SQL_EDITOR = "sqleditor";
    private static final String[] EXT_LISTS = new String[]{".ico", ".png", ".gif"};
    private static final Pattern P = Pattern.compile("(.*)[.].+", 2);
    private static ImageRegistry imageRegistry;
    public static final String SKIN_PATH = "skin";
    public static final String SKIN_ICON_PATH = "skin/icons";
    public static final File ICON_File;
    public static final String THEMA_PATH = "thema";
    public static final String THEMA_IMAGES_PATH = "thema/images";
    public static boolean IMAGE_WRAPPED;
    public static final String ACTION_START = "action/start.png";
    public static final String ACTION_EDIT_SQL = "action/edit_sql.png";
    public static final String ACTION_35_COMMIT = "action/35commit.gif";
    public static final String ACTION_36_ROLLBACK = "action/36rollback.gif";
    public static final String ACTION_38_SHOW_SESSION = "action/38show_session.gif";
    public static final String ACTION_39_CANCEL = "action/39cancel.gif";
    public static final String ACTION_40_OPEN_SQL_EDITOR = "action/40open_sql_editor.gif";
    public static final String ACTION_41_OPEN_LST_EDITOR = "action/table_analysis.png";
    public static final String ACTION_42_OPEN_SQT_EDITOR = "action/42open_sqt_editor.gif";
    public static final String ACTION_31_EXPLAIN_PLAN = "action/31explain_plan.gif";
    public static final String ACTION_41_FORMAT = "action/41format.gif";
    public static final String ACTION_42_BACK = "action/42back.gif";
    public static final String ACTION_42_TEST_RUNNER = "action/42open_sqt_editor.gif";
    public static final String ACTION_43_GO = "action/43go.gif";
    public static final String ACTION_52_reflect = "action/52reflect.gif";
    public static final String ACTION_53_SORT = "action/53sort.gif";
    public static final String ACTION_54_COMPARE = "action/54compare.gif";
    public static final String ACTION_55_IMPORT = "action/55import.gif";
    public static final String ACTION_56_EXPORT = "action/56export.gif";
    public static final String ACTION_60_EXECUTE = "action/60execute.gif";
    public static final String ACTION_61_SAVE_EDIT = "action/61save_edit.gif";
    public static final String ACTION_62_STARTED = "action/62started.gif";
    public static final String ACTION_63_CLEAR = "action/clear_co.gif";
    public static final String ACTION_70_BLOB_EXEC = "action/70blob_exec.gif";
    public static final String ACTION_80_LOCK = "action/80lock.gif";
    public static final String ACTION_90_LAYOUT = "action/90layout.gif";
    public static final String DBRESOURCE_01_DATABASE = "dbresource/01database.gif";
    public static final String DBRESOURCE_02_SCHEMA = "dbresource/02schema.png";
    public static final String DBRESOURCE_03_TABLE = "dbresource/03table.gif";
    public static final String DBRESOURCE_04_VIEW = "dbresource/04view.gif";
    public static final String DBRESOURCE_05_TRIGGER = "dbresource/05trigger.gif";
    public static final String DBRESOURCE_06_PROCEDURE = "dbresource/06procedure.gif";
    public static final String DBRESOURCE_07_SYNONYM = "dbresource/07synonym.gif";
    public static final String DBRESOURCE_08_FUNCTION = "dbresource/08function.gif";
    public static final String DBRESOURCE_20_FUNCTION = "dbresource/20function.gif";
    public static final String DBRESOURCE_50_DATE = "dbresource/50date.gif";
    public static final String DBRESOURCE_51_LABEL = "dbresource/51label.gif";
    public static final String DBRESOURCE_52_GENERIC_REG = "dbresource/52genericregister_obj.gif";
    public static final String DBRESOURCE_53_NUMBER = "dbresource/53number.gif";
    public static final String DBRESOURCE_54_COLUMN = "dbresource/54column.gif";
    public static final String DBRESOURCE_55_INDEX = "dbresource/55index.gif";
    public static final String DBRESOURCE_56_TIME_OBJ = "dbresource/56time_obj.gif";
    public static final String DBRESOURCE_70_ER = "dbresource/70er.gif";
    public static final String DBRESOURCE_80_SEQUENCE = "dbresource/80_sequence.gif";
    public static final String VIEW_70_CHECKED = "view/70checked.gif";
    public static final String VIEW_80_PROJECT_FOLDER = "view/80project_folder.gif";
    public static final String VIEW_81_WARNING = "view/81warning.gif";
    public static final String VIEW_82_ERROR = "view/82error.gif";
    public static final String VIEW_83_INFO = "view/83info.gif";
    public static final String VIEW_88_COUNT_VIEW = "view/count.gif";
    public static final String VIEW_99_REQUEST_EXECUTING = "view/99request_executing.gif";
    private static HashMap<String, ImageDescriptor> imgMap;

    static {
        ICON_File = new File(SKIN_ICON_PATH);
        IMAGE_WRAPPED = true;
    }

    public static void createImageDescriptors() {
        fLogger.info((Object)"started...");
        imgMap = new HashMap();
        boolean iconExists = ICON_File.exists() && ICON_File.isDirectory();
        ImageManager.putImage(iconExists, ACTION_START, true);
        ImageManager.putImage(iconExists, ACTION_EDIT_SQL, true);
        ImageManager.putImage(iconExists, ACTION_35_COMMIT, true);
        ImageManager.putImage(iconExists, ACTION_36_ROLLBACK, true);
        ImageManager.putImage(iconExists, ACTION_38_SHOW_SESSION, true);
        ImageManager.putImage(iconExists, ACTION_39_CANCEL, true);
        ImageManager.putImage(iconExists, ACTION_40_OPEN_SQL_EDITOR, true);
        ImageManager.putImage(iconExists, ACTION_41_OPEN_LST_EDITOR, true);
        ImageManager.putImage(iconExists, "action/42open_sqt_editor.gif", true);
        ImageManager.putImage(iconExists, ACTION_80_LOCK, true);
        ImageManager.putImage(iconExists, ACTION_31_EXPLAIN_PLAN, true);
        ImageManager.putImage(iconExists, ACTION_41_FORMAT, true);
        ImageManager.putImage(iconExists, ACTION_42_BACK, true);
        ImageManager.putImage(iconExists, "action/42open_sqt_editor.gif", true);
        ImageManager.putImage(iconExists, ACTION_43_GO, true);
        ImageManager.putImage(iconExists, ACTION_52_reflect, true);
        ImageManager.putImage(iconExists, ACTION_53_SORT, true);
        ImageManager.putImage(iconExists, ACTION_54_COMPARE, true);
        ImageManager.putImage(iconExists, ACTION_55_IMPORT, true);
        ImageManager.putImage(iconExists, ACTION_56_EXPORT, true);
        ImageManager.putImage(iconExists, ACTION_60_EXECUTE, true);
        ImageManager.putImage(iconExists, ACTION_61_SAVE_EDIT, true);
        ImageManager.putImage(iconExists, ACTION_62_STARTED, true);
        ImageManager.putImage(iconExists, ACTION_63_CLEAR, true);
        ImageManager.putImage(iconExists, ACTION_70_BLOB_EXEC, true);
        ImageManager.putImage(iconExists, ACTION_90_LAYOUT, true);
        ImageManager.putImage(iconExists, DBRESOURCE_01_DATABASE, true);
        ImageManager.putImage(iconExists, DBRESOURCE_02_SCHEMA, true);
        ImageManager.putImage(iconExists, DBRESOURCE_03_TABLE, true);
        ImageManager.putImage(iconExists, DBRESOURCE_04_VIEW, true);
        ImageManager.putImage(iconExists, DBRESOURCE_05_TRIGGER, true);
        ImageManager.putImage(iconExists, DBRESOURCE_06_PROCEDURE, true);
        ImageManager.putImage(iconExists, DBRESOURCE_07_SYNONYM, true);
        ImageManager.putImage(iconExists, DBRESOURCE_08_FUNCTION, true);
        ImageManager.putImage(iconExists, DBRESOURCE_20_FUNCTION, true);
        ImageManager.putImage(iconExists, DBRESOURCE_50_DATE, true);
        ImageManager.putImage(iconExists, DBRESOURCE_51_LABEL, true);
        ImageManager.putImage(iconExists, DBRESOURCE_52_GENERIC_REG, true);
        ImageManager.putImage(iconExists, DBRESOURCE_53_NUMBER, true);
        ImageManager.putImage(iconExists, DBRESOURCE_54_COLUMN, true);
        ImageManager.putImage(iconExists, DBRESOURCE_55_INDEX, true);
        ImageManager.putImage(iconExists, DBRESOURCE_56_TIME_OBJ, true);
        ImageManager.putImage(iconExists, DBRESOURCE_70_ER, true);
        ImageManager.putImage(iconExists, DBRESOURCE_80_SEQUENCE, true);
        ImageManager.putImage(iconExists, VIEW_70_CHECKED, true);
        ImageManager.putImage(iconExists, VIEW_80_PROJECT_FOLDER, true);
        ImageManager.putImage(iconExists, VIEW_81_WARNING, true);
        ImageManager.putImage(iconExists, VIEW_82_ERROR, true);
        ImageManager.putImage(iconExists, VIEW_83_INFO, true);
        ImageManager.putImage(iconExists, VIEW_88_COUNT_VIEW, true);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            if (imgMap == null) {
                ImageManager.createImageDescriptors();
            }
            return imgMap.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void putImage(boolean iconExists, String imagePath, boolean usingPluginDescriptor) {
        File skinImage;
        ImageDescriptor descriptor = null;
        if (iconExists && (skinImage = ImageManager.getImageFileGifPngIco(SKIN_ICON_PATH, imagePath)) != null) {
            descriptor = ImageManager.getImageFromFile(skinImage);
        }
        if (descriptor == null) {
            descriptor = usingPluginDescriptor ? ImageManager.getImageDescriptorFromPlugin(imagePath) : ImageManager.getImageFromFile(new File(imagePath));
        }
        if (descriptor.getImageData().height > 16) {
            descriptor = new MyImageDescriptor(ImageManager.resizeImage(descriptor.getImageData(), 16));
        }
        imgMap.put(imagePath, descriptor);
    }

    private static ImageData resizeImage(ImageData imageData, int size) {
        int w = size;
        int h = size;
        if (imageData.height > imageData.width) {
            double div = (double)imageData.height / (double)size;
            w = (int)((double)imageData.width / div);
            if (w <= 0) {
                w = 1;
            }
        } else {
            double div = (double)imageData.width / (double)size;
            h = (int)((double)imageData.height / div);
            if (h <= 0) {
                h = 1;
            }
        }
        return imageData.scaledTo(w, h);
    }

    public static void setShellImages(Shell shell) {
        File f = ImageManager.getImageFileGifPngIco(SKIN_ICON_PATH, "shell/shell.ico");
        if (f != null) {
            shell.setImage(ImageManager.getImageFromFile(f).createImage());
        }
    }

    private static File getImageFileGifPngIco(String path, String imagePath) {
        File skinImage = new File(path, imagePath);
        if (skinImage.exists() && skinImage.isFile()) {
            return skinImage;
        }
        Matcher m = P.matcher(imagePath);
        if (m.matches()) {
            int i = 0;
            while (i < EXT_LISTS.length) {
                imagePath = String.valueOf(m.group(1)) + EXT_LISTS[i];
                skinImage = new File(path, imagePath);
                if (skinImage.exists() && skinImage.isFile()) {
                    return skinImage;
                }
                ++i;
            }
        }
        return null;
    }

    private static List<File> listEditorImage(String editorName) {
        ArrayList<File> list = new ArrayList<File>();
        File viewFolder = new File(SKIN_ICON_PATH, "view");
        if (viewFolder.exists() && viewFolder.isDirectory()) {
            File[] files = viewFolder.listFiles();
            int i = 0;
            while (i < files.length) {
                String name = files[i].getName();
                if (files[i].exists() && files[i].isFile() && name.startsWith(SQL_EDITOR) && (name.endsWith(".ico") || name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".png"))) {
                    list.add(files[i]);
                }
                ++i;
            }
        }
        return list;
    }

    public static boolean hasSQLEditorImage() {
        List<File> list = ImageManager.listEditorImage(SQL_EDITOR);
        return list.size() > 0;
    }

    public static Image getSQLEditorImage() {
        List<File> list = ImageManager.listEditorImage(SQL_EDITOR);
        if (list.size() == 1) {
            return ImageManager.getImageFromFile(list.get(0)).createImage();
        }
        if (list.size() > 1) {
            int index = new Random().nextInt(list.size());
            return ImageManager.getImageFromFile(list.get(index)).createImage();
        }
        return null;
    }

    public static Image getStatusImage() {
        return ImageManager.getStatusImage(PreferenceUtil.getString("STATUS_IMAGE"));
    }

    public static Image getStatusImage(String fi) {
        File f = new File(THEMA_IMAGES_PATH, fi);
        if (f.exists() && f.isFile()) {
            return ImageManager.getImageFromFile(f).createImage();
        }
        return null;
    }

    private static ImageDescriptor getImageFromFile(File f) {
        ImageDescriptor ret;
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        if ((ret = imageRegistry.getDescriptor(f.getAbsolutePath())) == null) {
            URL url = null;
            try {
                url = new URL("file:" + f.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ret = ImageDescriptor.createFromURL(url);
            imageRegistry.put(f.getAbsolutePath(), ret);
        }
        return ret;
    }

    public static final void dispose() {
        if (imageRegistry != null) {
            imageRegistry.dispose();
        }
    }

    private static ImageDescriptor getImageDescriptorFromPlugin(String file) {
        String target = "/icons/" + file;
        ImageDescriptor desc = Activator.getImageDescriptor(target);
        return desc;
    }
}

